/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.jms;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import javax.jms.BytesMessage;
import javax.jms.JMSException;
import javax.jms.MessageNotReadableException;
import javax.jms.MessageNotWriteableException;
import org.xmlBlaster.jms.XBMessage;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.def.ErrorCode;
import org.xmlBlaster.util.key.MsgKeyData;
import org.xmlBlaster.util.qos.MsgQosData;

public class XBBytesMessage
extends XBMessage
implements BytesMessage {
    private static final String ME = "XBBytesMessage";
    private DataInputStream is;
    private DataOutputStream os;
    private ByteArrayOutputStream baos;

    XBBytesMessage(Global global, MsgKeyData key, byte[] content, MsgQosData qos) throws JMSException {
        super(global, key, content, qos, 1);
        if (this.content != null) {
            this.readOnly = true;
            this.writeOnly = false;
            this.is = new DataInputStream(new ByteArrayInputStream(this.content));
        } else {
            this.readOnly = false;
            this.writeOnly = true;
            this.baos = new ByteArrayOutputStream();
            this.os = new DataOutputStream(this.baos);
        }
    }

    private void getterCheck(String methodName) throws MessageNotReadableException {
        if (this.writeOnly || this.is == null) {
            throw new MessageNotReadableException("XBBytesMessage writeonly message: not allowed to read on operation '" + methodName + "'");
        }
    }

    private void setterCheck(String methodName) throws MessageNotWriteableException {
        if (this.readOnly || this.os == null) {
            throw new MessageNotWriteableException("could not invoke '" + methodName + "' since the message is in readonly mode");
        }
    }

    public long getBodyLength() throws JMSException {
        return this.content.length;
    }

    public boolean readBoolean() throws JMSException {
        this.getterCheck("readBoolean");
        try {
            return this.is.readBoolean();
        }
        catch (IOException ex) {
            throw new JMSException("XBBytesMessage.readBoolean: " + ex.getMessage(), ErrorCode.USER_ILLEGALARGUMENT.getErrorCode());
        }
    }

    public byte readByte() throws JMSException {
        this.getterCheck("readByte");
        try {
            return this.is.readByte();
        }
        catch (IOException ex) {
            throw new JMSException("XBBytesMessage.readByte: " + ex.getMessage(), ErrorCode.USER_ILLEGALARGUMENT.getErrorCode());
        }
    }

    public int readUnsignedByte() throws JMSException {
        this.getterCheck("readUnsignedByte");
        try {
            return this.is.readUnsignedByte();
        }
        catch (IOException ex) {
            throw new JMSException("XBBytesMessage.readUnsignedByte: " + ex.getMessage(), ErrorCode.USER_ILLEGALARGUMENT.getErrorCode());
        }
    }

    public short readShort() throws JMSException {
        this.getterCheck("readShort");
        try {
            return this.is.readShort();
        }
        catch (IOException ex) {
            throw new JMSException("XBBytesMessage.readShort: " + ex.getMessage(), ErrorCode.USER_ILLEGALARGUMENT.getErrorCode());
        }
    }

    public int readUnsignedShort() throws JMSException {
        this.getterCheck("readUnsignedShort");
        try {
            return this.is.readUnsignedShort();
        }
        catch (IOException ex) {
            throw new JMSException("XBBytesMessage.readUnsignedShort: " + ex.getMessage(), ErrorCode.USER_ILLEGALARGUMENT.getErrorCode());
        }
    }

    public char readChar() throws JMSException {
        this.getterCheck("readChar");
        try {
            return this.is.readChar();
        }
        catch (IOException ex) {
            throw new JMSException("XBBytesMessage.readChar: " + ex.getMessage(), ErrorCode.USER_ILLEGALARGUMENT.getErrorCode());
        }
    }

    public int readInt() throws JMSException {
        this.getterCheck("readInt");
        try {
            return this.is.readInt();
        }
        catch (IOException ex) {
            throw new JMSException("XBBytesMessage.readInt: " + ex.getMessage(), ErrorCode.USER_ILLEGALARGUMENT.getErrorCode());
        }
    }

    public long readLong() throws JMSException {
        this.getterCheck("readLong");
        try {
            return this.is.readLong();
        }
        catch (IOException ex) {
            throw new JMSException("XBBytesMessage.readLong: " + ex.getMessage(), ErrorCode.USER_ILLEGALARGUMENT.getErrorCode());
        }
    }

    public float readFloat() throws JMSException {
        this.getterCheck("readFloat");
        try {
            return this.is.readFloat();
        }
        catch (IOException ex) {
            throw new JMSException("XBBytesMessage.readFloat: " + ex.getMessage(), ErrorCode.USER_ILLEGALARGUMENT.getErrorCode());
        }
    }

    public double readDouble() throws JMSException {
        this.getterCheck("readDouble");
        try {
            return this.is.readDouble();
        }
        catch (IOException ex) {
            throw new JMSException("XBBytesMessage.readDouble: " + ex.getMessage(), ErrorCode.USER_ILLEGALARGUMENT.getErrorCode());
        }
    }

    public String readUTF() throws JMSException {
        this.getterCheck("readUTF");
        try {
            return this.is.readUTF();
        }
        catch (IOException ex) {
            throw new JMSException("XBBytesMessage.readUTF: " + ex.getMessage(), ErrorCode.USER_ILLEGALARGUMENT.getErrorCode());
        }
    }

    public int readBytes(byte[] value) throws JMSException {
        return this.readBytes(value, value.length);
    }

    public int readBytes(byte[] value, int length) throws JMSException {
        this.getterCheck("readBytes");
        if (length < 0 || length > value.length) {
            throw new IndexOutOfBoundsException("XBBytesMessage.readBytes: length='" + length + "' array length='" + value.length + "'");
        }
        try {
            int size = 0;
            int offset = 0;
            while ((size = this.is.available()) > 0) {
                if (offset + size > length) {
                    size = length - offset;
                }
                if (size < 1) break;
                this.is.read(value, offset, size);
            }
            int sum = size + offset;
            if (sum < 1) {
                return -1;
            }
            return sum;
        }
        catch (IOException ex) {
            throw new JMSException("XBBytesMessage.readBytes: " + ex.getMessage(), ErrorCode.USER_ILLEGALARGUMENT.getErrorCode());
        }
    }

    public void writeBoolean(boolean value) throws JMSException {
        this.setterCheck("writeBoolean");
        try {
            this.os.writeBoolean(value);
        }
        catch (IOException ex) {
            throw new JMSException("XBBytesMessage.writeBoolean: " + ex.getMessage(), ErrorCode.USER_ILLEGALARGUMENT.getErrorCode());
        }
    }

    public void writeByte(byte value) throws JMSException {
        this.setterCheck("writeByte");
        try {
            this.os.writeByte(value);
        }
        catch (IOException ex) {
            throw new JMSException("XBBytesMessage.writeByte: " + ex.getMessage(), ErrorCode.USER_ILLEGALARGUMENT.getErrorCode());
        }
    }

    public void writeShort(short value) throws JMSException {
        this.setterCheck("writeShort");
        try {
            this.os.writeShort(value);
        }
        catch (IOException ex) {
            throw new JMSException("XBBytesMessage.writeShort: " + ex.getMessage(), ErrorCode.USER_ILLEGALARGUMENT.getErrorCode());
        }
    }

    public void writeChar(char value) throws JMSException {
        this.setterCheck("writeChar");
        try {
            this.os.writeChar(value);
        }
        catch (IOException ex) {
            throw new JMSException("XBBytesMessage.writeChar: " + ex.getMessage(), ErrorCode.USER_ILLEGALARGUMENT.getErrorCode());
        }
    }

    public void writeInt(int value) throws JMSException {
        this.setterCheck("writeInt");
        try {
            this.os.writeInt(value);
        }
        catch (IOException ex) {
            throw new JMSException("XBBytesMessage.writeInt: " + ex.getMessage(), ErrorCode.USER_ILLEGALARGUMENT.getErrorCode());
        }
    }

    public void writeLong(long value) throws JMSException {
        this.setterCheck("writeLong");
        try {
            this.os.writeLong(value);
        }
        catch (IOException ex) {
            throw new JMSException("XBBytesMessage.writeLong: " + ex.getMessage(), ErrorCode.USER_ILLEGALARGUMENT.getErrorCode());
        }
    }

    public void writeFloat(float value) throws JMSException {
        this.setterCheck("writeFloat");
        try {
            this.os.writeFloat(value);
        }
        catch (IOException ex) {
            throw new JMSException("XBBytesMessage.writeFloat: " + ex.getMessage(), ErrorCode.USER_ILLEGALARGUMENT.getErrorCode());
        }
    }

    public void writeDouble(double value) throws JMSException {
        this.setterCheck("writeDouble");
        try {
            this.os.writeDouble(value);
        }
        catch (IOException ex) {
            throw new JMSException("XBBytesMessage.writeDouble: " + ex.getMessage(), ErrorCode.USER_ILLEGALARGUMENT.getErrorCode());
        }
    }

    public void writeUTF(String value) throws JMSException {
        this.setterCheck("writeUTF");
        if (value == null) {
            throw new NullPointerException("XBBytesMessage.writeUTF");
        }
        try {
            this.os.writeUTF(value);
        }
        catch (IOException ex) {
            throw new JMSException("XBBytesMessage.writeUTF: " + ex.getMessage(), ErrorCode.USER_ILLEGALARGUMENT.getErrorCode());
        }
    }

    public void writeBytes(byte[] value) throws JMSException {
        this.setterCheck("writeBytes");
        if (value == null) {
            throw new NullPointerException("XBBytesMessage.writeBytes");
        }
        try {
            this.os.write(value);
        }
        catch (IOException ex) {
            throw new JMSException("XBBytesMessage.writeBytes: " + ex.getMessage(), ErrorCode.USER_ILLEGALARGUMENT.getErrorCode());
        }
    }

    public void writeBytes(byte[] value, int offset, int length) throws JMSException {
        this.setterCheck("writeBytes");
        if (value == null) {
            throw new NullPointerException("XBBytesMessage.writeBytes");
        }
        try {
            this.os.write(value, offset, length);
        }
        catch (IOException ex) {
            throw new JMSException("XBBytesMessage.writeBytes: " + ex.getMessage(), ErrorCode.USER_ILLEGALARGUMENT.getErrorCode());
        }
    }

    public void writeObject(Object value) throws JMSException {
        this.setterCheck("writeObject");
        if (value == null) {
            throw new NullPointerException("XBBytesMessage.writeObject");
        }
        try {
            ObjectOutputStream oo = new ObjectOutputStream(this.os);
            oo.writeObject(value);
        }
        catch (IOException ex) {
            throw new JMSException("XBBytesMessage.writeObject: " + ex.getMessage(), ErrorCode.USER_ILLEGALARGUMENT.getErrorCode());
        }
    }

    public void reset() throws JMSException {
        if (this.writeOnly) {
            this.writeOnly = false;
            this.readOnly = true;
            try {
                this.content = this.baos.toByteArray();
                this.baos.close();
                this.os = null;
                this.baos = null;
                if (this.content == null) {
                    throw new JMSException("XBBytesMessage.reset: content was null", ErrorCode.USER_ILLEGALARGUMENT.getErrorCode());
                }
                this.readOnly = true;
                this.writeOnly = false;
                this.is = new DataInputStream(new ByteArrayInputStream(this.content));
            }
            catch (IOException ex) {
                throw new JMSException("XBBytesMessage.reset: " + ex.getMessage(), ErrorCode.USER_ILLEGALARGUMENT.getErrorCode());
            }
        }
    }
}

