/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.jms;

import javax.jms.ConnectionConsumer;
import javax.jms.ConnectionMetaData;
import javax.jms.Destination;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueSession;
import javax.jms.ServerSessionPool;
import javax.jms.Session;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicSession;
import org.jutils.log.LogChannel;
import org.xmlBlaster.client.I_Callback;
import org.xmlBlaster.client.I_XmlBlasterAccess;
import org.xmlBlaster.client.key.UpdateKey;
import org.xmlBlaster.client.qos.ConnectQos;
import org.xmlBlaster.client.qos.ConnectReturnQos;
import org.xmlBlaster.client.qos.DisconnectQos;
import org.xmlBlaster.client.qos.UpdateQos;
import org.xmlBlaster.jms.XBConnectionMetaData;
import org.xmlBlaster.jms.XBQueueSession;
import org.xmlBlaster.jms.XBSession;
import org.xmlBlaster.jms.XBTopicSession;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.XmlBlasterException;

public class XBConnection
implements QueueConnection,
TopicConnection,
I_Callback {
    private static final String ME = "XBConnection";
    private Global global;
    private LogChannel log;
    private String user;
    private String password;
    private ConnectQos connectQos;
    private ConnectReturnQos connectReturnQos;
    private I_XmlBlasterAccess access;
    private ExceptionListener exceptionListener;
    private XBConnectionMetaData metaData;

    I_XmlBlasterAccess getAccess() {
        return this.access;
    }

    Global getGlobal() {
        return this.global;
    }

    XBConnection(String[] args, String user, String password) throws XmlBlasterException {
        this.global = new Global(args);
        this.user = user;
        this.password = password;
        this.log = this.global.getLog("jms");
        this.access = this.global.getClone(null).getXmlBlasterAccess();
        this.connectQos = this.user == null && this.password == null ? new ConnectQos(this.global) : new ConnectQos(this.global, this.user, this.password);
        this.metaData = new XBConnectionMetaData();
    }

    XBConnection(String[] args) throws XmlBlasterException {
        this(args, null, null);
    }

    public ConnectionConsumer createConnectionConsumer(Destination destination, String msgSelector, ServerSessionPool serverSessionPool, int maxMessages) throws JMSException {
        throw new JMSException("XBConnection 'createConnectionConsumer' not implemented yet");
    }

    public ConnectionConsumer createConnectionConsumer(Topic topic, String msgSelector, ServerSessionPool serverSessionPool, int maxMessages) throws JMSException {
        return this.createConnectionConsumer((Destination)topic, msgSelector, serverSessionPool, maxMessages);
    }

    public ConnectionConsumer createConnectionConsumer(Queue queue, String msgSelector, ServerSessionPool serverSessionPool, int maxMessages) throws JMSException {
        return this.createConnectionConsumer((Destination)queue, msgSelector, serverSessionPool, maxMessages);
    }

    public ConnectionConsumer createDurableConnectionConsumer(Topic topic, String subscriptionName, String msgSelector, ServerSessionPool serverSessionPool, int maxMessages) throws JMSException {
        throw new JMSException("XBConnection 'createDurableConnectionConsumer' not implemented yet");
    }

    public Session createSession(boolean transacted, int ackMode) throws JMSException {
        if (transacted) {
            throw new JMSException("XBConnection 'createSession' in transacted mode not implemented yet");
        }
        return new XBSession(this, ackMode, transacted);
    }

    public TopicSession createTopicSession(boolean transacted, int ackMode) throws JMSException {
        if (transacted) {
            throw new JMSException("XBConnection 'createTopicSession' in transacted mode not implemented yet");
        }
        return new XBTopicSession(this, ackMode, transacted);
    }

    public QueueSession createQueueSession(boolean transacted, int ackMode) throws JMSException {
        if (transacted) {
            throw new JMSException("XBConnection 'createQueueSession' in transacted mode not implemented yet");
        }
        return new XBQueueSession(this, ackMode, transacted);
    }

    public void close() throws JMSException {
        this.stop();
    }

    public String getClientID() throws JMSException {
        return this.connectQos.getUserId();
    }

    public ExceptionListener getExceptionListener() throws JMSException {
        return this.exceptionListener;
    }

    public ConnectionMetaData getMetaData() throws JMSException {
        return this.metaData;
    }

    public void setClientID(String loginName) throws JMSException {
        try {
            this.connectQos.setUserId(loginName);
        }
        catch (XmlBlasterException ex) {
            JMSException jmsEx = new JMSException(ex.getMessage(), ex.getErrorCodeStr());
            if (this.exceptionListener != null) {
                this.exceptionListener.onException(jmsEx);
            }
            throw jmsEx;
        }
    }

    public void setExceptionListener(ExceptionListener exeptionListener) throws JMSException {
        this.exceptionListener = exeptionListener;
    }

    public void start() throws JMSException {
        try {
            this.connectReturnQos = this.access.connect(this.connectQos, this);
        }
        catch (XmlBlasterException ex) {
            JMSException jmsEx = new JMSException(ex.getMessage(), ex.getErrorCodeStr());
            if (this.exceptionListener != null) {
                this.exceptionListener.onException(jmsEx);
            }
            throw jmsEx;
        }
    }

    public void stop() throws JMSException {
        DisconnectQos disconnectQos = new DisconnectQos(this.global);
        this.access.disconnect(disconnectQos);
    }

    public String update(String cbSessionId, UpdateKey updateKey, byte[] content, UpdateQos updateQos) throws XmlBlasterException {
        this.log.warn(ME, "unassociated update invoked for message '" + updateKey.getOid() + "'");
        return "OK";
    }
}

