/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.jms;

import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.StringTokenizer;
import javax.jms.ConnectionMetaData;
import javax.jms.JMSException;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.def.ErrorCode;

public class XBConnectionMetaData
implements ConnectionMetaData {
    private static final String ME = "XBConnectionMetaData";
    static final int MAJOR_VERSION = 1;
    static final int MINOR_VERSION = 1;
    private static final String[] propNames = new String[]{"JMSXRcvTimestamp", "JMSX", "JMSX"};

    XBConnectionMetaData() {
    }

    private int getProviderVersion(boolean isMinor) throws JMSException {
        String version = this.getProviderVersion();
        StringTokenizer tok = new StringTokenizer(version, ".");
        if (tok.countTokens() < 2) {
            throw new JMSException("XBConnectionMetaData.getProviderVersion: exception when parsing version '" + version + "' since it has no separator", ErrorCode.INTERNAL_ILLEGALARGUMENT.getErrorCode());
        }
        try {
            if (isMinor) {
                tok.nextToken();
            }
            return Integer.parseInt(tok.nextToken().trim());
        }
        catch (Exception ex) {
            throw new JMSException("XBConnectionMetaData.getProviderVersion: exception when parsing version '" + version + "' reason: " + ex.getMessage(), ErrorCode.INTERNAL_ILLEGALARGUMENT.getErrorCode());
        }
    }

    public String getJMSVersion() throws JMSException {
        return this.getJMSMajorVersion() + "." + this.getJMSMinorVersion();
    }

    public int getJMSMajorVersion() throws JMSException {
        return 1;
    }

    public int getJMSMinorVersion() throws JMSException {
        return 1;
    }

    public String getJMSProviderName() throws JMSException {
        return "xmlBlaster";
    }

    public String getProviderVersion() throws JMSException {
        return Global.instance().getVersion();
    }

    public int getProviderMajorVersion() throws JMSException {
        return this.getProviderVersion(false);
    }

    public int getProviderMinorVersion() throws JMSException {
        return this.getProviderVersion(true);
    }

    public Enumeration getJMSXPropertyNames() throws JMSException {
        return Collections.enumeration(Arrays.asList(propNames));
    }
}

