/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.jms;

import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageFormatException;
import javax.jms.MessageNotWriteableException;
import javax.jms.Queue;
import javax.jms.Topic;
import org.jutils.log.LogChannel;
import org.xmlBlaster.jms.XBQueue;
import org.xmlBlaster.jms.XBTopic;
import org.xmlBlaster.util.EncodableData;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.MsgUnit;
import org.xmlBlaster.util.SessionName;
import org.xmlBlaster.util.def.ErrorCode;
import org.xmlBlaster.util.def.MethodName;
import org.xmlBlaster.util.def.PriorityEnum;
import org.xmlBlaster.util.key.MsgKeyData;
import org.xmlBlaster.util.qos.MsgQosData;

public class XBMessage
implements Message {
    public static final int TEXT = 0;
    public static final int BYTES = 1;
    public static final int OBJECT = 2;
    public static final int MAP = 3;
    public static final int STREAM = 4;
    public static final int DEFAULT_TYPE = 4;
    private static final String ME = "XBMessage";
    protected Global global;
    protected LogChannel log;
    protected MsgQosData qos;
    protected MsgKeyData key;
    protected byte[] content;
    protected int type;
    protected boolean acknowledged;
    protected boolean readOnly;
    protected boolean writeOnly;
    protected Hashtable extraHeader;
    private boolean propertyReadOnly;

    public XBMessage(Global global, MsgKeyData key, byte[] content, MsgQosData qos, int type) {
        this.global = global;
        this.log = this.global.getLog("jms");
        this.qos = qos;
        this.content = content;
        this.key = key;
        this.extraHeader = new Hashtable();
        this.importExtraHeader();
        if (this.qos == null) {
            this.qos = new MsgQosData(this.global, MethodName.PUBLISH);
        }
        if (this.key == null) {
            this.key = new MsgKeyData(this.global);
        }
        this.type = type;
        this.qos.addClientProperty("jmsMessageType", "" + this.type);
        if (this.content == null) {
            this.writeOnly = true;
        } else {
            this.readOnly = true;
            this.propertyReadOnly = true;
        }
    }

    private void importExtraHeader() {
        if (this.qos != null) {
            String[] keys = this.qos.getClientProperties().keySet().toArray(new String[this.qos.getClientProperties().size()]);
            int i = 0;
            while (i < keys.length) {
                if (keys[i].startsWith("jms/")) {
                    this.extraHeader.put(keys[i].substring("jms/".length()), this.qos.getClientProperties().get(keys[i]));
                }
                ++i;
            }
        }
    }

    private void exportExtraHeader() {
        if (this.qos != null) {
            Enumeration enumer = this.extraHeader.keys();
            while (enumer.hasMoreElements()) {
                String key = (String)enumer.nextElement();
                Object value = this.extraHeader.get(key);
                this.qos.addClientProperty("jms/" + key, EncodableData.getPropertyType(value), (String)value);
            }
        }
    }

    boolean isAcknowledged() {
        return this.acknowledged;
    }

    void setAcknowledged(boolean acknowledged) {
        this.acknowledged = acknowledged;
    }

    public synchronized void acknowledge() throws JMSException {
        this.acknowledged = true;
        this.notify();
    }

    protected final void checkPropertiesReadOnly(String methodName, String key) throws MessageNotWriteableException {
        if (this.propertyReadOnly) {
            throw new MessageNotWriteableException("XBMessage." + methodName + " for '" + key + "' message properties are in readonly modus", ErrorCode.USER_CLIENTCODE.getErrorCode());
        }
        if (key == null || key.trim().length() < 1) {
            throw new IllegalArgumentException("XBMessage." + methodName + ": Empty or null key values are not allowed");
        }
    }

    public void clearBody() throws JMSException {
        this.content = null;
        this.readOnly = false;
        this.writeOnly = true;
    }

    public void clearProperties() throws JMSException {
        this.qos = new MsgQosData(this.global, this.qos.getMethod());
        this.extraHeader.clear();
        this.propertyReadOnly = false;
    }

    public boolean getBooleanProperty(String key) throws JMSException {
        Object obj = this.getObjectProperty(key);
        if (obj instanceof String) {
            return Boolean.getBoolean((String)obj);
        }
        if (obj instanceof Boolean) {
            return (Boolean)obj;
        }
        throw new JMSException("XBMessage.getBooleanProperty('" + key + "') is illegal since of type '" + obj.getClass().getName() + "'", ErrorCode.USER_ILLEGALARGUMENT.getErrorCode());
    }

    public byte getByteProperty(String key) throws JMSException {
        Object obj = this.getObjectProperty(key);
        if (obj instanceof String) {
            return Byte.parseByte((String)obj);
        }
        if (obj instanceof Byte) {
            return (Byte)obj;
        }
        throw new JMSException("XBMessage.getByteProperty('" + key + "') is illegal since of type '" + obj.getClass().getName() + "'", ErrorCode.USER_ILLEGALARGUMENT.getErrorCode());
    }

    public double getDoubleProperty(String key) throws JMSException {
        Object obj = this.getObjectProperty(key);
        if (obj instanceof String) {
            return Double.parseDouble((String)obj);
        }
        if (obj instanceof Float) {
            return ((Float)obj).doubleValue();
        }
        if (obj instanceof Double) {
            return (Double)obj;
        }
        throw new JMSException("XBMessage.getDoubleProperty('" + key + "') is illegal since of type '" + obj.getClass().getName() + "'", ErrorCode.USER_ILLEGALARGUMENT.getErrorCode());
    }

    public float getFloatProperty(String key) throws JMSException {
        Object obj = this.getObjectProperty(key);
        if (obj instanceof String) {
            return Float.parseFloat((String)obj);
        }
        if (obj instanceof Float) {
            return ((Float)obj).floatValue();
        }
        throw new JMSException("XBMessage.getDoubleProperty('" + key + "') is illegal since of type '" + obj.getClass().getName() + "'", ErrorCode.USER_ILLEGALARGUMENT.getErrorCode());
    }

    public int getIntProperty(String key) throws JMSException {
        Object obj = this.getObjectProperty(key);
        if (obj instanceof String) {
            return Integer.parseInt((String)obj);
        }
        if (obj instanceof Byte) {
            return ((Byte)obj).intValue();
        }
        if (obj instanceof Short) {
            return ((Short)obj).intValue();
        }
        if (obj instanceof Integer) {
            return (Integer)obj;
        }
        throw new JMSException("XBMessage.getIntegerProperty('" + key + "') is illegal since of type '" + obj.getClass().getName() + "'", ErrorCode.USER_ILLEGALARGUMENT.getErrorCode());
    }

    public String getJMSCorrelationID() throws JMSException {
        return (String)this.qos.getClientProperties().get("correlationId");
    }

    public byte[] getJMSCorrelationIDAsBytes() throws JMSException {
        return this.getJMSCorrelationID().getBytes();
    }

    public int getJMSDeliveryMode() throws JMSException {
        if (this.qos.isVolatile()) {
            return 1;
        }
        return 2;
    }

    public Destination getJMSDestination() throws JMSException {
        String txt = this.key.getOid();
        if (this.qos.isPtp()) {
            return new XBQueue(txt);
        }
        return new XBTopic(txt);
    }

    public long getJMSExpiration() throws JMSException {
        return this.qos.getRemainingLife();
    }

    public String getJMSMessageID() throws JMSException {
        return "ID:" + this.qos.getRcvTimestamp();
    }

    public int getJMSPriority() throws JMSException {
        return this.qos.getPriority().getInt();
    }

    public boolean getJMSRedelivered() throws JMSException {
        return this.qos.getRedeliver() != 0;
    }

    public Destination getJMSReplyTo() throws JMSException {
        return new XBQueue(this.qos.getSender().getAbsoluteName());
    }

    public long getJMSTimestamp() throws JMSException {
        return this.qos.getRcvTimestamp().getMillis();
    }

    public String getJMSType() throws JMSException {
        return (String)this.qos.getClientProperties().get("JMSType");
    }

    public long getLongProperty(String key) throws JMSException {
        Object obj = this.getObjectProperty(key);
        if (obj instanceof String) {
            return Long.parseLong((String)obj);
        }
        if (obj instanceof Byte) {
            return ((Byte)obj).longValue();
        }
        if (obj instanceof Short) {
            return ((Short)obj).longValue();
        }
        if (obj instanceof Integer) {
            return ((Integer)obj).longValue();
        }
        if (obj instanceof Long) {
            return (Long)obj;
        }
        throw new JMSException("XBMessage.getLongProperty('" + key + "') is illegal since of type '" + obj.getClass().getName() + "'", ErrorCode.USER_ILLEGALARGUMENT.getErrorCode());
    }

    public Object getObjectProperty(String key) throws JMSException {
        return this.qos.getClientProperty(key).getObjectValue();
    }

    public Enumeration getPropertyNames() throws JMSException {
        return Collections.enumeration(this.qos.getClientProperties().entrySet());
    }

    public short getShortProperty(String key) throws JMSException {
        Object obj = this.getObjectProperty(key);
        if (obj instanceof String) {
            return Short.parseShort((String)obj);
        }
        if (obj instanceof Byte) {
            return ((Byte)obj).shortValue();
        }
        if (obj instanceof Short) {
            return (Short)obj;
        }
        throw new JMSException("XBMessage.getShortProperty('" + key + "') is illegal since of type '" + obj.getClass().getName() + "'", ErrorCode.USER_ILLEGALARGUMENT.getErrorCode());
    }

    public String getStringProperty(String key) throws JMSException {
        return this.qos.getClientProperties().get(key).toString();
    }

    public boolean propertyExists(String key) throws JMSException {
        return this.qos.getClientProperties().containsKey(key);
    }

    public void setBooleanProperty(String key, boolean value) throws JMSException {
        this.checkPropertiesReadOnly("setBooleanProperty", key);
        this.qos.addClientProperty(key, value);
    }

    public void setByteProperty(String key, byte value) throws JMSException {
        this.checkPropertiesReadOnly("setByteProperty", key);
        this.qos.addClientProperty(key, value);
    }

    public void setDoubleProperty(String key, double value) throws JMSException {
        this.checkPropertiesReadOnly("setDoubleProperty", key);
        this.qos.addClientProperty(key, value);
    }

    public void setFloatProperty(String key, float value) throws JMSException {
        this.checkPropertiesReadOnly("setFloatProperty", key);
        this.qos.addClientProperty(key, value);
    }

    public void setIntProperty(String key, int value) throws JMSException {
        this.checkPropertiesReadOnly("setIntProperty", key);
        this.qos.addClientProperty(key, value);
    }

    public void setJMSCorrelationID(String correlationId) throws JMSException {
        this.qos.addClientProperty("correlationId", correlationId);
    }

    public void setJMSCorrelationIDAsBytes(byte[] correlationId) throws JMSException {
        this.setJMSCorrelationID(new String(correlationId));
    }

    public void setJMSDeliveryMode(int deliveryMode) throws JMSException {
        if (deliveryMode == 2) {
            this.qos.setPersistent(true);
        } else if (deliveryMode == 1) {
            this.qos.setPersistent(false);
        } else {
            throw new JMSException("setJMSDeliveryMode('" + deliveryMode + "'): delivery mode is invalid", ErrorCode.USER_CONFIGURATION.getErrorCode());
        }
    }

    public void setJMSDestination(Destination destination) throws JMSException {
        if (destination instanceof Topic) {
            String txt = ((Topic)destination).getTopicName();
            this.key.setOid(txt);
        } else if (destination instanceof Queue) {
            String txt = ((Queue)destination).getQueueName();
            org.xmlBlaster.util.qos.address.Destination dst = new org.xmlBlaster.util.qos.address.Destination(new SessionName(this.global, txt));
            this.qos.addDestination(dst);
        } else {
            throw new JMSException("XBMessage.setJMSDestination: unallowed destination type (must be either topic or queue) but is '" + destination.getClass().getName(), ErrorCode.USER_ILLEGALARGUMENT.getErrorCode());
        }
    }

    public void setJMSExpiration(long lifeTime) throws JMSException {
        this.qos.setLifeTime(lifeTime);
    }

    public void setJMSMessageID(String messageId) throws JMSException {
        this.qos.addClientProperty("JMSMessageID", messageId);
    }

    public void setJMSPriority(int priority) throws JMSException {
        try {
            this.qos.setPriority(PriorityEnum.toPriorityEnum(priority));
        }
        catch (IllegalArgumentException ex) {
            throw new JMSException(ex.getMessage(), ErrorCode.USER_ILLEGALARGUMENT.getErrorCode());
        }
    }

    public void setJMSRedelivered(boolean redelivered) throws JMSException {
        this.qos.addClientProperty("JMSRedelivered", redelivered);
    }

    public void setJMSReplyTo(Destination sender) throws JMSException {
        if (sender instanceof Topic) {
            String txt = ((Topic)sender).getTopicName();
            this.qos.setSender(new SessionName(this.global, txt));
        } else if (sender instanceof Queue) {
            String txt = ((Queue)sender).getQueueName();
            this.qos.setSender(new SessionName(this.global, txt));
        } else {
            throw new JMSException("XBMessage.setJMSReplyTo: unallowed destination type (must be either topic or queue) but is '" + sender.getClass().getName(), ErrorCode.USER_ILLEGALARGUMENT.getErrorCode());
        }
    }

    public void setJMSTimestamp(long timestamp) throws JMSException {
        this.qos.addClientProperty("jmsTimestamp", "" + timestamp);
    }

    public void setJMSType(String jmsType) throws JMSException {
        this.qos.addClientProperty("JMSType", jmsType);
    }

    public void setLongProperty(String key, long value) throws JMSException {
        this.checkPropertiesReadOnly("setLongProperty", key);
        this.qos.addClientProperty(key, value);
    }

    public void setObjectProperty(String key, Object value) throws JMSException {
        if (value instanceof String) {
            this.setStringProperty(key, (String)value);
        }
        if (value instanceof Boolean) {
            this.setBooleanProperty(key, (Boolean)value);
        }
        if (value instanceof Byte) {
            this.setByteProperty(key, (Byte)value);
        }
        if (value instanceof Short) {
            this.setShortProperty(key, (Short)value);
        }
        if (value instanceof Integer) {
            this.setIntProperty(key, (Integer)value);
        }
        if (value instanceof Long) {
            this.setLongProperty(key, (Long)value);
        }
        if (value instanceof Float) {
            this.setFloatProperty(key, ((Float)value).floatValue());
        }
        if (value instanceof Double) {
            this.setDoubleProperty(key, (Double)value);
        }
        throw new MessageFormatException("XBMessage.setObjectProperty: prop '" + key + "' is of type '" + value.getClass().getName() + "' which is not allowed here", ErrorCode.USER_ILLEGALARGUMENT.getErrorCode());
    }

    public void setShortProperty(String key, short value) throws JMSException {
        this.checkPropertiesReadOnly("setShortProperty", key);
        this.qos.addClientProperty(key, value);
    }

    public void setStringProperty(String key, String value) throws JMSException {
        this.checkPropertiesReadOnly("setStringProperty", key);
        this.qos.addClientProperty(key, value);
    }

    MsgUnit getMsgUnit() {
        this.exportExtraHeader();
        return new MsgUnit(this.key, this.content, this.qos);
    }
}

