/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.jms;

import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import org.jutils.log.LogChannel;
import org.xmlBlaster.jms.XBSession;
import org.xmlBlaster.util.Global;

public class XBMessageConsumer
implements MessageConsumer,
MessageListener {
    private static final String ME = "XBMessageConsumer";
    protected Global global;
    protected LogChannel log;
    protected String msgSelector;
    protected MessageListener msgListener;
    protected XBSession session;
    protected boolean listenerStarted;
    protected boolean waitingForReceive;
    protected Message msg;

    XBMessageConsumer(XBSession session, String msgSelector) {
        this.session = session;
        this.global = this.session.global;
        this.log = this.global.getLog("jms");
        this.msgSelector = msgSelector;
    }

    protected final synchronized void startToListen() throws JMSException {
        if (this.listenerStarted) {
            return;
        }
        if (this.session != null) {
            this.session.setMessageListener(this);
        }
        this.listenerStarted = true;
    }

    public void close() throws JMSException {
        if (this.session != null) {
            this.session.close();
        }
    }

    public MessageListener getMessageListener() throws JMSException {
        return this.msgListener;
    }

    public String getMessageSelector() throws JMSException {
        return this.msgSelector;
    }

    public Message receive() throws JMSException {
        return this.receive(-1L);
    }

    public synchronized Message receive(long delay) throws JMSException {
        throw new JMSException("XBMessageConsumer 'receive' not implemented yet");
    }

    public synchronized Message receiveNoWait() throws JMSException {
        return this.receive(0L);
    }

    public synchronized void setMessageListener(MessageListener msgListener) throws JMSException {
        if (this.msgListener == null) {
            this.msgListener = msgListener;
            this.startToListen();
        } else {
            this.msgListener = msgListener;
        }
    }

    public void onMessage1(Message msg) {
        if (this.msgListener != null) {
            this.msgListener.onMessage(msg);
        }
    }

    public void onMessage(Message msg) {
        this.msg = msg;
        if (this.waitingForReceive) {
            XBMessageConsumer xBMessageConsumer = this;
            synchronized (xBMessageConsumer) {
                if (this.waitingForReceive) {
                    this.notify();
                }
            }
        }
        if (this.msgListener != null) {
            this.msgListener.onMessage(this.msg);
        } else {
            XBMessageConsumer xBMessageConsumer = this;
            synchronized (xBMessageConsumer) {
                if (this.msgListener != null) {
                    return;
                }
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        this.msg = null;
    }
}

