/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.jms;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import javax.jms.JMSException;
import javax.jms.ObjectMessage;
import org.xmlBlaster.jms.XBMessage;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.def.ErrorCode;
import org.xmlBlaster.util.key.MsgKeyData;
import org.xmlBlaster.util.qos.MsgQosData;

public class XBObjectMessage
extends XBMessage
implements ObjectMessage {
    private static final String ME = "XBTextMessage";

    XBObjectMessage(Global global, MsgKeyData key, byte[] content, MsgQosData qos) {
        super(global, key, content, qos, 2);
    }

    public Serializable getObject() throws JMSException {
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(this.content);
            ObjectInputStream ois = new ObjectInputStream(bais);
            Serializable ret = (Serializable)ois.readObject();
            ois.close();
            return ret;
        }
        catch (IOException ex) {
            throw new JMSException(ex.getMessage(), ErrorCode.RESOURCE_FILEIO.getErrorCode());
        }
        catch (ClassNotFoundException ex) {
            throw new JMSException(ex.getMessage(), ErrorCode.INTERNAL_ILLEGALARGUMENT.getErrorCode());
        }
    }

    public void setObject(Serializable object) throws JMSException {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(object);
            this.content = baos.toByteArray();
        }
        catch (IOException ex) {
            throw new JMSException(ex.getMessage(), ErrorCode.RESOURCE_FILEIO.getErrorCode());
        }
    }
}

