/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.jms;

import java.io.Serializable;
import java.util.HashMap;
import javax.jms.BytesMessage;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.QueueBrowser;
import javax.jms.Session;
import javax.jms.StreamMessage;
import javax.jms.TemporaryQueue;
import javax.jms.TemporaryTopic;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.jms.TopicSubscriber;
import org.jutils.log.LogChannel;
import org.xmlBlaster.client.I_Callback;
import org.xmlBlaster.client.key.SubscribeKey;
import org.xmlBlaster.client.key.UnSubscribeKey;
import org.xmlBlaster.client.key.UpdateKey;
import org.xmlBlaster.client.qos.SubscribeQos;
import org.xmlBlaster.client.qos.SubscribeReturnQos;
import org.xmlBlaster.client.qos.UnSubscribeQos;
import org.xmlBlaster.client.qos.UpdateQos;
import org.xmlBlaster.jms.XBBytesMessage;
import org.xmlBlaster.jms.XBConnection;
import org.xmlBlaster.jms.XBConnectionFactory;
import org.xmlBlaster.jms.XBMapMessage;
import org.xmlBlaster.jms.XBMessage;
import org.xmlBlaster.jms.XBMessageConsumer;
import org.xmlBlaster.jms.XBMessageProducer;
import org.xmlBlaster.jms.XBObjectMessage;
import org.xmlBlaster.jms.XBQueue;
import org.xmlBlaster.jms.XBQueueBrowser;
import org.xmlBlaster.jms.XBStreamMessage;
import org.xmlBlaster.jms.XBTemporaryQueue;
import org.xmlBlaster.jms.XBTemporaryTopic;
import org.xmlBlaster.jms.XBTextMessage;
import org.xmlBlaster.jms.XBTopic;
import org.xmlBlaster.jms.XBTopicSubscriber;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.XmlBlasterException;
import org.xmlBlaster.util.def.ErrorCode;

public class XBSession
implements Session,
I_Callback {
    private static final String ME = "XBSession";
    protected Global global;
    protected LogChannel log;
    protected XBConnection connection;
    protected int ackMode;
    protected final boolean noLocalDefault = false;
    protected final boolean durableDefault = false;
    protected final String msgSelectorDefault;
    protected MessageListener msgListener;
    protected HashMap durableSubscriptionMap;
    protected boolean open;
    protected boolean transacted;
    protected Destination destination;
    protected boolean noLocal = false;
    protected String msgSelector = this.msgSelectorDefault;
    protected SubscribeReturnQos subscribeReturnQos;
    protected boolean durable = false;

    XBSession(XBConnection connection, int ackMode, boolean transacted) {
        this.msgSelectorDefault = null;
        this.connection = connection;
        this.global = connection.getGlobal();
        this.log = this.global.getLog("jms");
        this.ackMode = ackMode;
        this.durableSubscriptionMap = new HashMap();
        this.open = true;
        this.transacted = transacted;
    }

    private void subscribe() throws JMSException {
        String oid = null;
        if (this.destination instanceof Topic) {
            oid = ((Topic)this.destination).getTopicName();
        }
        SubscribeKey key = new SubscribeKey(this.global, oid);
        SubscribeQos qos = new SubscribeQos(this.global);
        qos.setWantInitialUpdate(false);
        qos.setWantLocal(!this.noLocal);
        qos.setPersistent(this.durable);
        try {
            this.subscribeReturnQos = this.connection.getAccess().subscribe(key, qos, (I_Callback)this);
        }
        catch (XmlBlasterException ex) {
            throw XBConnectionFactory.convert(ex, "XBSession.subscribe: ");
        }
    }

    public synchronized String update(String cbSessionId, UpdateKey updateKey, byte[] content, UpdateQos updateQos) throws XmlBlasterException {
        if (this.log.CALL) {
            this.log.call(ME, "update cbSessionId='" + cbSessionId + "' oid='" + updateKey.getOid() + "'");
        }
        try {
            if (this.msgListener != null) {
                XBMessage msg;
                int type = 4;
                try {
                    String val = (String)updateQos.getData().getClientProperties().get("jmsMessageType");
                    if (val != null) {
                        type = Integer.parseInt(val);
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                switch (type) {
                    case 0: {
                        msg = new XBTextMessage(this.global, updateKey.getData(), content, updateQos.getData());
                        break;
                    }
                    case 1: {
                        msg = new XBBytesMessage(this.global, updateKey.getData(), content, updateQos.getData());
                        break;
                    }
                    case 2: {
                        msg = new XBObjectMessage(this.global, updateKey.getData(), content, updateQos.getData());
                        break;
                    }
                    case 3: {
                        msg = new XBMapMessage(this.global, updateKey.getData(), content, updateQos.getData());
                        break;
                    }
                    default: {
                        msg = new XBStreamMessage(this.global, updateKey.getData(), content, updateQos.getData());
                    }
                }
                if (msg != null) {
                    if (this.ackMode == 1) {
                        if (this.log.TRACE) {
                            this.log.trace(ME, "update: ack mode: AUTO");
                        }
                        this.msgListener.onMessage((Message)msg);
                        if (this.log.CALL) {
                            this.log.call(ME, "update stop");
                        }
                        return "OK";
                    }
                    if (this.log.TRACE) {
                        if (this.ackMode == 2) {
                            this.log.trace(ME, "update: ack mode: CLIENT");
                        } else {
                            this.log.trace(ME, "update: ack mode: DUPL");
                        }
                    }
                    UpdateThread thread = new UpdateThread(this, msg);
                    XBMessage xBMessage = msg;
                    synchronized (xBMessage) {
                        if (this.log.TRACE) {
                            this.log.trace(ME, "update: starting the thread");
                        }
                        thread.start();
                        if (this.log.TRACE) {
                            this.log.trace(ME, "update: thread started");
                        }
                        msg.wait();
                        if (this.ackMode == 3 || msg.isAcknowledged()) {
                            if (this.log.CALL) {
                                this.log.call(ME, "update stop");
                            }
                            String string = "OK";
                            return string;
                        }
                        throw new XmlBlasterException(this.global, ErrorCode.USER_UPDATE_ERROR, "XBSession.update: the acknowledge mode has not been invoked");
                    }
                }
                throw new XmlBlasterException(this.global, ErrorCode.USER_UPDATE_ERROR, "XBSession.update: the message was null");
            }
            throw new XmlBlasterException(this.global, ErrorCode.USER_UPDATE_ERROR, "XBSession.update: the message listener has not been assigned yet");
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            throw new XmlBlasterException(this.global, ErrorCode.USER_UPDATE_ERROR, "XBSession.update");
        }
    }

    protected void checkIfOpen(String methodName) throws JMSException {
        if (!this.open) {
            throw new JMSException(ME, "the session has been closed, operation '" + methodName + "' not permitted");
        }
    }

    protected void checkIfTransacted(String methodName) throws JMSException {
        if (!this.transacted) {
            throw new JMSException(ME, "the session is not transacted, operation '" + methodName + "' not permitted");
        }
    }

    public TopicSubscriber createDurableSubscriber(Topic topic, String name) throws JMSException {
        this.checkIfOpen("createDurableSubscriber");
        return this.createDurableSubscriber(topic, name, this.msgSelectorDefault, false);
    }

    public TopicSubscriber createDurableSubscriber(Topic topic, String name, String msgSelector, boolean noLocal) throws JMSException {
        this.checkIfOpen("createDurableSubscriber");
        this.destination = topic;
        this.noLocal = noLocal;
        XBTopicSubscriber sub = new XBTopicSubscriber(this, msgSelector);
        this.durableSubscriptionMap.put(name, sub);
        return sub;
    }

    public synchronized void close() throws JMSException {
        this.open = true;
        if (this.subscribeReturnQos != null) {
            String oid = null;
            if (this.destination instanceof Topic) {
                oid = ((Topic)this.destination).getTopicName();
            }
            UnSubscribeKey key = new UnSubscribeKey(this.global, oid);
            UnSubscribeQos qos = new UnSubscribeQos(this.global);
            try {
                this.connection.getAccess().unSubscribe(key, qos);
            }
            catch (XmlBlasterException ex) {
                throw XBConnectionFactory.convert(ex, "XBSession.close(): ");
            }
        }
    }

    public void commit() throws JMSException {
        this.checkIfOpen("commit");
        this.checkIfTransacted("commit");
        this.log.warn(ME, "transacted sessions not implemented");
    }

    public BytesMessage createBytesMessage() throws JMSException {
        this.checkIfOpen("createBytesMessage");
        return new XBBytesMessage(this.global, null, null, null);
    }

    public MapMessage createMapMessage() throws JMSException {
        this.checkIfOpen("createMapMessage");
        return new XBMapMessage(this.global, null, null, null);
    }

    public Message createMessage() throws JMSException {
        this.checkIfOpen("createMessage");
        return new XBMessage(this.global, null, null, null, 4);
    }

    public ObjectMessage createObjectMessage() throws JMSException {
        this.checkIfOpen("createObjectMessage");
        return new XBObjectMessage(this.global, null, null, null);
    }

    public ObjectMessage createObjectMessage(Serializable content) throws JMSException {
        this.checkIfOpen("createObjectMessage");
        ObjectMessage msg = this.createObjectMessage();
        msg.setObject(content);
        return msg;
    }

    public StreamMessage createStreamMessage() throws JMSException {
        this.checkIfOpen("createStreamMessage");
        return new XBStreamMessage(this.global, null, null, null);
    }

    public TextMessage createTextMessage() throws JMSException {
        this.checkIfOpen("createTextMessage");
        return new XBTextMessage(this.global, null, null, null);
    }

    public TextMessage createTextMessage(String text) throws JMSException {
        this.checkIfOpen("createTextMessage");
        return new XBTextMessage(this.global, null, text.getBytes(), null);
    }

    public MessageListener getMessageListener() throws JMSException {
        this.checkIfOpen("getMessageListener");
        return this.msgListener;
    }

    public boolean getTransacted() throws JMSException {
        this.checkIfOpen("getTransacted");
        return this.transacted;
    }

    public void recover() throws JMSException {
        this.checkIfOpen("recover");
        this.checkIfTransacted("recover");
        this.log.warn(ME, "transacted sessions not implemented yet");
    }

    public void rollback() throws JMSException {
        this.checkIfOpen("rollback");
        this.checkIfTransacted("rollback");
        this.log.warn(ME, "transacted sessions not implemented yet");
    }

    public void run() {
    }

    public void setMessageListener(MessageListener msgListener) throws JMSException {
        this.checkIfOpen("setMessageListener");
        this.msgListener = msgListener;
        this.subscribe();
    }

    public Queue createQueue(String name) throws JMSException {
        this.checkIfOpen("createQueue");
        return new XBQueue(name);
    }

    public QueueBrowser createBrowser(Queue queue) throws JMSException {
        this.checkIfOpen("createBrowser");
        return new XBQueueBrowser(queue, null);
    }

    public QueueBrowser createBrowser(Queue queue, String msgSelector) throws JMSException {
        this.checkIfOpen("createBrowser");
        return new XBQueueBrowser(queue, msgSelector);
    }

    public TemporaryQueue createTemporaryQueue() throws JMSException {
        this.checkIfOpen("createTemporaryQueue");
        return new XBTemporaryQueue();
    }

    public int getAcknowledgeMode() throws JMSException {
        this.checkIfOpen("getAcknowledgeMode");
        return this.ackMode;
    }

    public MessageProducer createProducer(Destination destination) throws JMSException {
        this.checkIfOpen("createProducer");
        return new XBMessageProducer(this.connection.getAccess(), destination);
    }

    public MessageConsumer createConsumer(Destination destination) throws JMSException {
        this.checkIfOpen("createConsumer");
        this.destination = destination;
        return new XBMessageConsumer(this, this.msgSelectorDefault);
    }

    public MessageConsumer createConsumer(Destination destination, String msgSelector) throws JMSException {
        this.checkIfOpen("createConsumer");
        this.destination = destination;
        return new XBMessageConsumer(this, msgSelector);
    }

    public MessageConsumer createConsumer(Destination destination, String msgSelector, boolean noLocal) throws JMSException {
        this.checkIfOpen("createConsumer");
        this.destination = destination;
        this.noLocal = noLocal;
        return new XBMessageConsumer(this, msgSelector);
    }

    public Topic createTopic(String name) throws JMSException {
        this.checkIfOpen("createTopic");
        return new XBTopic(name);
    }

    public void unsubscribe(String subName) throws JMSException {
        this.checkIfOpen("unsubscribe");
        try {
            TopicSubscriber sub = (TopicSubscriber)this.durableSubscriptionMap.remove(subName);
            if (sub == null) {
                throw new JMSException(ME, "unsubscribe '" + subName + "'failed because the topic has not been found in this session");
            }
            sub.close();
        }
        catch (Exception ex) {
            throw new JMSException(ME, "unsubscribe '" + subName + "'failed. Cause: " + ex.getMessage());
        }
    }

    public TemporaryTopic createTemporaryTopic() throws JMSException {
        this.checkIfOpen("createTemporaryTopic");
        return new XBTemporaryTopic();
    }

    private class UpdateThread
    extends Thread {
        private XBMessage msg;
        private XBSession parent;

        UpdateThread(XBSession parent, XBMessage msg) {
            super("update-thread");
            this.parent = parent;
            this.msg = msg;
        }

        public void run() {
            if (this.msg != null) {
                if (this.parent.log.CALL) {
                    this.parent.log.call("UpdateThread.run()", "start");
                }
                this.parent.msgListener.onMessage((Message)this.msg);
                if (this.parent.log.CALL) {
                    this.parent.log.call("UpdateThread.run()", "end");
                }
            }
        }
    }
}

