/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.jmxgui;

import java.util.Hashtable;
import org.jutils.log.LogChannel;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xmlBlaster.jmxgui.util.XmlUtil;
import org.xmlBlaster.util.Global;

public class ComponentController {
    private XmlUtil xmlUtil = null;
    private LogChannel log = null;
    private Global glob = null;
    private Hashtable hObjects;
    private static String ME = "ComponentController";

    public ComponentController(Global glob) {
        if (glob == null) {
            glob = Global.instance();
        }
        this.xmlUtil = new XmlUtil();
        this.log = glob.getLog("jmxGUI");
        this.hObjects = new Hashtable();
        Document doc = this.xmlUtil.loadConfig();
        this.buildDOM(doc);
    }

    private void buildDOM(Document doc) throws DOMException {
        NodeList nl = doc.getElementsByTagName("component");
        int i = 0;
        while (i < nl.getLength()) {
            Node n = nl.item(i);
            NamedNodeMap nn = n.getAttributes();
            String className = nn.getNamedItem("class").getNodeValue();
            String key = nn.getNamedItem("name").getNodeValue();
            this.log.info(ME, " name of the class to load: " + className);
            this.log.info(ME, "class will be stored with key " + key + " in hashtable");
            try {
                Class<?> cl = Class.forName(className);
                if (cl != null) {
                    this.hObjects.put(key, cl);
                }
            }
            catch (ClassNotFoundException ex) {
                this.log.warn(ME, "class " + className + " not found in classpath!");
            }
            ++i;
        }
    }

    public Hashtable getClasses() {
        return this.hObjects;
    }
}

