/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.jmxgui;

import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.ObjectName;
import org.jutils.log.LogChannel;
import org.xmlBlaster.client.jmx.AsyncMBeanServer;
import org.xmlBlaster.client.jmx.ConnectorException;
import org.xmlBlaster.client.jmx.ConnectorFactory;
import org.xmlBlaster.util.Global;

public class ConnectorClient {
    private LogChannel log = null;
    private Global glob = null;
    private static AsyncMBeanServer aServer = null;
    private static final String ME = "ConnectorClient";
    private ConnectorFactory connectorFactory;

    public ConnectorClient(Global glob, String serverName) {
        this.glob = glob;
        if (this.glob == null) {
            this.glob = Global.instance();
        }
        this.log = this.glob.getLog("jmxGUI");
        this.log.info(ME, "New Connector client - trying to establish connection to JmxServer....");
        try {
            this.connectorFactory = ConnectorFactory.getInstance(this.glob);
            aServer = this.connectorFactory.getMBeanServer(serverName);
        }
        catch (ConnectorException ex) {
            this.log.error(ME, "Error when creating AsyncMBeanServerInstance " + ex.toString());
            ex.printStackTrace();
        }
    }

    public AsyncMBeanServer getServer() throws ConnectorException {
        if (aServer != null) {
            return aServer;
        }
        throw new ConnectorException("MBeanServer not available");
    }

    public String[] getServerList() {
        return this.connectorFactory.getMBeanServerList();
    }

    public void logout() {
        if (this.log.CALL) {
            this.log.call(ME, "logout");
        }
        if (this.log.DUMP) {
            Thread.currentThread();
            Thread.dumpStack();
        }
        aServer.close();
    }

    public MBeanAttributeInfo[] exploreMBeansByObjectName(String name) {
        if (this.log.CALL) {
            this.log.call(ME, "exploreMBeansByObjectName '" + name + "'");
        }
        MBeanInfo mbInfo = this.getMBeanInfo(name);
        return mbInfo.getAttributes();
    }

    private MBeanInfo getMBeanInfo(String name) {
        if (this.log.CALL) {
            this.log.call(ME, "getMBeanInfo '" + name + "'");
        }
        MBeanInfo mbInfo = null;
        ObjectName RequestBroker2 = null;
        if (aServer != null) {
            try {
                RequestBroker2 = new ObjectName(name);
                mbInfo = (MBeanInfo)aServer.getMBeanInfo(RequestBroker2).get();
            }
            catch (Exception ex) {
                this.log.error(ME, "Error when retrieving information about " + name + " >> " + ex.toString());
                ex.printStackTrace();
            }
        } else {
            this.log.error(ME, "Lost AsyncServer!");
        }
        return mbInfo;
    }

    public MBeanOperationInfo[] exploreMBeanOperationsByObjectName(String name) {
        if (this.log.CALL) {
            this.log.call(ME, "exploreMBeanOperationsByObjectName '" + name + "'");
        }
        MBeanInfo mbInfo = this.getMBeanInfo(name);
        return mbInfo.getOperations();
    }
}

