/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.jmxgui;

import java.awt.Image;
import java.awt.Toolkit;
import java.net.URL;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.tree.DefaultMutableTreeNode;
import org.jutils.log.LogChannel;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xmlBlaster.client.jmx.ConnectorFactory;
import org.xmlBlaster.jmxgui.BasicNode;
import org.xmlBlaster.jmxgui.util.XmlUtil;
import org.xmlBlaster.util.Global;

public class DataModel {
    private XmlUtil xmlUtil = new XmlUtil();
    private DefaultMutableTreeNode top = null;
    private DefaultMutableTreeNode parent = null;
    private Global glob = null;
    private LogChannel log = null;
    private final String ME = "DataModel";
    private Document config = null;
    private Vector vSubNodes;

    public DataModel(Global glob) throws Exception {
        this.glob = glob;
        this.log = this.glob.getLog("jmxGUI");
        this.log.info("DataModel", "building new tree...");
        this.addServerNodes();
        this.buildTree();
    }

    public DefaultMutableTreeNode getTree() {
        return this.top;
    }

    public void buildTree() {
        this.vSubNodes = new Vector();
        this.log.info("DataModel", "Trying to retrieve config from file");
        try {
            this.config = this.xmlUtil.loadConfig();
        }
        catch (Exception ex) {
            this.log.error("DataModel", "Error when loading plugin config " + ex.toString());
            ex.printStackTrace();
        }
        NodeList nl = this.config.getElementsByTagName("component");
        int i = 0;
        while (i < nl.getLength()) {
            Node n = nl.item(i);
            NodeList nlParam = n.getChildNodes();
            int j = 0;
            while (j < nlParam.getLength()) {
                Node nParam = nlParam.item(j);
                NodeList nlParamChild = nParam.getChildNodes();
                int k = 0;
                while (k < nlParamChild.getLength()) {
                    Node nodeName = nlParamChild.item(k);
                    this.vSubNodes.addElement(nlParamChild.item(k).getNodeValue());
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        DefaultMutableTreeNode node = null;
        int i2 = 0;
        while (i2 < this.vSubNodes.size()) {
            BasicNode bNode = new BasicNode(null, (String)this.vSubNodes.elementAt(i2));
            bNode.setExpandedIcon(this.loadIcon("question.gif"));
            bNode.setNormalIcon(this.loadIcon("question.gif"));
            node = new DefaultMutableTreeNode(bNode);
            this.parent.add(node);
            ++i2;
        }
    }

    public DefaultMutableTreeNode addServerNodes() throws Exception {
        Object[] nodes = new Object[5];
        BasicNode rootNode = new BasicNode(null, "xmlBlaster");
        rootNode.setExpandedIcon(this.loadIcon("globe.gif"));
        rootNode.setNormalIcon(this.loadIcon("globe.gif"));
        this.parent = this.top = new DefaultMutableTreeNode(rootNode);
        nodes[0] = this.top;
        DefaultMutableTreeNode node = null;
        ConnectorFactory connectorFactory = ConnectorFactory.getInstance(this.glob);
        connectorFactory.getMBeanServer("127.0.0.1");
        String[] servers = connectorFactory.getMBeanServerList();
        if (servers == null) {
            throw new Exception("could not connect to any host! ");
        }
        int i = 0;
        while (i < servers.length) {
            BasicNode bNode = new BasicNode(null, servers[i]);
            bNode.setExpandedIcon(this.loadIcon("node.gif"));
            bNode.setNormalIcon(this.loadIcon("node.gif"));
            node = new DefaultMutableTreeNode(bNode);
            this.parent.add(node);
            ++i;
        }
        this.parent = node;
        nodes[1] = this.parent;
        return this.top;
    }

    public ImageIcon loadIcon(String filename) {
        ImageIcon icon = null;
        URL oUrl = this.getClass().getResource(filename);
        Image img = Toolkit.getDefaultToolkit().getImage(oUrl);
        if (img != null) {
            icon = new ImageIcon(img);
        } else {
            this.log.warn("DataModel", filename + " not found");
        }
        return icon;
    }
}

