/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.jmxgui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.URL;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import org.jutils.log.LogChannel;
import org.xmlBlaster.jmxgui.DataModel;
import org.xmlBlaster.jmxgui.IconCellRenderer;
import org.xmlBlaster.jmxgui.IdSelectionListener;
import org.xmlBlaster.jmxgui.MyExpansionListener;
import org.xmlBlaster.util.Global;

public class MainFrame
extends JFrame {
    private final String strInfo = "XmlBlaster Management GUI";
    protected DataModel myModel = null;
    protected JTree m_tree = null;
    protected DefaultTreeModel m_model = null;
    protected JTextField m_display = null;
    private JScrollPane s = new JScrollPane();
    protected JPanel PanelContent = new JPanel();
    private JPanel PanelLeft = new JPanel();
    private GridLayout gridLayout1 = new GridLayout();
    private JTree jTree1 = new JTree();
    private JPanel jPanel1 = new JPanel();
    private LogChannel log = null;
    private Global glob = null;
    private final String ME = "MainFrame";
    private JMenuBar menuBar = new JMenuBar();
    private JMenu fileMenu = new JMenu();
    private JMenu helpMenu = new JMenu();
    private JMenuItem exitItem = new JMenuItem();
    private JMenuItem aboutMenuItem = new JMenuItem();
    private GridBagLayout gbl = new GridBagLayout();

    public MainFrame(Global glob) {
        this.glob = glob;
        this.log = glob.getLog("jmxGUI");
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void removePanel() {
        this.PanelContent.removeAll();
    }

    private void jbInit() throws Exception {
        try {
            this.setTitle("xmlBlaster");
            this.exitItem.setText("Exit");
            this.exitItem.setMnemonic('e');
            this.fileMenu.setText("File");
            this.fileMenu.setMnemonic('f');
            this.exitItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    MainFrame.this.exit();
                }
            });
            this.helpMenu.setText("?");
            this.aboutMenuItem.setText("About");
            this.helpMenu.add(this.aboutMenuItem);
            this.setJMenuBar(this.menuBar);
            this.fileMenu.add(this.exitItem);
            this.menuBar.add(this.fileMenu);
            this.menuBar.add(this.helpMenu);
            this.aboutMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    MainFrame.this.aboutMenuItem_actionPerformed(e);
                }
            });
            this.log.info("MainFrame", "jbinit() called");
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            Dimension labelSize = new Dimension(screenSize.height / 3, screenSize.width / 3);
            ((Component)this).setSize(new Dimension(labelSize));
            ((Component)this).setLocation(screenSize.width / 2 - labelSize.width / 2, screenSize.height / 2 - labelSize.height / 2);
            URL oUrl = this.getClass().getResource("AppIcon.gif");
            Image img = Toolkit.getDefaultToolkit().getImage(oUrl);
            if (img != null) {
                ((Frame)this).setIconImage(img);
                this.log.info("MainFrame", "Image found " + img.toString());
            } else {
                this.log.warn("MainFrame", "AppIcon.gif not found");
            }
            this.log.info("MainFrame", "Trying to build model");
            try {
                this.myModel = new DataModel(this.glob);
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(this, "Error when connecting to server!", "Error", 2);
                ex.printStackTrace();
            }
            this.m_model = new DefaultTreeModel(this.myModel.getTree());
            this.m_tree = new JTree(this.m_model);
            DefaultTreeCellRenderer renderer = new DefaultTreeCellRenderer();
            IconCellRenderer myRenderer = new IconCellRenderer();
            this.m_tree.setCellRenderer(myRenderer);
            this.m_tree.addTreeSelectionListener(new MyExpansionListener(this, this.glob));
            this.m_tree.setShowsRootHandles(true);
            this.m_tree.setEditable(false);
            this.m_tree.addTreeSelectionListener(new IdSelectionListener(this));
            this.m_display = new JTextField();
            this.m_display.setEditable(false);
            this.getContentPane().add((Component)this.m_display, "South");
            WindowAdapter wndCloser = new WindowAdapter(){

                public void windowClosing(WindowEvent e) {
                    MainFrame.this.exit();
                }
            };
            this.addWindowListener(wndCloser);
            this.m_tree.setAutoscrolls(true);
            this.m_tree.setScrollsOnExpand(true);
            this.s.getViewport().add(this.m_tree);
            this.PanelLeft.add((Component)this.s, "Center");
            this.setResizable(true);
            JSplitPane sp = new JSplitPane();
            this.PanelContent.setLayout(this.gbl);
            this.PanelContent.add((Component)this.jPanel1, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            sp.setLeftComponent(new JScrollPane(this.PanelLeft));
            sp.setRightComponent(this.PanelContent);
            this.getContentPane().add(sp);
            ((Component)this).setVisible(true);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void exit() {
        Object[] options = new Object[]{"Yes", "No"};
        int n = JOptionPane.showOptionDialog(null, "Really exit Programm?", "Question", 0, 3, null, options, options[0]);
        if (n == 0) {
            this.log.info("MainFrame", "Exit handeled by WindowManager...");
            this.log.info("MainFrame", "Logging out from XmlBlaster..");
            System.exit(0);
        }
    }

    void aboutMenuItem_actionPerformed(ActionEvent e) {
        try {
            System.out.println("Aboutmenu..");
            JOptionPane.showMessageDialog(this, "XmlBlaster Management GUI", "Info", 1);
        }
        catch (Throwable te) {
            System.out.println("Exception by about >>> " + te);
        }
    }
}

