/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.jmxgui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;

public class SplashWindow
extends JWindow {
    private static String ME = "SplashWindow";

    public SplashWindow(String iconName, Frame frame, int waitTime) {
        super(frame);
        try {
            JLabel l = new JLabel(this.loadIcon(iconName));
            this.getContentPane().add((Component)l, "Center");
            this.pack();
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            Dimension labelSize = l.getPreferredSize();
            ((Component)this).setLocation(screenSize.width / 2 - labelSize.width / 2, screenSize.height / 2 - labelSize.height / 2);
            this.addMouseListener(new MouseAdapter(){

                public void mousePressed(MouseEvent e) {
                    ((Component)SplashWindow.this).setVisible(false);
                    SplashWindow.this.dispose();
                }
            });
            final int pause = waitTime;
            final Runnable closeRunner = new Runnable(){

                public void run() {
                    ((Component)SplashWindow.this).setVisible(false);
                    SplashWindow.this.dispose();
                }
            };
            Runnable waitRunner = new Runnable(){

                public void run() {
                    try {
                        Thread.sleep(pause);
                        SwingUtilities.invokeAndWait(closeRunner);
                    }
                    catch (Exception ex) {
                        System.out.println("Error: " + ex.toString());
                    }
                }
            };
            ((Component)this).setVisible(true);
            Thread splashThread = new Thread();
            splashThread.start();
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public ImageIcon loadIcon(String filename) {
        ImageIcon icon = null;
        URL oUrl = this.getClass().getResource(filename);
        Image img = Toolkit.getDefaultToolkit().getImage(oUrl);
        if (img != null) {
            icon = new ImageIcon(img);
        }
        return icon;
    }
}

