/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.jmxgui.plugins;

import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.Vector;
import javax.management.MBeanAttributeInfo;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.swing.table.AbstractTableModel;
import org.xmlBlaster.client.jmx.AsyncMBeanServer;
import org.xmlBlaster.client.jmx.ConnectorException;
import org.xmlBlaster.jmxgui.ConnectorClient;

public class GenericJmxModel
extends AbstractTableModel {
    protected Vector vecMBeans;
    protected ConnectorClient connectorClient = null;
    protected AsyncMBeanServer aServer = null;
    protected ObjectName RequestBroker = null;
    private HashMap hmtable = new HashMap();
    private String objectName = "";
    private String className = "";

    public GenericJmxModel(ConnectorClient connectorClient, String objectName, String className) {
        this.objectName = objectName;
        this.connectorClient = connectorClient;
        this.className = className;
        this.loadData();
    }

    public void loadData() {
        try {
            ObjectName name = new ObjectName(this.objectName);
            boolean isLoaded = (Boolean)this.connectorClient.getServer().isRegistered(name).get();
            if (!isLoaded) {
                this.loadMBean(this.objectName, this.className);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.exploreMBeans();
        this.fillHashMap();
    }

    public void fillHashMap() {
        int i = 0;
        while (i < this.vecMBeans.size()) {
            try {
                this.hmtable.put(new Integer(i), this.aServer.getAttribute(this.RequestBroker, (String)this.vecMBeans.get(i)).get());
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
            ++i;
        }
    }

    public void exploreMBeans() {
        this.vecMBeans = new Vector();
        try {
            this.aServer = this.connectorClient.getServer();
        }
        catch (ConnectorException ex) {
            ex.printStackTrace();
        }
        try {
            this.RequestBroker = new ObjectName(this.objectName);
        }
        catch (MalformedObjectNameException ex) {
            // empty catch block
        }
        MBeanAttributeInfo[] attrInfo = this.connectorClient.exploreMBeansByObjectName(this.objectName);
        int i = 0;
        while (i < attrInfo.length) {
            this.vecMBeans.addElement(attrInfo[i].getName());
            ++i;
        }
    }

    public void loadMBean(String myObjectName, String className) {
        try {
            AsyncMBeanServer server = this.connectorClient.getServer();
            server.createMBean(className, new ObjectName(myObjectName));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public boolean isCellEditable(int i, int j) {
        return false;
    }

    public int getRowCount() {
        return this.vecMBeans.size();
    }

    public int getColumnCount() {
        return 2;
    }

    public Object getValueAt(int row, int column) {
        Object obj = new Object();
        if (column == 0) {
            obj = this.vecMBeans.get(row);
        }
        if (column == 1) {
            try {
                obj = this.hmtable.get(new Integer(row));
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return obj;
    }

    public String getColumnName(int columnIndex) {
        String name = "";
        if (columnIndex == 0) {
            name = "key";
        }
        if (columnIndex == 1) {
            name = "value";
        }
        return name;
    }
}

