/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.protocol.corba;

import org.jutils.log.LogChannel;
import org.jutils.time.StopWatch;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.Policy;
import org.omg.PortableServer.IdUniquenessPolicyValue;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.POAHelper;
import org.omg.PortableServer.POAManager;
import org.omg.PortableServer.RequestProcessingPolicyValue;
import org.xmlBlaster.engine.qos.ConnectQosServer;
import org.xmlBlaster.engine.qos.ConnectReturnQosServer;
import org.xmlBlaster.engine.qos.DisconnectQosServer;
import org.xmlBlaster.protocol.I_Authenticate;
import org.xmlBlaster.protocol.I_XmlBlaster;
import org.xmlBlaster.protocol.corba.CorbaDriver;
import org.xmlBlaster.protocol.corba.ServerImpl;
import org.xmlBlaster.protocol.corba.authenticateIdl.AuthServerOperations;
import org.xmlBlaster.protocol.corba.serverIdl.Server;
import org.xmlBlaster.protocol.corba.serverIdl.ServerHelper;
import org.xmlBlaster.protocol.corba.serverIdl.ServerPOATie;
import org.xmlBlaster.protocol.corba.serverIdl.XmlBlasterException;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.def.ErrorCode;
import org.xmlBlaster.util.qos.address.ServerRef;

public class AuthServerImpl
implements AuthServerOperations {
    private static final String ME = "AuthServerImpl";
    private final Global glob;
    private final LogChannel log;
    private final ORB orb;
    private final I_Authenticate authenticate;
    private final String xmlBlasterPOA_name = "xmlBlaster-POA";
    private POA xmlBlasterPOA;
    private POA rootPOA;
    private ServerPOATie xmlBlasterServant;

    public AuthServerImpl(Global glob, ORB orb, I_Authenticate authenticate, I_XmlBlaster blaster) {
        this.glob = glob;
        this.log = glob.getLog("corba");
        this.orb = orb;
        this.authenticate = authenticate;
        if (this.log.CALL) {
            this.log.call(ME, "Entering constructor with ORB argument");
        }
        try {
            this.rootPOA = POAHelper.narrow(orb.resolve_initial_references("RootPOA"));
            POAManager poaMgr = this.rootPOA.the_POAManager();
            Policy[] policies = new Policy[]{this.rootPOA.create_request_processing_policy(RequestProcessingPolicyValue.USE_DEFAULT_SERVANT), this.rootPOA.create_id_uniqueness_policy(IdUniquenessPolicyValue.MULTIPLE_ID)};
            this.xmlBlasterPOA = this.rootPOA.create_POA("xmlBlaster-POA", poaMgr, policies);
            int i = 0;
            while (i < policies.length) {
                policies[i].destroy();
                ++i;
            }
            this.xmlBlasterServant = new ServerPOATie(new ServerImpl(glob, orb, blaster));
            this.xmlBlasterPOA.set_servant(this.xmlBlasterServant);
            poaMgr.activate();
            if (this.log.TRACE) {
                this.log.trace(ME, "Default xmlBlasterServant activated");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.log.error(ME, e.toString());
        }
        if (this.log.CALL) {
            this.log.trace(ME, "Leaving constructor");
        }
    }

    public ORB getOrb() {
        return this.orb;
    }

    public I_Authenticate getAuthenticationService() {
        return this.authenticate;
    }

    public Server login(String loginName, String passwd, String qos_literal) throws XmlBlasterException {
        if (this.log.CALL) {
            this.log.call(ME, "Entering login(loginName=" + loginName + ")");
        }
        if (loginName == null || passwd == null || qos_literal == null) {
            this.log.error("AuthServerImplInvalidArguments", "login failed: please use no null arguments for login()");
            throw CorbaDriver.convert(new org.xmlBlaster.util.XmlBlasterException(this.glob, ErrorCode.USER_SECURITY_AUTHENTICATION_ILLEGALARGUMENT, ME, "Login failed: please use no null arguments for login()"));
        }
        try {
            ConnectQosServer loginQos = new ConnectQosServer(this.glob, qos_literal);
            loginQos.loadClientPlugin(null, null, loginName, passwd);
            ConnectReturnQosServer returnQos = this.connectIntern(loginQos.toXml());
            ServerRef ref = returnQos.getServerRef();
            if (ref == null) {
                throw CorbaDriver.convert(new org.xmlBlaster.util.XmlBlasterException(this.glob, ErrorCode.INTERNAL_CONNECTIONFAILURE, ME, "Can't determine server reference."));
            }
            String xmlBlasterIOR = ref.getAddress();
            Server xmlBlaster = ServerHelper.narrow(this.orb.string_to_object(xmlBlasterIOR));
            return xmlBlaster;
        }
        catch (org.xmlBlaster.util.XmlBlasterException e) {
            throw CorbaDriver.convert(e);
        }
    }

    public String ping(String qos) {
        if (this.log.CALL) {
            this.log.call(ME, "Entering ping(" + qos + ") ...");
        }
        return this.authenticate.ping(qos);
    }

    public String connect(String qos_literal) throws XmlBlasterException {
        try {
            return this.connectIntern(qos_literal).toXml();
        }
        catch (org.xmlBlaster.util.XmlBlasterException e) {
            throw CorbaDriver.convert(e);
        }
    }

    private ConnectReturnQosServer connectIntern(String qos_literal) throws org.xmlBlaster.util.XmlBlasterException {
        ConnectReturnQosServer returnQos = null;
        String sessionId = null;
        StopWatch stop = null;
        if (this.log.TIME) {
            stop = new StopWatch();
        }
        Object certificatedServerRef = null;
        try {
            certificatedServerRef = this.xmlBlasterPOA.create_reference(ServerHelper.id());
            sessionId = this.getSessionId(certificatedServerRef);
            if (this.log.TRACE) {
                this.log.trace(ME, "Created sessionId=" + sessionId);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.log.error("AuthServerImpl.Corba", e.toString());
            throw new org.xmlBlaster.util.XmlBlasterException(this.glob, ErrorCode.INTERNAL_CONNECTIONFAILURE, ME, "connect failed: " + e.toString());
        }
        String returnQosStr = this.authenticate.connect(qos_literal, sessionId);
        returnQos = new ConnectReturnQosServer(this.glob, returnQosStr);
        if (returnQos.isReconnected()) {
            if (this.log.TRACE) {
                this.log.trace(ME, "Destroying old server addresses because of reconnect");
            }
            returnQos.removeServerRef("IOR");
        }
        Server xmlBlaster = ServerHelper.narrow(certificatedServerRef);
        String serverIOR = this.orb.object_to_string(xmlBlaster);
        returnQos.addServerRef(new ServerRef("IOR", serverIOR));
        if (this.log.TIME) {
            this.log.time(ME, "Elapsed time in connect()" + stop.nice());
        }
        if (this.log.DUMP) {
            this.log.dump(ME, "Returning from login-connect()" + returnQos.toXml());
        }
        return returnQos;
    }

    public void disconnect(String sessionId, String qos_literal) throws XmlBlasterException {
        if (this.log.CALL) {
            this.log.call(ME, "Entering disconnect()");
        }
        try {
            this.authenticate.disconnect(sessionId, qos_literal);
        }
        catch (org.xmlBlaster.util.XmlBlasterException e) {
            throw CorbaDriver.convert(e);
        }
        if (this.log.CALL) {
            this.log.call(ME, "Exiting disconnect()");
        }
    }

    public void logout(Server xmlServer) throws XmlBlasterException {
        if (this.log.CALL) {
            this.log.call(ME, "Entering logout()");
        }
        this.disconnect(this.getSessionId(xmlServer), new DisconnectQosServer(this.glob).toXml());
    }

    public final String getSessionId(Object xmlServer) throws XmlBlasterException {
        String sessionId = null;
        try {
            byte[] oid = this.xmlBlasterPOA.reference_to_id(xmlServer);
            sessionId = ServerImpl.convert(oid);
            if (this.log.TRACE) {
                this.log.trace(ME, "POA oid=<" + sessionId + ">");
            }
        }
        catch (Exception e) {
            this.log.error("AuthServerImpl.Unknown", "Sorry, you are unknown. No logout possible.");
            throw CorbaDriver.convert(new org.xmlBlaster.util.XmlBlasterException(this.glob, ErrorCode.USER_SECURITY_AUTHENTICATION_ACCESSDENIED, ME, "Sorry, you are not known with CORBA"));
        }
        return sessionId;
    }

    private String addToQoS(String qos, String add) {
        qos = qos.substring(0, qos.lastIndexOf("</qos>"));
        qos = qos + add + "\n</qos>\n";
        return qos;
    }

    public void shutdown() {
        if (this.log.TRACE) {
            this.log.trace(ME, "shutdown has been invoked");
        }
        if (this.xmlBlasterPOA != null) {
            if (this.log.TRACE) {
                this.log.trace(ME, "shutdown has been invoked and servant is not null");
            }
            try {
                this.xmlBlasterPOA.the_POAManager().deactivate(true, true);
            }
            catch (Exception ex) {
                this.log.warn(ME, "shutdown:exception occured deactivate(): " + ex.toString());
            }
            try {
                this.xmlBlasterPOA.destroy(true, true);
            }
            catch (Exception ex) {
                this.log.warn(ME, "shutdown:exception occured destroy(): " + ex.toString());
            }
        }
    }
}

