/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.protocol.corba;

import org.jutils.log.LogChannel;
import org.omg.CORBA.ORB;
import org.xmlBlaster.protocol.I_CallbackDriver;
import org.xmlBlaster.protocol.corba.CorbaDriver;
import org.xmlBlaster.protocol.corba.OrbInstanceFactory;
import org.xmlBlaster.protocol.corba.OrbInstanceWrapper;
import org.xmlBlaster.protocol.corba.clientIdl.BlasterCallback;
import org.xmlBlaster.protocol.corba.clientIdl.BlasterCallbackHelper;
import org.xmlBlaster.protocol.corba.serverIdl.MessageUnit;
import org.xmlBlaster.protocol.corba.serverIdl.XmlBlasterException;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.MsgUnitRaw;
import org.xmlBlaster.util.def.ErrorCode;
import org.xmlBlaster.util.plugin.PluginInfo;
import org.xmlBlaster.util.qos.address.CallbackAddress;

public class CallbackCorbaDriver
implements I_CallbackDriver {
    private String ME = "CallbackCorbaDriver";
    private Global glob;
    private LogChannel log;
    private BlasterCallback cb;
    private CallbackAddress callbackAddress;
    private OrbInstanceWrapper orbInstanceWrapper;
    private ORB orb;

    public final String getName() {
        return this.ME;
    }

    public final void init(Global glob, CallbackAddress callbackAddress) throws org.xmlBlaster.util.XmlBlasterException {
        this.glob = glob;
        this.log = glob.getLog("corba");
        this.callbackAddress = callbackAddress;
        String callbackIOR = callbackAddress.getRawAddress();
        try {
            this.orbInstanceWrapper = OrbInstanceFactory.getOrbInstanceWrapper(this.glob, "callback");
            this.orb = this.orbInstanceWrapper.getOrb(null, this.glob.getProperty().getProperties(), this.callbackAddress);
            this.cb = BlasterCallbackHelper.narrow(this.orb.string_to_object(callbackIOR));
            if (this.log.TRACE) {
                this.log.trace(this.ME, "Accessing client callback reference using given IOR string");
            }
        }
        catch (Throwable e) {
            this.log.error(this.ME, "The given callback IOR ='" + callbackIOR + "' is invalid: " + e.toString());
            throw new org.xmlBlaster.util.XmlBlasterException(glob, ErrorCode.RESOURCE_CONFIGURATION_ADDRESS, "Corba-CallbackHandleInvalid", "The given callback IOR is invalid: " + e.toString());
        }
    }

    public final String getProtocolId() {
        return "IOR";
    }

    public String getType() {
        return this.getProtocolId();
    }

    public String getVersion() {
        return "1.0";
    }

    public void init(Global glob, PluginInfo pluginInfo) {
    }

    public final String getRawAddress() {
        return this.callbackAddress.getRawAddress();
    }

    public final String[] sendUpdate(MsgUnitRaw[] msgArr) throws org.xmlBlaster.util.XmlBlasterException {
        if (msgArr == null || msgArr.length < 1 || msgArr[0] == null) {
            Thread.currentThread();
            Thread.dumpStack();
            throw new org.xmlBlaster.util.XmlBlasterException(this.glob, ErrorCode.INTERNAL_ILLEGALARGUMENT, this.ME, "Illegal sendUpdate() argument");
        }
        MessageUnit[] updateArr = new MessageUnit[msgArr.length];
        int ii = 0;
        while (ii < msgArr.length) {
            updateArr[ii] = CallbackCorbaDriver.convert(msgArr[ii]);
            ++ii;
        }
        try {
            return this.cb.update(this.callbackAddress.getSecretSessionId(), updateArr);
        }
        catch (XmlBlasterException ex) {
            org.xmlBlaster.util.XmlBlasterException xmlBlasterException = CorbaDriver.convert(this.glob, ex);
            if (xmlBlasterException.isUser()) {
                throw xmlBlasterException;
            }
            if (this.callbackAddress == null) {
                throw new org.xmlBlaster.util.XmlBlasterException(this.glob, ErrorCode.USER_UPDATE_ERROR, this.ME, "CORBA Callback of " + msgArr.length + " messages failed", xmlBlasterException);
            }
            throw new org.xmlBlaster.util.XmlBlasterException(this.glob, ErrorCode.USER_UPDATE_ERROR, this.ME, "CORBA Callback of " + msgArr.length + " messages to client [" + this.callbackAddress.getSecretSessionId() + "] failed.", xmlBlasterException);
        }
        catch (Throwable e) {
            if (this.callbackAddress == null) {
                throw new org.xmlBlaster.util.XmlBlasterException(this.glob, ErrorCode.COMMUNICATION_NOCONNECTION, this.ME, "CORBA Callback of " + msgArr.length + " messages failed", e);
            }
            throw new org.xmlBlaster.util.XmlBlasterException(this.glob, ErrorCode.COMMUNICATION_NOCONNECTION, this.ME, "CORBA Callback of " + msgArr.length + " messages to client [" + this.callbackAddress.getSecretSessionId() + "] failed", e);
        }
    }

    public final void sendUpdateOneway(MsgUnitRaw[] msgArr) throws org.xmlBlaster.util.XmlBlasterException {
        if (msgArr == null || msgArr.length < 1) {
            throw new org.xmlBlaster.util.XmlBlasterException(this.glob, ErrorCode.INTERNAL_ILLEGALARGUMENT, this.ME, "Illegal sendUpdateOneway() argument");
        }
        if (this.log.TRACE) {
            this.log.trace(this.ME, "xmlBlaster.updateOneway() to " + this.callbackAddress.getRawAddress());
        }
        MessageUnit[] updateArr = new MessageUnit[msgArr.length];
        int ii = 0;
        while (ii < msgArr.length) {
            updateArr[ii] = CallbackCorbaDriver.convert(msgArr[ii]);
            ++ii;
        }
        try {
            this.cb.updateOneway(this.callbackAddress.getSecretSessionId(), updateArr);
        }
        catch (Throwable e) {
            throw new org.xmlBlaster.util.XmlBlasterException(this.glob, ErrorCode.COMMUNICATION_NOCONNECTION, this.ME, "CORBA oneway callback of " + msgArr.length + " messages to client [" + this.callbackAddress.getSecretSessionId() + "] failed", e);
        }
    }

    public final String ping(String qos) throws org.xmlBlaster.util.XmlBlasterException {
        if (this.log.CALL) {
            this.log.call(this.ME, "ping client");
        }
        try {
            return this.cb.ping(qos);
        }
        catch (Throwable e) {
            throw new org.xmlBlaster.util.XmlBlasterException(this.glob, ErrorCode.COMMUNICATION_NOCONNECTION, this.ME, "CORBA callback ping failed", e);
        }
    }

    public static final MessageUnit convert(MsgUnitRaw mu) {
        return new MessageUnit(mu.getKey(), mu.getContent(), mu.getQos());
    }

    public boolean isAlive() {
        return true;
    }

    public void shutdown() {
        if (this.log != null && this.log.CALL) {
            this.log.call(this.ME, "Entering shutdown ...");
        }
        if (this.cb != null) {
            this.cb._release();
            this.cb = null;
        }
        this.callbackAddress = null;
        if (this.orbInstanceWrapper != null) {
            this.orbInstanceWrapper.releaseOrb(false);
        }
        if (this.log != null && this.log.TRACE) {
            this.log.trace(this.ME, "Shutdown of CORBA callback client done.");
        }
    }
}

