/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.protocol.corba;

import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import org.jutils.io.FileUtil;
import org.jutils.log.LogChannel;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.NO_IMPLEMENT;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CosNaming.NameComponent;
import org.omg.CosNaming.NamingContext;
import org.omg.CosNaming.NamingContextExt;
import org.omg.CosNaming.NamingContextExtHelper;
import org.omg.CosNaming.NamingContextPackage.AlreadyBound;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.POAHelper;
import org.xmlBlaster.engine.qos.AddressServer;
import org.xmlBlaster.protocol.I_Authenticate;
import org.xmlBlaster.protocol.I_Driver;
import org.xmlBlaster.protocol.I_XmlBlaster;
import org.xmlBlaster.protocol.corba.AuthServerImpl;
import org.xmlBlaster.protocol.corba.OrbInstanceFactory;
import org.xmlBlaster.protocol.corba.authenticateIdl.AuthServerPOATie;
import org.xmlBlaster.protocol.corba.serverIdl.MessageUnit;
import org.xmlBlaster.protocol.corba.serverIdl.XmlBlasterException;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.MsgUnitRaw;
import org.xmlBlaster.util.Timestamp;
import org.xmlBlaster.util.def.ErrorCode;
import org.xmlBlaster.util.plugin.PluginInfo;

public class CorbaDriver
implements I_Driver {
    private String ME = "CorbaDriver";
    private ORB orb;
    private Global glob;
    private LogChannel log;
    private NamingContextExt namingContextExt;
    private NameComponent[] nameXmlBlaster;
    private NameComponent[] nameNode;
    private String iorFile;
    private AuthServerImpl authServer;
    private I_Authenticate authenticate;
    private I_XmlBlaster xmlBlasterImpl;
    private POA rootPOA;
    private Object authRef;
    private final String urlPath = "/AuthenticationService.ior";
    private AddressServer addressServer;
    private static boolean first = true;
    private static String origORBClass;
    private static String origORBSingletonClass;

    public String getName() {
        return this.ME;
    }

    public String getProtocolId() {
        return "IOR";
    }

    public String getType() {
        return this.getProtocolId();
    }

    public String getVersion() {
        return "1.0";
    }

    public void init(Global glob, PluginInfo pluginInfo) throws org.xmlBlaster.util.XmlBlasterException {
        this.glob = glob;
        this.ME = "CorbaDriver" + this.glob.getLogPrefixDashed();
        this.log = glob.getLog("corba");
        org.xmlBlaster.engine.Global engineGlob = (org.xmlBlaster.engine.Global)glob.getObjectEntry("ServerNodeScope");
        if (engineGlob == null) {
            throw new org.xmlBlaster.util.XmlBlasterException(this.glob, ErrorCode.INTERNAL_UNKNOWN, this.ME + ".init", "could not retreive the ServerNodeScope. Am I really on the server side ?");
        }
        try {
            this.authenticate = engineGlob.getAuthenticate();
            if (this.authenticate == null) {
                throw new org.xmlBlaster.util.XmlBlasterException(this.glob, ErrorCode.INTERNAL_UNKNOWN, this.ME + ".init", "authenticate object is null");
            }
            I_XmlBlaster xmlBlasterImpl = this.authenticate.getXmlBlaster();
            if (xmlBlasterImpl == null) {
                throw new org.xmlBlaster.util.XmlBlasterException(this.glob, ErrorCode.INTERNAL_UNKNOWN, this.ME + ".init", "xmlBlasterImpl object is null");
            }
            this.init(glob, new AddressServer(glob, this.getType(), glob.getId()), this.authenticate, xmlBlasterImpl);
            this.activate();
        }
        catch (org.xmlBlaster.util.XmlBlasterException ex) {
            throw ex;
        }
        catch (Throwable ex) {
            throw new org.xmlBlaster.util.XmlBlasterException(this.glob, ErrorCode.INTERNAL_UNKNOWN, this.ME + ".init", "init. Could'nt initialize the driver.", ex);
        }
    }

    public String getRawAddress() {
        if (this.orb == null || this.authRef == null) {
            return null;
        }
        return this.orb.object_to_string(this.authRef);
    }

    private synchronized void init(Global glob, AddressServer addressServer, I_Authenticate authenticate, I_XmlBlaster xmlBlasterImpl) throws org.xmlBlaster.util.XmlBlasterException {
        this.authenticate = authenticate;
        this.xmlBlasterImpl = xmlBlasterImpl;
        this.addressServer = addressServer;
        this.orb = OrbInstanceFactory.createOrbInstance(this.glob, null, glob.getProperty().getProperties(), addressServer);
        try {
            this.rootPOA = POAHelper.narrow(this.orb.resolve_initial_references("RootPOA"));
            this.rootPOA.the_POAManager().activate();
            this.authServer = new AuthServerImpl(glob, this.orb, this.authenticate, this.xmlBlasterImpl);
            AuthServerPOATie authServant = new AuthServerPOATie(this.authServer);
            this.authRef = authServant._this(this.orb);
            this.addressServer.setRawAddress(this.orb.object_to_string(this.authRef));
        }
        catch (COMM_FAILURE e) {
            throw new org.xmlBlaster.util.XmlBlasterException(glob, ErrorCode.RESOURCE_CONFIGURATION, this.ME, "Could not initialize CORBA, do you use the SUN-JDK delivered ORB instead of JacORB or ORBaccus? Try 'jaco org.xmlBlaster.Main' and read instructions in xmlBlaster/bin/jaco", e);
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw new org.xmlBlaster.util.XmlBlasterException(glob, ErrorCode.RESOURCE_CONFIGURATION, this.ME, "Could not initialize CORBA", e);
        }
    }

    public synchronized void activate() throws org.xmlBlaster.util.XmlBlasterException {
        block27: {
            if (this.log.CALL) {
                this.log.call(this.ME, "Entering activate");
            }
            try {
                boolean useNameService;
                this.iorFile = this.addressServer.getEnv("iorFile", "").getValue();
                if (this.log.TRACE) {
                    this.log.trace(this.ME, this.addressServer.getEnvLookupKey("iorFile") + " = " + this.iorFile);
                }
                if (this.iorFile != null && this.iorFile.length() > 0) {
                    PrintWriter ps = new PrintWriter(new FileOutputStream(new File(this.iorFile)));
                    ps.println(this.orb.object_to_string(this.authRef));
                    ps.close();
                    this.log.info(this.ME, "Published AuthServer IOR to file " + this.iorFile + ", this will be deleted on shutdown.");
                }
                if (this.glob.getBootstrapAddress().getBootstrapPort() > 0) {
                    this.glob.getHttpServer().registerRequest("/AuthenticationService.ior", this.orb.object_to_string(this.authRef));
                    this.log.info(this.ME, "Published AuthServer IOR on " + this.glob.getBootstrapAddress().getRawAddress());
                }
                if (!(useNameService = this.addressServer.getEnv("useNameService", true).getValue())) break block27;
                try {
                    this.namingContextExt = this.getNamingService();
                    String contextId = this.addressServer.getEnv("NameService.context.id", "xmlBlaster").getValue();
                    String contextKind = this.addressServer.getEnv("NameService.context.kind", "MOM").getValue();
                    this.nameXmlBlaster = new NameComponent[1];
                    this.nameXmlBlaster[0] = new NameComponent();
                    this.nameXmlBlaster[0].id = contextId;
                    this.nameXmlBlaster[0].kind = contextKind;
                    NamingContext relativeContext = null;
                    int numTries = 5;
                    int i = 0;
                    while (i < numTries) {
                        try {
                            relativeContext = this.namingContextExt.bind_new_context(this.nameXmlBlaster);
                            if (relativeContext != null) {
                                break;
                            }
                        }
                        catch (AlreadyBound ex) {
                            if (this.log.TRACE) {
                                this.log.trace(this.ME, "Can't register CORBA NameService context '" + CorbaDriver.getString(this.nameXmlBlaster) + "': " + ex.toString());
                            }
                            try {
                                Object obj = this.namingContextExt.resolve(this.nameXmlBlaster);
                                relativeContext = NamingContextExtHelper.narrow(obj);
                                break;
                            }
                            catch (Throwable e) {
                                this.log.error(this.ME, "Can't register CORBA NameService context '" + CorbaDriver.getString(this.nameXmlBlaster) + "', #" + i + "/" + numTries + ": " + e.toString());
                            }
                        }
                        catch (NO_IMPLEMENT ex) {
                            if (this.log.TRACE) {
                                this.log.trace(this.ME, "Can't register CORBA NameService context '" + CorbaDriver.getString(this.nameXmlBlaster) + "': " + ex.toString());
                            }
                            try {
                                Object obj = this.namingContextExt.resolve(this.nameXmlBlaster);
                                relativeContext = NamingContextExtHelper.narrow(obj);
                                break;
                            }
                            catch (Throwable e) {
                                this.log.error(this.ME, "Can't register CORBA NameService context '" + CorbaDriver.getString(this.nameXmlBlaster) + "', #" + i + "/" + numTries + ": " + e.toString());
                            }
                        }
                        ++i;
                    }
                    if (relativeContext == null) {
                        throw new org.xmlBlaster.util.XmlBlasterException(this.glob, ErrorCode.RESOURCE_UNAVAILABLE, this.ME, "Can't bind to naming service");
                    }
                    String clusterId = this.addressServer.getEnv("NameService.node.id", this.glob.getStrippedId()).getValue();
                    String clusterKind = this.addressServer.getEnv("NameService.node.kind", "MOM").getValue();
                    this.nameNode = new NameComponent[]{new NameComponent(clusterId, clusterKind)};
                    relativeContext.rebind(this.nameNode, this.authRef);
                    this.log.info(this.ME, "Published AuthServer IOR to NameService ORBInitRef='" + System.getProperty("ORBInitRef") + "' with name '" + CorbaDriver.getString(this.nameXmlBlaster) + "/" + CorbaDriver.getString(this.nameNode) + "'");
                }
                catch (org.xmlBlaster.util.XmlBlasterException e) {
                    this.log.warn(this.ME + ".NoNameService", e.getMessage());
                    this.namingContextExt = null;
                    if (this.glob.getBootstrapAddress().getBootstrapPort() > 0) {
                        this.log.info(this.ME, "You don't need the naming service, i'll switch to builtin http IOR download");
                        break block27;
                    }
                    if (this.iorFile != null) {
                        this.log.info(this.ME, "You don't need the naming service, i'll switch to plugin/ior/iorFile = " + this.iorFile);
                        break block27;
                    }
                    this.usage();
                    this.log.error(this.ME, "You switched off the internal http server and you didn't specify a file name for IOR dump nor a Naming Service was found!");
                }
                catch (COMM_FAILURE e) {
                    this.namingContextExt = null;
                    if (this.glob.getBootstrapAddress().getBootstrapPort() > 0) {
                        this.log.info(this.ME, "Can't publish AuthServer to naming service, is your naming service really running?\n" + e.toString() + "\nYou don't need the naming service, i'll switch to builtin http IOR download");
                        break block27;
                    }
                    if (this.iorFile != null) {
                        this.log.info(this.ME, "Can't publish AuthServer to naming service, is your naming service really running?\n" + e.toString() + "\nYou don't need the naming service, i'll switch to plugin/ior/iorFile = " + this.iorFile);
                        break block27;
                    }
                    this.usage();
                    this.log.error(this.ME, "Can't publish AuthServer to naming service, is your naming service really running?\n" + e.toString() + "\nYou switched off the internal http server and you didn't specify a file name for IOR dump!");
                }
            }
            catch (COMM_FAILURE e) {
                throw new org.xmlBlaster.util.XmlBlasterException(this.glob, ErrorCode.RESOURCE_CONFIGURATION, this.ME, "Could not initialize CORBA, do you use the SUN-JDK delivered ORB instead of JacORB or ORBaccus? Try 'jaco org.xmlBlaster.Main' and read instructions in xmlBlaster/bin/jaco", e);
            }
            catch (Throwable e) {
                e.printStackTrace();
                throw new org.xmlBlaster.util.XmlBlasterException(this.glob, ErrorCode.RESOURCE_CONFIGURATION, this.ME, "Could not initialize CORBA", e);
            }
        }
        if (this.orb.work_pending()) {
            this.orb.perform_work();
        }
    }

    public synchronized void deActivate() throws org.xmlBlaster.util.XmlBlasterException {
        if (this.log.CALL) {
            this.log.call(this.ME, "Entering deActivate");
        }
        this.glob.getHttpServer().removeRequest("/AuthenticationService.ior");
        try {
            if (this.namingContextExt != null && this.nameXmlBlaster != null) {
                NamingContextExt relativeContext = null;
                try {
                    Object obj = this.namingContextExt.resolve(this.nameXmlBlaster);
                    relativeContext = NamingContextExtHelper.narrow(obj);
                }
                catch (Throwable e) {
                    this.log.warn(this.ME, "Can't unregister CORBA NameService context id=" + this.nameXmlBlaster[0].id + " kind=" + this.nameXmlBlaster[0].kind + " failed: " + e.toString());
                }
                if (relativeContext != null) {
                    relativeContext.unbind(this.nameNode);
                }
            }
            this.namingContextExt = null;
        }
        catch (Throwable e) {
            this.log.warn(this.ME, "Problems during ORB cleanup: " + e.toString());
            e.printStackTrace();
        }
        try {
            if (this.iorFile != null) {
                FileUtil.deleteFile(null, this.iorFile);
            }
            this.iorFile = null;
        }
        catch (Throwable e) {
            this.log.warn(this.ME, "Problems during ORB cleanup: " + e.toString());
        }
        this.authRef._release();
    }

    public static String getString(NameComponent[] nameComponent) {
        String ret = "";
        int i = 0;
        while (i < nameComponent.length) {
            if (i > 0) {
                ret = ret + "/";
            }
            ret = ret + nameComponent[i].id + (nameComponent[i].kind != null && nameComponent[i].kind.length() > 0 ? "." + nameComponent[i].kind : "");
            ++i;
        }
        return ret;
    }

    public void shutdown() throws org.xmlBlaster.util.XmlBlasterException {
        if (this.log.CALL) {
            this.log.call(this.ME, "Shutting down ...");
        }
        try {
            this.deActivate();
        }
        catch (org.xmlBlaster.util.XmlBlasterException e) {
            this.log.error(this.ME, e.toString());
        }
        if (this.authServer != null) {
            this.authServer.shutdown();
        }
        if (this.rootPOA != null && this.authRef != null) {
            try {
                this.log.trace(this.ME, "Deactivate POA ...");
                this.authRef._release();
                this.rootPOA.deactivate_object(this.rootPOA.reference_to_id(this.authRef));
            }
            catch (Exception e) {
                this.log.warn(this.ME, "POA deactivate authentication servant failed");
            }
        }
        if (this.rootPOA != null) {
            try {
                this.rootPOA.destroy(true, true);
            }
            catch (Exception ex) {
                this.log.warn(this.ME, "shutdown:exception occured rootPOA.destroy(): " + ex.toString());
            }
            this.rootPOA = null;
        }
        this.authRef = null;
        if (this.orb != null) {
            boolean wait_for_completion = false;
            try {
                this.orb.shutdown(wait_for_completion);
                this.orb = null;
            }
            catch (Throwable ex) {
                this.log.warn(this.ME, "shutdown: Exception occured during orb.shutdown(" + wait_for_completion + "): " + ex.toString());
            }
        }
        this.log.info(this.ME, "POA and ORB are down, CORBA resources released.");
    }

    private NamingContextExt getNamingService() throws org.xmlBlaster.util.XmlBlasterException {
        if (this.log.CALL) {
            this.log.call(this.ME, "getNamingService() ...");
        }
        if (this.namingContextExt != null) {
            return this.namingContextExt;
        }
        NamingContextExt nameService = null;
        try {
            Object nameServiceObj = this.orb.resolve_initial_references("NameService");
            if (nameServiceObj == null) {
                throw new org.xmlBlaster.util.XmlBlasterException(this.glob, ErrorCode.RESOURCE_CONFIGURATION, this.ME + ".NoNameService", "Can't access naming service, is there any running?");
            }
            if (this.log.TRACE) {
                this.log.trace(this.ME, "Successfully accessed initial orb references for naming service (IOR)");
            }
            if ((nameService = NamingContextExtHelper.narrow(nameServiceObj)) == null) {
                this.log.error(this.ME + ".NoNameService", "Can't access naming service == null");
                throw new org.xmlBlaster.util.XmlBlasterException(this.glob, ErrorCode.RESOURCE_CONFIGURATION, this.ME + ".NoNameService", "Can't access naming service (narrow problem)");
            }
            if (this.log.TRACE) {
                this.log.trace(this.ME, "Successfully narrowed handle for naming service");
            }
            return nameService;
        }
        catch (org.xmlBlaster.util.XmlBlasterException e) {
            throw e;
        }
        catch (Exception e) {
            if (this.log.TRACE) {
                this.log.trace(this.ME + ".NoNameService", e.toString() + ": " + e.getMessage());
            }
            throw org.xmlBlaster.util.XmlBlasterException.convert(this.glob, ErrorCode.RESOURCE_CONFIGURATION, this.ME + ".NoNameService", "No CORBA naming service found - start <xmlBlaster/bin/ns ns.ior> and specify <-ORBInitRef NameService=...> if you want one.", e);
        }
    }

    public static final org.xmlBlaster.util.XmlBlasterException convert(Global glob, XmlBlasterException eCorba) {
        boolean isServerSide = !glob.isServerSide();
        org.xmlBlaster.util.XmlBlasterException ex = new org.xmlBlaster.util.XmlBlasterException(glob, ErrorCode.toErrorCode(eCorba.errorCodeStr), eCorba.node, eCorba.location, eCorba.lang, eCorba.message, eCorba.versionInfo, Timestamp.valueOf(eCorba.timestampStr), eCorba.stackTrace, eCorba.embeddedMessage, eCorba.transactionInfo, isServerSide);
        return ex;
    }

    public static final XmlBlasterException convert(org.xmlBlaster.util.XmlBlasterException eUtil) {
        return new XmlBlasterException(eUtil.getErrorCodeStr(), eUtil.getNode(), eUtil.getLocation(), eUtil.getLang(), eUtil.getRawMessage(), eUtil.getVersionInfo(), eUtil.getTimestamp().toString(), eUtil.getStackTraceStr(), eUtil.getEmbeddedMessage(), eUtil.getTransactionInfo(), "");
    }

    public static final MsgUnitRaw convert(Global glob, MessageUnit mu) throws org.xmlBlaster.util.XmlBlasterException {
        return new MsgUnitRaw(mu.xmlKey, mu.content, mu.qos);
    }

    public static final MsgUnitRaw[] convert(Global glob, MessageUnit[] msgUnitArr) throws org.xmlBlaster.util.XmlBlasterException {
        MsgUnitRaw[] internalUnitArr = new MsgUnitRaw[msgUnitArr.length];
        int ii = 0;
        while (ii < msgUnitArr.length) {
            internalUnitArr[ii] = CorbaDriver.convert(glob, msgUnitArr[ii]);
            ++ii;
        }
        return internalUnitArr;
    }

    public static final MessageUnit convert(MsgUnitRaw mu) {
        return new MessageUnit(mu.getKey(), mu.getContent(), mu.getQos());
    }

    public static final MessageUnit[] convert(MsgUnitRaw[] msgUnitArr) {
        MessageUnit[] corbaUnitArr = new MessageUnit[msgUnitArr.length];
        int ii = 0;
        while (ii < msgUnitArr.length) {
            corbaUnitArr[ii] = CorbaDriver.convert(msgUnitArr[ii]);
            ++ii;
        }
        return corbaUnitArr;
    }

    public String usage() {
        String text = "\n";
        text = text + "CorbaDriver options:\n";
        text = text + "   -bootstrapHostname  IP address where the builtin http server publishes its AuthServer IOR\n";
        text = text + "                       This is useful for multihomed hosts or dynamic dial in IPs.\n";
        text = text + "   -bootstrapPort      Port number where the builtin http server publishes its AuthServer IOR.\n";
        text = text + "                       Default is bootstrap port 3412, the port 0 switches this feature off.\n";
        text = text + "   -plugin/ior/iorFile\n";
        text = text + "                       Specify a file where to dump the IOR of the AuthServer (for client access).\n";
        text = text + "   -plugin/ior/iorString\n";
        text = text + "                       Clients can specify the raw IOR string directly (for client access).\n";
        text = text + "   -plugin/ior/useNameService true/false [true]\n";
        text = text + "                       Publish the IOR to a naming service.\n";
        text = text + "   -plugin/ior/hostname\n";
        text = text + "                       Allows to force the corba server IP address for multi-homed hosts.\n";
        text = text + "   -plugin/ior/port    Allows to force the corba server port number.\n";
        text = text + " For JacORB only:\n";
        text = text + "   java -DOAIAddr=<ip> Use '-plugin/ior/hostname'\n";
        text = text + "   java -DOAPort=<nr>  Use '-plugin/ior/port'\n";
        text = text + "   java -Djacorb.log.default.verbosity=3  Switch CORBA debugging on\n";
        text = text + "   java ... -ORBInitRef NameService=corbaloc:iiop:localhost:7608/StandardNS/NameServer-POA/_root\n";
        text = text + "\n";
        return text;
    }
}

