/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.protocol.corba;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import org.jacorb.naming.NameServer;
import org.jutils.log.LogChannel;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.portable.InputStream;
import org.omg.CORBA.portable.OutputStream;
import org.omg.IIOP.ProfileBody_1_1;
import org.omg.IIOP.ProfileBody_1_1Helper;
import org.omg.IOP.IOR;
import org.omg.IOP.IORHelper;
import org.xmlBlaster.protocol.corba.OrbInstanceWrapper;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.JdkCompatible;
import org.xmlBlaster.util.qos.address.AddressBase;

public final class OrbInstanceFactory {
    private static boolean first = true;
    private static String origORBClass;
    private static String origORBSingletonClass;
    private static boolean nameServiceStarted;
    static /* synthetic */ Class class$java$lang$System;

    private static synchronized Properties initializeOrbEnv(Global glob, AddressBase address) {
        String orbClass;
        glob = glob == null ? Global.instance() : glob;
        LogChannel log = glob.getLog("corba");
        String ME = "OrbInstanceFactory";
        Properties props = new Properties();
        if (first) {
            first = false;
            origORBClass = System.getProperty("org.omg.CORBA.ORBClass");
            origORBSingletonClass = System.getProperty("org.omg.CORBA.ORBSingletonClass");
        }
        if (origORBClass == null || origORBClass.length() < 1) {
            String tmp = glob.getProperty().get("org.omg.CORBA.ORBClass", "org.jacorb.orb.ORB");
            if (tmp.length() < 1) {
                tmp = "org.jacorb.orb.ORB";
            }
            ((Hashtable)props).put("org.omg.CORBA.ORBClass", tmp);
            tmp = glob.getProperty().get("org.omg.CORBA.ORBSingletonClass", "org.jacorb.orb.ORBSingleton");
            if (tmp.length() < 1) {
                tmp = "org.jacorb.orb.ORBSingleton";
            }
            ((Hashtable)props).put("org.omg.CORBA.ORBSingletonClass", tmp);
        }
        String hostname = address.getEnv("hostname", null).getValue();
        if (log.TRACE) {
            log.trace("OrbInstanceFactory", "initializeOrbEnv(" + address.getEnvLookupKey("hostname") + "=" + hostname);
        }
        if ((orbClass = (String)((Hashtable)props).get("org.omg.CORBA.ORBClass")) != null && orbClass.indexOf("jacorb") >= 0) {
            int verbose;
            int port;
            if (hostname != null) {
                ((Hashtable)props).put("OAIAddr", hostname);
                if (log.TRACE) {
                    log.trace("OrbInstanceFactory", "Using OAIAddr=" + address.getEnvLookupKey("hostname") + "=" + props.getProperty("OAIAddr"));
                }
            }
            if ((port = address.getEnv("port", 0).getValue()) > 0) {
                ((Hashtable)props).put("OAPort", "" + port);
                if (log.TRACE) {
                    log.trace("OrbInstanceFactory", "Using OAPort=" + address.getEnvLookupKey("port") + "=" + props.getProperty("OAPort"));
                }
            }
            if ((verbose = glob.getProperty().get("jacorb.log.default.verbosity", -1)) >= 0) {
                ((Hashtable)props).put("jacorb.log.default.verbosity", "" + verbose);
                if (log.TRACE) {
                    log.trace("OrbInstanceFactory", "Using jacorb.log.default.verbosity=" + props.getProperty("jacorb.log.default.verbosity"));
                }
            }
            int verbosePoa = glob.getProperty().get("jacorb.poa.log.verbosity", 0);
            ((Hashtable)props).put("jacorb.poa.log.verbosity", "" + verbosePoa);
            if (log.TRACE) {
                log.trace("OrbInstanceFactory", "Using jacorb.poa.log.verbosity=" + verbosePoa);
            }
        }
        if (log.TRACE) {
            log.trace("OrbInstanceFactory", "Using org.omg.CORBA.ORBClass=" + props.getProperty("org.omg.CORBA.ORBClass"));
        }
        if (log.TRACE) {
            log.trace("OrbInstanceFactory", "Using org.omg.CORBA.ORBSingletonClass=" + props.getProperty("org.omg.CORBA.ORBSingletonClass"));
        }
        if (glob.getProperty().get("ORBInitRef", (String)null) != null) {
            String tmp = glob.getProperty().get("ORBInitRef", "NameService=corbaloc:iiop:localhost:7608/StandardNS/NameServer-POA/_root");
            ((Hashtable)props).put("ORBInitRef", tmp);
            if (log.TRACE) {
                log.trace("OrbInstanceFactory", "Using corbaloc -ORBInitRef NameService=" + glob.getProperty().get("ORBInitRef", (String)null) + " to find a naming service");
            }
        }
        return props;
    }

    public static ORB createOrbInstance(Global glob, String[] args, Properties props, AddressBase address) {
        Class clazz = class$java$lang$System == null ? (class$java$lang$System = OrbInstanceFactory.class$("java.lang.System")) : class$java$lang$System;
        synchronized (clazz) {
            Properties properties = OrbInstanceFactory.initializeOrbEnv(glob, address);
            if (props != null) {
                Enumeration<?> e = props.propertyNames();
                while (e.hasMoreElements()) {
                    String key = (String)e.nextElement();
                    ((Hashtable)properties).put(key, ((Hashtable)props).get(key));
                }
            }
            ORB anOrb = ORB.init(args, properties);
            boolean startNamingService = glob.getProperty().get("plugin/ior/useNameService", false);
            if (startNamingService) {
                OrbInstanceFactory.startNameService(glob);
            }
            ORB oRB = anOrb;
            return oRB;
        }
    }

    public static OrbInstanceWrapper getOrbInstanceWrapper(Global glob, String prefix) {
        if (glob == null) {
            throw new IllegalArgumentException("You called OrbInstanceFactory.getOrbInstanceWrapper() with glob==null");
        }
        Global global = glob;
        synchronized (global) {
            OrbInstanceWrapper orbInstanceWrapper = (OrbInstanceWrapper)glob.getObjectEntry(prefix + ":org.xmlBlaster.protocol.corba.OrbInstanceWrapper");
            if (orbInstanceWrapper == null) {
                orbInstanceWrapper = new OrbInstanceWrapper(glob);
                glob.addObjectEntry(prefix + ":org.xmlBlaster.protocol.corba.OrbInstanceWrapper", orbInstanceWrapper);
            }
            OrbInstanceWrapper orbInstanceWrapper2 = orbInstanceWrapper;
            return orbInstanceWrapper2;
        }
    }

    public static String extractHost(Object obj, ORB orb) {
        String host = null;
        if (obj != null && orb != null) {
            try {
                String objRef = orb.object_to_string(obj);
                OutputStream out = orb.create_output_stream();
                int cnt = (objRef.length() - 4) / 2;
                int i = 0;
                while (i < cnt) {
                    int o1 = i * 2 + 4;
                    int o2 = o1 + 2;
                    Integer b = Integer.valueOf(objRef.substring(o1, o2), 16);
                    out.write_octet(b.byteValue());
                    ++i;
                }
                InputStream in = out.create_input_stream();
                boolean littleEndian = in.read_boolean();
                IOR ior = IORHelper.read(in);
                int i2 = 0;
                while (host == null && i2 < ior.profiles.length) {
                    if (ior.profiles[i2].tag == 0) {
                        OutputStream prof_out = orb.create_output_stream();
                        byte[] prof_data = ior.profiles[i2].profile_data;
                        prof_out.write_octet_array(prof_data, 0, prof_data.length);
                        InputStream prof_in = prof_out.create_input_stream();
                        ProfileBody_1_1 body = ProfileBody_1_1Helper.read(prof_in);
                        host = body.host;
                    }
                    ++i2;
                }
            }
            catch (Exception e) {
                System.out.println("OrbInstanceFactory:" + e.toString());
            }
        }
        return host;
    }

    public static void startNameService(Global glob_) {
        if (nameServiceStarted) {
            return;
        }
        final String[] s = new String[]{};
        final Global glob = glob_ == null ? Global.instance() : glob_;
        new Thread(){

            public void run() {
                glob.getLog("corba").info("OrbInstanceFactory", "Starting embedded Jacorb namingService");
                JdkCompatible.setSystemProperty("org.omg.CORBA.ORBClass", "org.jacorb.orb.ORB");
                JdkCompatible.setSystemProperty("org.omg.CORBA.ORBSingletonClass", "org.jacorb.orb.ORBSingleton");
                NameServer.main(s);
            }
        }.start();
        nameServiceStarted = true;
        try {
            Thread.currentThread();
            Thread.sleep(2000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

