/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.protocol.corba;

import org.jutils.log.LogChannel;
import org.jutils.time.StopWatch;
import org.omg.CORBA.ORB;
import org.omg.PortableServer.Current;
import org.omg.PortableServer.CurrentHelper;
import org.xmlBlaster.protocol.I_XmlBlaster;
import org.xmlBlaster.protocol.corba.CorbaDriver;
import org.xmlBlaster.protocol.corba.serverIdl.MessageUnit;
import org.xmlBlaster.protocol.corba.serverIdl.ServerOperations;
import org.xmlBlaster.protocol.corba.serverIdl.XmlBlasterException;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.MsgUnitRaw;
import org.xmlBlaster.util.def.ErrorCode;

public class ServerImpl
implements ServerOperations {
    private final String ME = "ServerImpl";
    private final Global glob;
    private final LogChannel log;
    private final ORB orb;
    private final I_XmlBlaster blaster;

    public ServerImpl(Global glob, ORB orb, I_XmlBlaster blaster) throws XmlBlasterException {
        this.glob = glob;
        this.log = this.glob.getLog("corba");
        if (this.log.CALL) {
            this.log.call("ServerImpl", "Entering constructor with ORB argument");
        }
        this.orb = orb;
        this.blaster = blaster;
    }

    public I_XmlBlaster getXmlBlaster() {
        return this.blaster;
    }

    public String subscribe(String xmlKey_literal, String qos_literal) throws XmlBlasterException {
        try {
            if (this.log.CALL) {
                this.log.call("ServerImpl", "Entering subscribe() xmlKey=\n" + xmlKey_literal + ") ...");
            }
            if (this.log.DUMP) {
                this.log.dump("ServerImpl", "subscribe()\n" + xmlKey_literal + "\n" + qos_literal);
            }
            StopWatch stop = null;
            if (this.log.TIME) {
                stop = new StopWatch();
            }
            String oid = this.blaster.subscribe(this.getSecretSessionId(), xmlKey_literal, qos_literal);
            if (this.log.TIME) {
                this.log.time("ServerImpl", "Elapsed time in subscribe()" + stop.nice());
            }
            return oid;
        }
        catch (org.xmlBlaster.util.XmlBlasterException e) {
            throw CorbaDriver.convert(e);
        }
    }

    public String[] unSubscribe(String xmlKey_literal, String qos_literal) throws XmlBlasterException {
        try {
            if (this.log.CALL) {
                this.log.call("ServerImpl", "Entering unSubscribe() xmlKey=\n" + xmlKey_literal + ") ...");
            }
            if (this.log.DUMP) {
                this.log.dump("ServerImpl", "unSubscribe()\n" + xmlKey_literal + "\n" + qos_literal);
            }
            StopWatch stop = null;
            if (this.log.TIME) {
                stop = new StopWatch();
            }
            String[] strArr = this.blaster.unSubscribe(this.getSecretSessionId(), xmlKey_literal, qos_literal);
            if (this.log.TIME) {
                this.log.time("ServerImpl", "Elapsed time in unSubscribe()" + stop.nice());
            }
            return strArr;
        }
        catch (org.xmlBlaster.util.XmlBlasterException e) {
            throw CorbaDriver.convert(e);
        }
    }

    public String publish(MessageUnit msgUnit) throws XmlBlasterException {
        try {
            if (this.log.CALL) {
                this.log.call("ServerImpl", "Entering publish() ...");
            }
            if (this.log.DUMP) {
                this.log.dump("ServerImpl", "publish()\n" + msgUnit.xmlKey + "\n" + msgUnit.qos);
            }
            String retVal = this.blaster.publish(this.getSecretSessionId(), CorbaDriver.convert(this.glob, msgUnit));
            return retVal;
        }
        catch (org.xmlBlaster.util.XmlBlasterException e) {
            throw CorbaDriver.convert(e);
        }
    }

    public String[] publishArr(MessageUnit[] msgUnitArr) throws XmlBlasterException {
        try {
            if (this.log.CALL) {
                this.log.call("ServerImpl", "Entering publish(" + msgUnitArr.length + ") ...");
            }
            if (this.log.DUMP) {
                int ii = 0;
                while (ii < msgUnitArr.length) {
                    this.log.dump("ServerImpl", "publishArr()\n" + msgUnitArr[ii].xmlKey + "\n" + msgUnitArr[ii].qos);
                    ++ii;
                }
            }
            String[] returnArr = new String[]{};
            if (msgUnitArr.length < 1) {
                if (this.log.TRACE) {
                    this.log.trace("ServerImpl", "Entering xmlBlaster.publish(), nothing to do, zero msgUnits sent");
                }
                return returnArr;
            }
            MsgUnitRaw[] internalUnitArr = CorbaDriver.convert(this.glob, msgUnitArr);
            String[] strArr = this.blaster.publishArr(this.getSecretSessionId(), internalUnitArr);
            return strArr;
        }
        catch (org.xmlBlaster.util.XmlBlasterException e) {
            throw CorbaDriver.convert(e);
        }
    }

    public void publishOneway(MessageUnit[] msgUnitArr) {
        try {
            if (msgUnitArr == null || msgUnitArr.length < 1) {
                if (this.log.TRACE) {
                    this.log.trace("ServerImpl", "Entering xmlBlaster.publish(), nothing to do, zero msgUnits sent");
                }
                return;
            }
            if (this.log.CALL) {
                this.log.call("ServerImpl", "Entering publishOneway(" + msgUnitArr.length + ") ...");
            }
            MsgUnitRaw[] internalUnitArr = CorbaDriver.convert(this.glob, msgUnitArr);
            this.blaster.publishOneway(this.getSecretSessionId(), internalUnitArr);
        }
        catch (Throwable e) {
            this.log.error("ServerImpl", "publishOneway() failed, exception is not sent to client: " + e.toString());
            e.printStackTrace();
        }
    }

    public String[] erase(String xmlKey_literal, String qos_literal) throws XmlBlasterException {
        try {
            if (this.log.CALL) {
                this.log.call("ServerImpl", "Entering erase() xmlKey=\n" + xmlKey_literal + ") ...");
            }
            if (this.log.DUMP) {
                this.log.dump("ServerImpl", "erase()\n" + xmlKey_literal + "\n" + qos_literal);
            }
            String[] retArr = this.blaster.erase(this.getSecretSessionId(), xmlKey_literal, qos_literal);
            return retArr;
        }
        catch (org.xmlBlaster.util.XmlBlasterException e) {
            throw CorbaDriver.convert(e);
        }
    }

    public MessageUnit[] get(String xmlKey_literal, String qos_literal) throws XmlBlasterException {
        try {
            if (this.log.CALL) {
                this.log.call("ServerImpl", "Entering get() xmlKey=\n" + xmlKey_literal + ") ...");
            }
            if (this.log.DUMP) {
                this.log.dump("ServerImpl", "get()\n" + xmlKey_literal + "\n" + qos_literal);
            }
            StopWatch stop = null;
            if (this.log.TIME) {
                stop = new StopWatch();
            }
            MsgUnitRaw[] msgUnitArr = this.blaster.get(this.getSecretSessionId(), xmlKey_literal, qos_literal);
            MessageUnit[] corbaUnitArr = CorbaDriver.convert(msgUnitArr);
            if (this.log.TIME) {
                this.log.time("ServerImpl", "Elapsed time in get()" + stop.nice());
            }
            return corbaUnitArr;
        }
        catch (org.xmlBlaster.util.XmlBlasterException e) {
            throw CorbaDriver.convert(e);
        }
    }

    private String getSecretSessionId() throws XmlBlasterException {
        String sessionId;
        try {
            Current poa_current = CurrentHelper.narrow(this.orb.resolve_initial_references("POACurrent"));
            byte[] active_oid = poa_current.get_object_id();
            sessionId = ServerImpl.convert(active_oid);
        }
        catch (Exception e) {
            this.log.error("ServerImpl.AccessCheckProblem", "Sorry, can't find out who you are, access denied");
            throw CorbaDriver.convert(new org.xmlBlaster.util.XmlBlasterException(this.glob, ErrorCode.USER_SECURITY_AUTHENTICATION_ACCESSDENIED, "ServerImpl", "Sorry, can't find out who you are, access denied"));
        }
        return sessionId;
    }

    public static final String convert(byte[] objectId) {
        String result = "IIOP:";
        int i = 0;
        while (i < objectId.length) {
            int n1 = (objectId[i] & 0xFF) / 16;
            int n2 = (objectId[i] & 0xFF) % 16;
            char c1 = n1 > 9 ? (char)(65 + (n1 - 10)) : (char)(48 + n1);
            char c2 = n2 > 9 ? (char)(65 + (n2 - 10)) : (char)(48 + n2);
            result = result + c1 + c2 + "";
            ++i;
        }
        return result;
    }

    public String ping(String qos) {
        if (this.log.CALL) {
            this.log.call("ServerImpl", "Entering ping(" + qos + ") ...");
        }
        return this.blaster.ping(qos);
    }
}

