/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.protocol.email;

import java.util.Hashtable;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.jutils.log.LogChannel;
import org.xmlBlaster.protocol.I_CallbackDriver;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.MsgUnitRaw;
import org.xmlBlaster.util.XmlBlasterException;
import org.xmlBlaster.util.def.ErrorCode;
import org.xmlBlaster.util.plugin.PluginInfo;
import org.xmlBlaster.util.qos.address.CallbackAddress;

public class CallbackEmailDriver
implements I_CallbackDriver {
    private String ME = "CallbackEmailDriver";
    private Global glob = null;
    private LogChannel log = null;
    private CallbackAddress callbackAddress = null;

    public String getName() {
        return this.ME;
    }

    public String getProtocolId() {
        return "EMAIL";
    }

    public String getType() {
        return this.getProtocolId();
    }

    public String getVersion() {
        return "1.0";
    }

    public void init(Global glob, PluginInfo pluginInfo) {
    }

    public String getRawAddress() {
        return this.callbackAddress.getRawAddress();
    }

    public void init(Global glob, CallbackAddress callbackAddress) {
        this.glob = glob;
        this.log = glob.getLog("email");
        this.callbackAddress = callbackAddress;
    }

    public String[] sendUpdate(MsgUnitRaw[] msg) throws XmlBlasterException {
        if (msg == null || msg.length < 1) {
            throw new XmlBlasterException(this.glob, ErrorCode.INTERNAL_ILLEGALARGUMENT, this.ME, "Illegal sendUpdate() argument");
        }
        if (this.log.TRACE) {
            this.log.trace(this.ME, "xmlBlaster.update(" + msg.length + ") to " + this.callbackAddress.getSecretSessionId());
        }
        try {
            String smtpHost = this.glob.getProperty().get("EmailDriver.smtpHost", "localhost");
            String from = this.glob.getProperty().get("EmailDriver.from", "xmlblast@localhost");
            String to = this.callbackAddress.getRawAddress();
            Properties props = System.getProperties();
            ((Hashtable)props).put("mail.smtp.host", smtpHost);
            Session session = Session.getDefaultInstance((Properties)props, null);
            MimeMessage message = new MimeMessage(session);
            message.setFrom((Address)new InternetAddress(from));
            message.addRecipient(Message.RecipientType.TO, (Address)new InternetAddress(to));
            message.setSubject("XmlBlaster Generated Email");
            String text = this.getMailBody(msg);
            message.setText(text);
            this.log.info(this.ME + ".sendUpdate", "Sending email from " + from + " to " + to + ", smtpHost=" + smtpHost);
            if (this.log.DUMP) {
                this.log.dump(this.ME + ".sendUpdate", "\n" + text);
            }
            Transport.send((Message)message);
            String[] ret = new String[msg.length];
            int ii = 0;
            while (ii < ret.length) {
                ret[ii] = "<qos><state id='OK'/></qos>";
                ++ii;
            }
            return ret;
        }
        catch (Throwable e) {
            throw new XmlBlasterException(this.glob, ErrorCode.COMMUNICATION_NOCONNECTION, this.ME, "Sorry, email callback failed, no mail sent to " + this.callbackAddress.getRawAddress(), e);
        }
    }

    public void sendUpdateOneway(MsgUnitRaw[] msg) throws XmlBlasterException {
        this.sendUpdate(msg);
    }

    public String ping(String qos) throws XmlBlasterException {
        this.log.info(this.ME, "Email ping is not supported, request ignored");
        return "";
    }

    private String getMailBody(MsgUnitRaw[] msg) throws XmlBlasterException {
        StringBuffer sb = new StringBuffer();
        String offset = "\n";
        sb.append(offset).append("<xmlBlaster>");
        int ii = 0;
        while (ii < msg.length) {
            MsgUnitRaw msgUnit = msg[ii];
            sb.append(offset).append(msgUnit.getKey()).append("\n");
            sb.append(offset).append("   <content><![CDATA[").append(new String(msgUnit.getContent())).append("]]></content>");
            sb.append(offset).append(msgUnit.getQos());
            ++ii;
        }
        sb.append(offset).append("</xmlBlaster>\n");
        return sb.toString();
    }

    public void shutdown() {
        this.log.warn(this.ME, "shutdown implementation is missing");
    }

    public boolean isAlive() {
        return true;
    }
}

