/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.protocol.http;

import java.util.Hashtable;
import org.xmlBlaster.client.I_XmlBlasterAccess;
import org.xmlBlaster.protocol.http.HttpPushHandler;
import org.xmlBlaster.util.XmlBlasterException;

public class BlasterHttpProxy {
    private static final String ME = "BlasterHttpProxy";
    private static Hashtable httpPushHandlers = new Hashtable();
    private static Hashtable attributes = new Hashtable();

    public static Object getAttribute(String name) {
        return attributes.get(name);
    }

    public static void setAttribute(String name, Object obj) {
        attributes.put(name, obj);
    }

    public static void removeAttribute(String name) {
        attributes.remove(name);
    }

    public static I_XmlBlasterAccess getXmlBlasterAccess(String sessionId) throws XmlBlasterException {
        return BlasterHttpProxy.getHttpPushHandler(sessionId).getXmlBlasterAccess();
    }

    public static void addHttpPushHandler(String sessionId, HttpPushHandler httpPushHandler) throws XmlBlasterException {
        if (sessionId == null) {
            throw new XmlBlasterException("BlasterHttpProxy.NoSessionId", "Sorry, no valid session ID, are cookies disabled?");
        }
        Hashtable hashtable = httpPushHandlers;
        synchronized (hashtable) {
            httpPushHandlers.put(sessionId, httpPushHandler);
        }
    }

    public static HttpPushHandler getHttpPushHandler(String sessionId) throws XmlBlasterException {
        if (sessionId == null) {
            throw new XmlBlasterException("BlasterHttpProxy.NoSessionId", "Sorry, no valid session ID, are cookies disabled?");
        }
        Hashtable hashtable = httpPushHandlers;
        synchronized (hashtable) {
            HttpPushHandler pc = (HttpPushHandler)httpPushHandlers.get(sessionId);
            if (pc != null) {
                HttpPushHandler httpPushHandler = pc;
                return httpPushHandler;
            }
        }
        throw new XmlBlasterException(ME, "Session not registered yet (sessionId=" + sessionId + ")");
    }

    public static void cleanup(String sessionId) {
        Hashtable hashtable = httpPushHandlers;
        synchronized (hashtable) {
            httpPushHandlers.remove(sessionId);
        }
    }
}

