/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.protocol.http;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.jutils.log.LogChannel;
import org.jutils.log.LogableDevice;
import org.jutils.runtime.Memory;
import org.xmlBlaster.client.I_XmlBlasterAccess;
import org.xmlBlaster.client.key.EraseKey;
import org.xmlBlaster.client.key.SubscribeKey;
import org.xmlBlaster.client.key.UnSubscribeKey;
import org.xmlBlaster.client.qos.ConnectQos;
import org.xmlBlaster.client.qos.EraseReturnQos;
import org.xmlBlaster.client.qos.PublishReturnQos;
import org.xmlBlaster.client.qos.SubscribeReturnQos;
import org.xmlBlaster.client.qos.UnSubscribeReturnQos;
import org.xmlBlaster.protocol.http.BlasterHttpProxy;
import org.xmlBlaster.protocol.http.HttpPushHandler;
import org.xmlBlaster.protocol.http.PushDataItem;
import org.xmlBlaster.protocol.http.Util;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.MsgUnit;
import org.xmlBlaster.util.XmlBlasterException;
import org.xmlBlaster.util.def.ErrorCode;
import org.xmlBlaster.util.def.MethodName;

public class BlasterHttpProxyServlet
extends HttpServlet
implements LogableDevice {
    private static boolean propertyRead = false;
    private final String header = "<html><meta http-equiv='no-cache'><meta http-equiv='Cache-Control' content='no-cache'><meta http-equiv='expires' content='Wed, 26 Feb 1997 08:21:57 GMT'>";
    private Global glob = null;
    private LogChannel log;
    public static final String ENCODING = "UTF-8";

    public void init(ServletConfig conf) throws ServletException {
        super.init(conf);
        if (!propertyRead) {
            propertyRead = true;
            Enumeration enumer = conf.getInitParameterNames();
            int count = 0;
            while (enumer.hasMoreElements()) {
                if (enumer.nextElement() == null) continue;
                ++count;
            }
            String[] args = new String[2 * count];
            count = 0;
            enumer = conf.getInitParameterNames();
            while (enumer.hasMoreElements()) {
                String name = (String)enumer.nextElement();
                if (name == null) continue;
                args[count++] = !name.startsWith("-") ? "-" + name : name;
                args[count++] = conf.getInitParameter(name);
            }
            this.glob = new Global();
            int ret = this.glob.init(args);
            this.log = this.glob.getLog(null);
            if (ret != 0) {
                // empty if block
            }
        }
        this.log.trace("BlasterHttpProxyServlet", "Initialize ...");
        BlasterHttpProxyServlet.initSystemProperties(conf);
    }

    public void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        block43: {
            if (this.log.CALL) {
                this.log.call("BlasterHttpProxyServlet", "Entering doGet() ... " + Memory.getStatistic());
            }
            res.setContentType("text/html");
            String errorText = "";
            String ME = "BlasterHttpProxyServlet-" + req.getRemoteAddr();
            String actionType = Util.getParameter(req, "ActionType", "");
            if (actionType == null) {
                String str = "Please call servlet with some ActionType";
                this.log.error(ME, str);
                this.htmlOutput(str, res);
                return;
            }
            HttpSession session = req.getSession(true);
            if (actionType.equals("login")) {
                boolean invalidate = Util.getParameter(req, "xmlBlaster.invalidate", true);
                if (invalidate) {
                    this.log.info(ME, "Entering servlet doGet(), forcing a new sessionId");
                    session.invalidate();
                }
                session = req.getSession(true);
            }
            String sessionId = session.getId();
            ME = ME + "-" + sessionId;
            if (this.log.TRACE) {
                this.log.trace(ME, "Entering servlet doGet() ...");
            }
            if (sessionId == null) {
                PrintWriter out = res.getWriter();
                out.println(HttpPushHandler.alert("Sorry, your sessionId is invalid"));
                return;
            }
            try {
                if (actionType.equals("login") || actionType.equals("connect")) {
                    ConnectQos connectQos;
                    if (actionType.equals("connect")) {
                        String qos = Util.getParameter(req, "xmlBlaster.connectQos", null);
                        if (qos == null || qos.length() < 1) {
                            throw new XmlBlasterException(this.glob, ErrorCode.USER_CONFIGURATION, ME, "Missing connect QoS. Pass xmlBlaster.connectQos='<qos> ... </qos>' with your URL in your POST in a hidden form field or in your cookie.");
                        }
                        connectQos = new ConnectQos(this.glob, this.glob.getConnectQosFactory().readObject(qos));
                    } else {
                        String loginName = Util.getParameter(req, "xmlBlaster.loginName", null);
                        if (loginName == null || loginName.length() < 1) {
                            throw new XmlBlasterException(this.glob, ErrorCode.USER_CONFIGURATION, ME, "Missing login name. Pass xmlBlaster.loginName=xy with your URL or in your cookie.");
                        }
                        String passwd = Util.getParameter(req, "xmlBlaster.passwd", null);
                        if (passwd == null || passwd.length() < 1) {
                            throw new XmlBlasterException(this.glob, ErrorCode.USER_CONFIGURATION, ME, "Missing passwd");
                        }
                        connectQos = new ConnectQos(this.glob, loginName, passwd);
                    }
                    ME = "BlasterHttpProxyServlet-" + req.getRemoteAddr() + "-" + connectQos.getSessionName().getLoginName() + "-" + sessionId;
                    I_XmlBlasterAccess xmlBlasterAccess = this.glob.getXmlBlasterAccess();
                    HttpPushHandler pushHandler = new HttpPushHandler(req, res, sessionId, connectQos.getSessionName().getRelativeName(), xmlBlasterAccess);
                    xmlBlasterAccess.connect(connectQos, pushHandler);
                    if (!session.isNew()) {
                        pushHandler.startPing();
                    } else {
                        this.log.info(ME, "Login action, browser has not yet joined this sessionId (cookie), so first pings pong may return an invalid sessionId");
                        pushHandler.startPing();
                    }
                    BlasterHttpProxy.addHttpPushHandler(sessionId, pushHandler);
                    this.log.info(ME, "Waiting forever, permanent HTTP connection from " + req.getRemoteHost() + "/" + req.getRemoteAddr() + ", sessionName=" + connectQos.getSessionName().getRelativeName() + " sessionId=" + sessionId + "', protocol='" + req.getProtocol() + "', agent='" + req.getHeader("User-Agent") + "', referer='" + req.getHeader("Referer") + "'.");
                    if (this.log.TRACE) {
                        this.log.trace(ME, "user='" + req.getRemoteUser() + "', serverPort='" + req.getServerPort() + "', query='" + req.getQueryString() + "', pathInfo='" + req.getPathInfo() + "', pathTranslated='" + req.getPathTranslated() + "', servletPath='" + req.getServletPath() + "', documentRoot='" + this.getServletConfig().getServletContext().getRealPath("/") + "', accept='" + req.getHeader("Accept") + "', referer='" + req.getHeader("Referer") + "', authorization='" + req.getHeader("Authorization") + "'.");
                    }
                    pushHandler.setBrowserIsReady(true);
                    pushHandler.ping("loginSucceeded");
                    while (!pushHandler.closed()) {
                        try {
                            Thread.currentThread();
                            Thread.sleep(10000L);
                        }
                        catch (InterruptedException i) {
                            this.log.error(ME, "Error in Thread handling, don't know what to do: " + i.toString());
                            pushHandler.cleanup();
                            break;
                        }
                    }
                    pushHandler = null;
                    this.log.info(ME, "Persistent HTTP connection lost, leaving doGet() ....");
                    break block43;
                }
                if (actionType.equals("dummyToCreateASessionId")) {
                    this.log.info(ME, "doGet: dummyToCreateASessionId");
                    PrintWriter out = res.getWriter();
                    out.println("<html><meta http-equiv='no-cache'><meta http-equiv='Cache-Control' content='no-cache'><meta http-equiv='expires' content='Wed, 26 Feb 1997 08:21:57 GMT'><body text='white' bgcolor='white'>Empty response for your ActionType='dummyToCreateASessionId' " + System.currentTimeMillis() + "</body></html>");
                    return;
                }
                if (actionType.equals("browserReady")) {
                    try {
                        HttpPushHandler pushHandler = BlasterHttpProxy.getHttpPushHandler(sessionId);
                        if (this.log.TRACE) {
                            this.log.trace(ME, "Received 'browserReady'");
                        }
                        pushHandler.setBrowserIsReady(true);
                        PrintWriter out = res.getWriter();
                        out.println("<html><meta http-equiv='no-cache'><meta http-equiv='Cache-Control' content='no-cache'><meta http-equiv='expires' content='Wed, 26 Feb 1997 08:21:57 GMT'><body text='white' bgcolor='white'>Empty response for your ActionType='browserReady' " + System.currentTimeMillis() + "</body></html>");
                        return;
                    }
                    catch (XmlBlasterException e) {
                        this.log.error(ME, "Caught XmlBlaster Exception for actionType '" + actionType + "': " + e.getMessage());
                        return;
                    }
                }
                if (actionType.equals("pong")) {
                    try {
                        HttpPushHandler pushHandler = BlasterHttpProxy.getHttpPushHandler(sessionId);
                        pushHandler.pong();
                        if (this.log.TRACE) {
                            this.log.trace(ME, "Received pong '" + Util.getParameter(req, "state", "noState") + "'");
                        }
                        PrintWriter out = res.getWriter();
                        out.println("<html><meta http-equiv='no-cache'><meta http-equiv='Cache-Control' content='no-cache'><meta http-equiv='expires' content='Wed, 26 Feb 1997 08:21:57 GMT'><body text='white' bgcolor='white'>Empty response for your ActionType='pong' " + Util.getParameter(req, "state", "noState") + " " + System.currentTimeMillis() + "</body></html>");
                        return;
                    }
                    catch (XmlBlasterException e) {
                        this.log.error(ME, "Caught XmlBlaster Exception for actionType '" + actionType + "': " + e.getMessage());
                        return;
                    }
                }
                if (MethodName.PUBLISH.toString().equalsIgnoreCase(actionType)) {
                    this.doPost(req, res);
                    break block43;
                }
                if (MethodName.SUBSCRIBE.toString().equalsIgnoreCase(actionType)) {
                    this.doPost(req, res);
                    break block43;
                }
                if (MethodName.UNSUBSCRIBE.toString().equalsIgnoreCase(actionType)) {
                    this.doPost(req, res);
                    break block43;
                }
                if (MethodName.GET.toString().equalsIgnoreCase(actionType)) {
                    this.doPost(req, res);
                    break block43;
                }
                if (MethodName.ERASE.toString().equalsIgnoreCase(actionType)) {
                    this.doPost(req, res);
                    break block43;
                }
                if (MethodName.PING.toString().equalsIgnoreCase(actionType)) {
                    this.doPost(req, res);
                    break block43;
                }
                if (actionType.equals("logout")) {
                    this.log.info(ME, "Logout arrived ...");
                    try {
                        HttpPushHandler pc = BlasterHttpProxy.getHttpPushHandler(sessionId);
                        pc.cleanup();
                    }
                    catch (XmlBlasterException e) {
                        this.log.error(ME, e.toString());
                    }
                    PrintWriter out = res.getWriter();
                    out.println("<html><meta http-equiv='no-cache'><meta http-equiv='Cache-Control' content='no-cache'><meta http-equiv='expires' content='Wed, 26 Feb 1997 08:21:57 GMT'> <body text='white' bgcolor='white'><script language='JavaScript' type='text/javascript'>top.close()</script></body></html>");
                    break block43;
                }
                String text = "Unknown ActionType '" + actionType + "', request for permanent http connection ignored";
                throw new XmlBlasterException(this.glob, ErrorCode.USER_CONFIGURATION, ME, text);
            }
            catch (XmlBlasterException e) {
                this.log.error(ME, "Caught XmlBlaster Exception: " + e.getMessage());
                String codedText = Global.encode(e.getMessage(), ENCODING);
                try {
                    HttpPushHandler pushHandler = BlasterHttpProxy.getHttpPushHandler(sessionId);
                    pushHandler.push(new PushDataItem(1, "if (parent.error != null) parent.error('" + codedText + "');\n"));
                }
                catch (XmlBlasterException e2) {
                    PrintWriter out = res.getWriter();
                    out.println(HttpPushHandler.alert(e.getMessage()));
                }
            }
            catch (Exception e) {
                this.log.error(ME, "Caught Exception: " + e.toString());
                e.printStackTrace();
                try {
                    HttpPushHandler pushHandler = BlasterHttpProxy.getHttpPushHandler(sessionId);
                    pushHandler.push(new PushDataItem(1, "if (parent.error != null) parent.error('" + e.toString() + "');\n"));
                }
                catch (XmlBlasterException e2) {
                    PrintWriter out = res.getWriter();
                    out.println(HttpPushHandler.alert(e.toString()));
                }
            }
        }
    }

    public void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        block28: {
            res.setContentType("text/html");
            PrintWriter out = res.getWriter();
            HttpSession session = req.getSession(false);
            String sessionId = req.getRequestedSessionId();
            String ME = "BlasterHttpProxyServlet-" + req.getRemoteAddr() + "-" + sessionId;
            this.log.info(ME, "Entering servlet doPost() ...");
            I_XmlBlasterAccess xmlBlaster = null;
            HttpPushHandler pushHandler = null;
            Object returnObject = null;
            try {
                pushHandler = BlasterHttpProxy.getHttpPushHandler(sessionId);
                xmlBlaster = pushHandler.getXmlBlasterAccess();
            }
            catch (XmlBlasterException e) {
                this.log.error(ME, "Caught XmlBlaster Exception: " + e.getMessage());
                return;
            }
            try {
                String qos;
                String content;
                String key;
                MethodName action;
                String actionType = Util.getParameter(req, "ActionType", "NONE");
                try {
                    action = MethodName.toMethodName(actionType);
                }
                catch (IllegalArgumentException ie) {
                    throw new Exception("Unknown or missing 'ActionType=" + actionType + "' please choose 'subscribe' 'unSubscribe' 'erase' etc.");
                }
                String oid = Util.getParameter(req, "key.oid", null);
                if (oid != null) {
                    oid = Global.decode(oid, ENCODING);
                }
                if ((key = Util.getParameter(req, "key", null)) != null) {
                    key = Global.decode(key, ENCODING);
                    if (this.log.DUMP) {
                        this.log.dump(ME, "key=\n'" + key + "'");
                    }
                }
                content = (content = Util.getParameter(req, "content", null)) != null ? Global.decode(content, ENCODING) : "";
                if (this.log.DUMP) {
                    this.log.dump(ME, "content=\n'" + content + "'");
                }
                qos = (qos = Util.getParameter(req, "qos", null)) != null ? Global.decode(qos, ENCODING) : "";
                if (this.log.DUMP) {
                    this.log.dump(ME, "qos=\n'" + qos + "'");
                }
                if (action.equals(MethodName.SUBSCRIBE)) {
                    this.log.trace(ME, "subscribe arrived ...");
                    if (oid != null) {
                        SubscribeKey xmlKey = new SubscribeKey(this.glob, oid);
                        SubscribeReturnQos ret = xmlBlaster.subscribe(xmlKey.toXml(), qos);
                        this.log.info(ME, "Subscribed to simple key.oid=" + oid + ": " + ret.getSubscriptionId());
                        break block28;
                    }
                    if (key != null) {
                        SubscribeReturnQos ret = xmlBlaster.subscribe(key, qos);
                        this.log.info(ME, "Subscribed to " + key + ": SubscriptionId=" + ret.getSubscriptionId() + " qos=" + qos);
                        break block28;
                    }
                    String str = "Please call servlet with some 'key.oid=...' or 'key=<key ...' when subscribing";
                    this.log.error(ME, str);
                    this.htmlOutput(str, res);
                    return;
                }
                if (action.equals(MethodName.UNSUBSCRIBE)) {
                    this.log.trace(ME, "unSubscribe arrived ...");
                    if (oid != null) {
                        UnSubscribeKey xmlKey = new UnSubscribeKey(this.glob, oid);
                        UnSubscribeReturnQos[] ret = xmlBlaster.unSubscribe(xmlKey.toXml(), qos);
                        break block28;
                    }
                    if (key != null) {
                        UnSubscribeReturnQos[] ret = xmlBlaster.unSubscribe(key, qos);
                        break block28;
                    }
                    String str = "Please call servlet with some 'key.oid=...' or 'key=<key ...' when unsubscribing";
                    this.log.error(ME, str);
                    this.htmlOutput(str, res);
                    return;
                }
                if (action.equals(MethodName.GET)) {
                    throw new Exception("Synchronous ActionType=get is not supported");
                }
                if (action.equals(MethodName.PUBLISH)) {
                    this.log.trace(ME, "publish arrived ...");
                    if (key == null) {
                        String str = "Please call servlet with some key when publishing";
                        this.log.error(ME, str);
                        this.htmlOutput(str, res);
                        return;
                    }
                    if (content == null) {
                        content = "";
                    }
                    this.log.info(ME, "Publishing '" + key + "'");
                    MsgUnit msgUnit = new MsgUnit(this.glob, key, content.getBytes(), qos);
                    try {
                        PublishReturnQos prq = xmlBlaster.publish(msgUnit);
                        this.log.trace(ME, "Success: Publishing done, returned oid=" + prq.getKeyOid());
                    }
                    catch (XmlBlasterException e) {
                        this.log.warn(ME, "XmlBlasterException: " + e.getMessage());
                    }
                    break block28;
                }
                if (action.equals(MethodName.ERASE)) {
                    this.log.trace(ME, "erase arrived ...");
                    if (oid != null) {
                        EraseKey ek = new EraseKey(this.glob, oid);
                        EraseReturnQos[] ret = xmlBlaster.erase(ek.toXml(), qos);
                        break block28;
                    }
                    if (key != null) {
                        EraseReturnQos[] ret = xmlBlaster.erase(key, qos);
                        break block28;
                    }
                    String str = "Please call servlet with some 'key.oid=...' or 'key=<key ...' when subscribing";
                    this.log.error(ME, str);
                    this.htmlOutput(str, res);
                    return;
                }
                if (action.equals(MethodName.PING)) {
                    this.log.trace(ME, "ping arrived, doing nothing ...");
                    break block28;
                }
                throw new Exception("Unknown or missing 'ActionType=" + actionType + "' please choose 'subscribe' 'unSubscribe' 'erase' etc.");
            }
            catch (XmlBlasterException e) {
                this.log.error(ME, "Caught XmlBlaster Exception: " + e.getMessage());
                String codedText = Global.encode(e.getMessage(), ENCODING);
                pushHandler.push(new PushDataItem(1, "if (parent.error != null) parent.error('" + codedText + "');\n"));
            }
            catch (Exception e) {
                this.log.error(ME, "RemoteException: " + e.getMessage());
                e.printStackTrace();
                out.println("<body>http communication problem</body>");
            }
        }
    }

    public static final void initSystemProperties(ServletConfig conf) {
        String ME = "BlasterHttpProxyServlet";
        Properties props = System.getProperties();
        LogChannel log = Global.instance().getLog("http");
        if (conf.getInitParameter("org.omg.CORBA.ORBClass") != null) {
            ((Hashtable)props).put("org.omg.CORBA.ORBClass", conf.getInitParameter("org.omg.CORBA.ORBClass"));
            log.info(ME, "Using servlet system parameter org.omg.CORBA.ORBClass=" + ((Hashtable)props).get("org.omg.CORBA.ORBClass"));
        }
        if (conf.getInitParameter("org.omg.CORBA.ORBSingletonClass") != null) {
            ((Hashtable)props).put("org.omg.CORBA.ORBSingletonClass", conf.getInitParameter("org.omg.CORBA.ORBSingletonClass"));
            log.info(ME, "Using servlet system parameter org.omg.CORBA.ORBSingletonClass=" + ((Hashtable)props).get("org.omg.CORBA.ORBSingletonClass"));
        }
        if (conf.getInitParameter("org.xml.sax.parser") != null) {
            ((Hashtable)props).put("org.xml.sax.parser", conf.getInitParameter("org.xml.sax.parser"));
            log.trace(ME, "Found system parameter org.xml.sax.parser=" + conf.getInitParameter("org.xml.sax.parser"));
        } else {
            ((Hashtable)props).put("org.xml.sax.parser", "org.apache.crimson.parser.Parser2");
        }
        log.info(ME, "Using system parameter org.xml.sax.parser=" + ((Hashtable)props).get("org.xml.sax.parser"));
        if (((Hashtable)props).size() > 0) {
            System.setProperties(props);
        }
    }

    public void log(int level, String source, String str) {
        this.getServletContext().log(str);
    }

    public void htmlOutput(String htmlData, HttpServletResponse response) throws ServletException {
        String ME = "BlasterHttpProxyServlet";
        response.setContentType("text/html");
        try {
            PrintWriter pw = response.getWriter();
            pw.println(htmlData);
            pw.close();
        }
        catch (IOException e) {
            this.log.warn(ME, "Could not deliver HTML page to browser:" + e.toString());
            throw new ServletException(e.toString());
        }
    }

    public void popupError(HttpServletResponse response, String error) {
        String ME = "BlasterHttpProxyServlet";
        try {
            response.setContentType("text/html");
            PrintWriter pw = response.getWriter();
            pw.println(HttpPushHandler.alert(error));
            pw.close();
        }
        catch (IOException e) {
            this.log.error(ME, "Sending of error failed: " + error + "\n Reason=" + e.toString());
        }
    }

    public void xmlOutput(String xmlData, HttpServletResponse response) throws ServletException {
        String ME = "BlasterHttpProxyServlet";
        response.setContentType("text/xml");
        try {
            PrintWriter pw = response.getWriter();
            pw.println(xmlData);
            pw.close();
        }
        catch (IOException e) {
            PrintWriter pw;
            String text = "Sending XML data to browser failed: " + e.toString();
            this.log.warn(ME, text);
            try {
                pw = response.getWriter();
            }
            catch (IOException e2) {
                this.log.error(ME, "2.xml send problem");
                return;
            }
            pw.println("<html><body>Request Problems" + text + "</body></html>");
            pw.close();
        }
    }
}

