/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.protocol.http;

import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.jutils.log.LogChannel;
import org.xmlBlaster.protocol.http.Util;
import org.xmlBlaster.util.Global;

public class BrowserTest
extends HttpServlet {
    private final String ME = "BrowserTest";
    private int globalVal = 1;
    private String mode = "multi";
    private LogChannel log;

    public void init(ServletConfig conf) throws ServletException {
        super.init(conf);
        this.log = Global.instance().getLog(null);
        this.log.info("BrowserTest", "Initialize ...");
    }

    public void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        res.setContentType("text/html");
        PrintWriter out = res.getWriter();
        HttpSession session = req.getSession(true);
        String sessionId = req.getRequestedSessionId();
        String loginName = Util.getParameter(req, "login", null);
        String password = Util.getParameter(req, "password", null);
        this.log.info("BrowserTest", "Entering BrowserTest servlet for '" + loginName + "', sessionId=" + sessionId);
        StringBuffer retStr = new StringBuffer();
        try {
            try {
                String actionType = Util.getParameter(req, "ActionType", null);
                if (actionType != null && actionType.equals("Login")) {
                    this.log.info("BrowserTest", "Login pressed ...");
                    if (loginName == null || loginName.length() < 1) {
                        throw new Exception("Missing login name");
                    }
                    if (password == null || password.length() < 1) {
                        throw new Exception("Missing password");
                    }
                } else if (actionType != null && actionType.equals("Logout")) {
                    this.log.info("BrowserTest", "Logout pressed ...");
                } else {
                    throw new Exception("Unknown action type");
                }
                Object var11_11 = null;
                out.println(retStr.toString());
            }
            catch (Exception e) {
                this.log.error("BrowserTest", "RemoteException: " + e.getMessage());
                e.printStackTrace();
                retStr.append("<body>http communication problem</body>");
                Object var11_12 = null;
                out.println(retStr.toString());
            }
        }
        catch (Throwable throwable) {
            Object var11_13 = null;
            out.println(retStr.toString());
            throw throwable;
        }
    }

    public void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        this.log.info("BrowserTest", "Entering doGet()");
        String tmp = Util.getParameter(req, "mode", null);
        if (tmp != null) {
            this.mode = tmp;
            this.log.info("BrowserTest", "Testing mode=" + this.mode);
        }
        try {
            if (this.mode.equals("multi")) {
                ServletOutputStream out = res.getOutputStream();
                res.setContentType("multipart/x-mixed-replace;boundary=End");
                out.println();
                out.println("--End");
                int val = 1;
                do {
                    this.log.info("BrowserTest", "Sending next multipart");
                    out.println("Content-Type: text/html");
                    out.println();
                    out.println("<HTML>");
                    out.println("<HEAD>");
                    out.println("<meta http-equiv='Content-Type' content='text/html; charset=iso-8859-1'>");
                    out.println("<meta http-equiv='Pragma' content='no-cache'>");
                    out.println("<meta http-equiv='Expires' content='Tue, 31 Dec 1997 23:59:59 GMT'>");
                    out.println("<TITLE>Hello World</TITLE>");
                    out.println("</HEAD>");
                    out.println("<BODY>");
                    out.println("<BIG>Hello World - GET - multipart No." + val++ + "</BIG>");
                    out.println("<p /><A HREF='http://www.xmlBlaster.org'>XmlBlaster</A> <-- click to abort");
                    out.println("</BODY></HTML>");
                    out.println();
                    out.println("--End");
                    out.flush();
                    try {
                        Thread.currentThread();
                        Thread.sleep(2104L);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                } while (val <= 10);
                out.close();
            } else if (this.mode.equals("poll")) {
                PrintWriter out = res.getWriter();
                res.setContentType("text/html");
                if (this.globalVal % 2 == 0) {
                    ++this.globalVal;
                    this.log.info("BrowserTest", "SC_NO_CONTENT globalVal=" + this.globalVal);
                    res.setStatus(204);
                    return;
                }
                this.log.info("BrowserTest", "globalVal=" + this.globalVal);
                out.println("<HTML>");
                out.println("<HEAD>");
                out.println("<meta http-equiv='Content-Type' content='text/html; charset=iso-8859-1'>");
                out.println("<meta http-equiv='Pragma' content='no-cache'>");
                out.println("<meta http-equiv='refresh' content='2;URL=/xmlBlaster/BrowserTest?mode=poll'>");
                out.println("<TITLE>Hello World</TITLE>");
                out.println("</HEAD>");
                out.println("<BODY>");
                out.println("<BIG>Hello World - GET - Polling No." + this.globalVal++ + "</BIG>");
                out.println("</BODY></HTML>");
                out.flush();
                out.close();
            } else if (this.mode.equals("push")) {
                PrintWriter out = res.getWriter();
                res.setContentType("text/html");
                res.setHeader("Cache-Control", "no-cache");
                res.setHeader("Expires", "1 Jan 2000");
                int val = 1;
                out.println("<HTML>");
                out.println("<HEAD>");
                out.println("<meta http-equiv='Content-Type' content='text/html; charset=iso-8859-1'>");
                out.println("<meta http-equiv='Pragma' content='no-cache'>");
                out.println("<meta http-equiv='Expires' content='Tue, 31 Dec 1997 23:59:59 GMT'>");
                out.println("<TITLE>Hello World</TITLE>");
                out.println("</HEAD>");
                out.println("<BODY>");
                while (true) {
                    out.println("<BIG>Hello World - GET - Simple server push No." + val++ + "</BIG>");
                    out.println("<P>");
                    this.log.info("BrowserTest", "Flushing number " + (val - 1) + " ...");
                    out.println("<script language='JavaScript' type='text/javascript'>");
                    out.println("alert('Hoi Michele');");
                    out.println("</script>");
                    out.flush();
                    this.log.info("BrowserTest", "Before sleeping 2 sec ...");
                    try {
                        Thread.currentThread();
                        Thread.sleep(2000L);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    if (val > 10) break;
                    this.log.info("BrowserTest", "After sleeping 2 sec send next ...");
                }
                out.println("</BODY></HTML>");
                out.flush();
                out.close();
            } else if (this.mode.equals("pushall")) {
                PrintWriter out = res.getWriter();
                res.setContentType("text/html");
                res.setHeader("Cache-Control", "no-cache");
                res.setHeader("Expires", "1 Jan 2000");
                int val = 1;
                do {
                    out.println("<HTML>");
                    out.println("<HEAD>");
                    out.println("<meta http-equiv='Content-Type' content='text/html; charset=iso-8859-1'>");
                    out.println("<meta http-equiv='Pragma' content='no-cache'>");
                    out.println("<meta http-equiv='Expires' content='Tue, 31 Dec 1997 23:59:59 GMT'>");
                    out.println("<TITLE>Hello World</TITLE>");
                    out.println("</HEAD>");
                    out.println("<BODY>");
                    out.println("<BIG>Hello World - GET - Simple server push No." + val++ + "</BIG>");
                    out.println("<P>");
                    out.println("</BODY></HTML>");
                    out.flush();
                    try {
                        Thread.currentThread();
                        Thread.sleep(2000L);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                } while (val <= 10);
                out.close();
            }
            this.log.info("BrowserTest", "doGet() done");
        }
        catch (Exception e) {
            this.log.error("BrowserTest", "doGet() failed, " + e.toString());
        }
    }
}

