/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.protocol.http;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Vector;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jutils.log.LogChannel;
import org.jutils.text.StringHelper;
import org.xmlBlaster.client.I_Callback;
import org.xmlBlaster.client.I_XmlBlasterAccess;
import org.xmlBlaster.client.key.UpdateKey;
import org.xmlBlaster.client.qos.UpdateQos;
import org.xmlBlaster.protocol.http.BlasterHttpProxy;
import org.xmlBlaster.protocol.http.PushDataItem;
import org.xmlBlaster.util.Global;

public class HttpPushHandler
implements I_Callback {
    private String ME = "HttpPushHandler";
    private LogChannel log = Global.instance().getLog("http");
    private final long PING_INTERVAL = 10000L;
    private I_XmlBlasterAccess xmlBlasterAccess;
    private I_Callback callbackInterceptor;
    private HttpServletRequest req = null;
    private HttpServletResponse res = null;
    private String sessionId = null;
    private boolean closed = false;
    private ServletOutputStream outMulti;
    private PrintWriter outPlain;
    private String head;
    private String tail;
    private boolean browserIsReady = false;
    private boolean handlesMultipart = false;
    private HttpPingThread pingThread = null;
    private Vector pushQueue = null;
    private boolean firstPush = true;

    public HttpPushHandler(HttpServletRequest req, HttpServletResponse res, String sessionId, String loginName, I_XmlBlasterAccess xmlBlasterAccess) throws ServletException, IOException {
        this.req = req;
        this.res = res;
        this.sessionId = sessionId;
        this.xmlBlasterAccess = xmlBlasterAccess;
        String browserId = req.getRemoteAddr() + "-" + loginName + "-" + sessionId;
        this.ME = "HttpPushHandler-" + browserId;
        this.initialize(null, null);
        this.pushQueue = new Vector();
        this.setBrowserIsReady(true);
        this.log.trace(this.ME, "Creating PingThread ...");
        this.pingThread = new HttpPingThread(this, 10000L, browserId);
    }

    public I_XmlBlasterAccess getXmlBlasterAccess() {
        return this.xmlBlasterAccess;
    }

    private void initialize(String head, String tail) throws IOException {
        if (this.log.TRACE) {
            this.log.trace(this.ME, "Creating HttpPushHandler ...");
        }
        this.head = head;
        this.tail = tail;
        this.handlesMultipart = this.doesHandleMultipart();
        if (this.handlesMultipart) {
            this.outMulti = this.res.getOutputStream();
        } else {
            this.outPlain = this.res.getWriter();
        }
        this.log.trace(this.ME, "Initialize ...");
        if (this.head == null) {
            this.head = "<!DOCTYPE HTML PUBLIC \"-//IETF//DTD HTML//EN\"><HTML>\n<HEAD>\n   <meta http-equiv='Content-Type' content='text/html; charset=iso-8859-1'>\n   <meta http-equiv='Pragma' content='no-cache'>\n   <meta http-equiv='Cache-Control' content='no-cache'>\n   <meta http-equiv='Expires' content='Tue, 31 Dec 1997 23:59:59 GMT'>\n   <TITLE>BlasterHttpProxy Connection</TITLE>\n</HEAD>\n<BODY>\n   <br>&nbsp;\n   <br>&nbsp;\n   <form ACTION=\"\" METHOD=\"POST\" TARGET=\"callback\">\n      <INPUT TYPE=\"HIDDEN\" NAME=\"NoName\" VALUE=\"NoValue\" />\n   </form>\n   <script language='JavaScript' type='text/javascript'>\n";
        }
        if (this.handlesMultipart) {
            if (this.tail == null) {
                this.tail = "</script>\n</BODY></HTML>";
            }
            this.res.setContentType("multipart/x-mixed-replace;boundary=End");
            this.outMulti.println();
            this.outMulti.println("--End");
        } else {
            this.res.setContentType("text/html");
        }
    }

    public void shutdownBrowserConnection() {
        try {
            this.setClosed(true);
            this.setBrowserIsReady(false);
            if (this.handlesMultipart) {
                this.outMulti.close();
            } else {
                this.outPlain.close();
            }
            this.pingThread.stopThread();
            this.log.info(this.ME, "Closed push connection to browser");
        }
        catch (Exception e) {
            this.log.error(this.ME, "Error occurred while de-initializing the push handler :" + e.toString());
        }
    }

    public void setProxyInterceptor(I_Callback interceptor) {
        this.callbackInterceptor = interceptor;
    }

    public void cleanup() {
        if (this.log.CALL) {
            this.log.call(this.ME, "Entering cleanup(" + this.sessionId + ") ...");
        }
        try {
            if (this.sessionId != null) {
                BlasterHttpProxy.cleanup(this.sessionId);
            }
            if (this.xmlBlasterAccess != null) {
                this.xmlBlasterAccess.disconnect(null);
                this.log.info(this.ME, "XmlBlaster connection removed");
                this.xmlBlasterAccess = null;
            }
            this.callbackInterceptor = null;
            this.shutdownBrowserConnection();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.log.error(this.ME, "Can't destroy http connection for sessionId=" + this.sessionId + ": " + e.toString());
        }
    }

    public void startPing() throws ServletException, IOException {
        this.pingThread.start();
        this.ping("refresh");
    }

    public boolean closed() {
        return this.closed;
    }

    public void setClosed(boolean closed) {
        if (this.log.TRACE) {
            this.log.trace(this.ME, "Setting closed from " + this.closed + " to " + closed);
        }
        this.closed = closed;
    }

    public final boolean isBrowserReady() {
        return this.browserIsReady;
    }

    public void setBrowserIsReady(boolean ready) {
        if (this.closed()) {
            this.browserIsReady = false;
            return;
        }
        this.browserIsReady = ready;
        if (this.log.TRACE) {
            this.log.trace(this.ME, "Setting browserReady=" + this.browserIsReady);
        }
        this.pong();
        if (this.browserIsReady) {
            try {
                this.pushToBrowser();
            }
            catch (Exception e) {
                this.log.error(this.ME, "sending push queue to browser failed. [" + e.toString() + "]");
                this.shutdownBrowserConnection();
            }
        }
    }

    private boolean doesHandleMultipart() throws IOException {
        String browser = this.req.getHeader("User-Agent");
        boolean doesMulti = false;
        if (browser == null) {
            doesMulti = false;
        } else if (browser.indexOf("Mozilla") != -1 && browser.indexOf("MSIE") == -1 && browser.indexOf("Opera") == -1) {
            doesMulti = true;
        }
        if (doesMulti) {
            this.log.info(this.ME, "Checking browser = " + browser + ". Assuming it supports 'multipart requests'");
        } else {
            this.log.info(this.ME, "Checking browser = " + browser + ". We won't use 'multipart requests'");
        }
        return doesMulti;
    }

    public void push(PushDataItem item) throws ServletException, IOException {
        if (this.closed()) {
            return;
        }
        Vector vector = this.pushQueue;
        synchronized (vector) {
            this.pushQueue.addElement(item);
            this.pushToBrowser();
        }
    }

    private void pushToBrowser() throws ServletException, IOException {
        if (this.log.CALL) {
            this.log.call(this.ME, "Entering pushToBrowser() ...");
        }
        Vector vector = this.pushQueue;
        synchronized (vector) {
            if (this.pushQueue.size() == 0) {
                return;
            }
            if (!this.isBrowserReady()) {
                this.log.info(this.ME, "Waiting until browser is ready to send " + this.pushQueue.size() + " messages");
                return;
            }
            if (this.handlesMultipart) {
                if (this.log.TRACE) {
                    this.log.trace(this.ME, "Pushing multipart, pushQueue.size=" + this.pushQueue.size());
                }
                ServletOutputStream servletOutputStream = this.outMulti;
                synchronized (servletOutputStream) {
                    this.outMulti.println("Content-Type: text/html");
                    this.outMulti.println();
                    StringBuffer buf = new StringBuffer(this.head);
                    boolean isMessage = false;
                    int i = 0;
                    while (i < this.pushQueue.size()) {
                        PushDataItem item = (PushDataItem)this.pushQueue.elementAt(i);
                        buf.append(item.data);
                        if (item.type == 1) {
                            isMessage = true;
                        }
                        ++i;
                    }
                    if (isMessage) {
                        this.setBrowserIsReady(false);
                    }
                    buf.append(this.tail);
                    if (this.log.DUMP) {
                        this.log.dump(this.ME, "Sending to callbackFrame:\n" + buf.toString());
                    }
                    this.outMulti.println(buf.toString());
                    this.outMulti.println();
                    this.outMulti.println("--End");
                    this.outMulti.flush();
                    this.log.trace(this.ME, "Push content queue successfully sent as multipart.");
                    this.pushQueue.clear();
                }
            }
            this.log.trace(this.ME, "Pushing plain, pushQueue.size=" + this.pushQueue.size());
            PrintWriter printWriter = this.outPlain;
            synchronized (printWriter) {
                StringBuffer buf = new StringBuffer();
                if (this.firstPush) {
                    buf.append(this.head);
                } else {
                    buf.append("<script language='JavaScript' type='text/javascript'>\n");
                }
                boolean isMessage = false;
                int i = 0;
                while (i < this.pushQueue.size()) {
                    PushDataItem item = (PushDataItem)this.pushQueue.elementAt(i);
                    buf.append(item.data);
                    if (item.type == 1) {
                        isMessage = true;
                    }
                    ++i;
                }
                if (isMessage) {
                    this.setBrowserIsReady(false);
                }
                if (this.log.DUMP) {
                    this.log.dump(this.ME, "Sending plain to callbackFrame:\n" + buf.toString());
                }
                this.outPlain.println(buf.toString());
                this.outPlain.println("</script><p />\n");
                this.outPlain.flush();
                this.log.trace(this.ME, "Push content queue successfully sent.");
                this.pushQueue.clear();
            }
        }
        this.firstPush = false;
    }

    public String update(String sessionId, UpdateKey updateKey, byte[] content, UpdateQos updateQos) {
        try {
            if (this.log.TRACE) {
                this.log.trace(this.ME, "update '" + updateKey.getOid() + "'");
            }
            if (this.callbackInterceptor != null) {
                this.callbackInterceptor.update(sessionId, updateKey, content, updateQos);
            }
            String pushStr = "";
            String codedKey = Global.encode(updateKey.toXml().trim(), "UTF-8");
            String codedContent = Global.encode(new String(content), "UTF-8");
            String codedQos = Global.encode(updateQos.toXml().trim(), "UTF-8");
            pushStr = "if (parent.update != null) parent.update('" + codedKey + "','" + codedContent + "','" + codedQos + "');\n";
            this.push(new PushDataItem(1, pushStr));
        }
        catch (Exception e) {
            e.printStackTrace();
            this.log.error(this.ME, e.toString());
        }
        return "<qos/>";
    }

    public static final String alert(String text) {
        StringBuffer retStr = new StringBuffer();
        retStr.append("<html><body>\n");
        retStr.append("<script language='JavaScript' type='text/javascript'>\n");
        String tmp = StringHelper.replaceAll(text, "'", "\\'");
        retStr.append("alert('" + StringHelper.replaceAll(tmp, "\n", "\\n'+\n'") + "');\n");
        retStr.append("</script>\n");
        retStr.append("</body></html>\n");
        Global.instance().getLog("http").warn("HttpPushHandler", "Sending alert to browser: " + text);
        return retStr.toString();
    }

    public void message(String text) {
        try {
            String codedText = Global.encode(text, "UTF-8");
            this.push(new PushDataItem(1, "if (parent.message != null) parent.message('" + codedText + "');\n"));
        }
        catch (Exception e) {
            this.log.error(this.ME, e.toString());
        }
    }

    public void ping(String state) throws ServletException, IOException {
        if (!this.isBrowserReady()) {
            this.log.warn(this.ME, "Browser seems not to be ready, forcing a push nevertheless (checking browser with ping)");
            this.setBrowserIsReady(true);
        }
        this.push(new PushDataItem(0, "if (parent.ping != null) parent.ping('" + state + "');\n"));
    }

    public void pong() {
        if (this.closed()) {
            return;
        }
        if (this.pingThread != null) {
            this.pingThread.pong();
        }
    }

    private class HttpPingThread
    extends Thread {
        private String ME = "HttpPingThread";
        private HttpPushHandler pushHandler;
        private final long PING_INTERVAL;
        private boolean pingRunning = true;
        private int waitForPong = 0;
        private long counter = 0L;

        public void pong() {
            if (((HttpPushHandler)HttpPushHandler.this).log.TRACE) {
                HttpPushHandler.this.log.trace(this.ME, "Received pong, current waitForPong=" + this.waitForPong + ", counter=" + this.counter);
            }
            this.waitForPong = 0;
        }

        public void stopThread() {
            this.pingRunning = false;
        }

        HttpPingThread(HttpPushHandler pushHandler, long pingInterval, String loginName) {
            this.ME = "HttpPingThread-" + loginName;
            this.pushHandler = pushHandler;
            this.PING_INTERVAL = pingInterval;
            if (((HttpPushHandler)HttpPushHandler.this).log.CALL) {
                HttpPushHandler.this.log.call(this.ME, "Entering constructor HTTP ping interval=" + pingInterval + " millis");
            }
        }

        public void run() {
            if (((HttpPushHandler)HttpPushHandler.this).log.CALL) {
                HttpPushHandler.this.log.call(this.ME, "Pinging browser ...");
            }
            while (this.pingRunning) {
                try {
                    Thread.currentThread();
                    Thread.sleep(this.PING_INTERVAL);
                    if (!this.pingRunning) break;
                    ++this.counter;
                }
                catch (InterruptedException i) {
                    // empty catch block
                }
                try {
                    if (this.waitForPong > 2) {
                        Global.instance().getLog("http").warn(this.ME, "Browser seems to have disappeared, no response for my ping=" + this.counter + ", missing " + this.waitForPong + " responses. Closing connection.");
                        this.pushHandler.cleanup();
                        this.stopThread();
                        continue;
                    }
                    String text = "refresh-" + this.counter;
                    if (((HttpPushHandler)HttpPushHandler.this).log.TRACE) {
                        HttpPushHandler.this.log.trace(this.ME, "Sending ping '" + text + "'  to browser ...");
                    }
                    this.pushHandler.ping(text);
                    ++this.waitForPong;
                }
                catch (Exception e) {
                    HttpPushHandler.this.log.warn(this.ME, "You tried to ping=" + this.counter + " a browser who is not interested. Close HttpPushHandler.");
                    this.pushHandler.cleanup();
                    this.stopThread();
                }
            }
            if (((HttpPushHandler)HttpPushHandler.this).log.TRACE) {
                HttpPushHandler.this.log.trace(this.ME, "Ping thread dies ...");
            }
        }
    }
}

