/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.protocol.http.appletproxy;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.codec.binary.Base64;
import org.jutils.log.LogChannel;
import org.jutils.log.LogableDevice;
import org.jutils.runtime.Memory;
import org.xmlBlaster.client.I_XmlBlasterAccess;
import org.xmlBlaster.client.key.EraseKey;
import org.xmlBlaster.client.key.SubscribeKey;
import org.xmlBlaster.client.key.UnSubscribeKey;
import org.xmlBlaster.client.protocol.http.common.MsgHolder;
import org.xmlBlaster.client.protocol.http.common.ObjectInputStreamMicro;
import org.xmlBlaster.client.protocol.http.common.ObjectOutputStreamMicro;
import org.xmlBlaster.client.qos.ConnectQos;
import org.xmlBlaster.client.script.XmlScriptInterpreter;
import org.xmlBlaster.protocol.http.appletproxy.PushHandler;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.MsgUnit;
import org.xmlBlaster.util.Timeout;
import org.xmlBlaster.util.XmlBlasterException;
import org.xmlBlaster.util.def.ErrorCode;
import org.xmlBlaster.util.key.MsgKeyData;
import org.xmlBlaster.util.qos.MsgQosData;

public class AppletServlet
extends HttpServlet
implements LogableDevice {
    private Global initialGlobal;
    private Timeout timeout;
    public static final String ENCODING = "UTF-8";

    public void init(ServletConfig conf) throws ServletException {
        super.init(conf);
        Enumeration enumer = conf.getInitParameterNames();
        Properties props = new Properties();
        while (enumer.hasMoreElements()) {
            String name = (String)enumer.nextElement();
            if (name == null || name.length() <= 0) continue;
            props.setProperty(name, conf.getInitParameter(name));
        }
        this.initialGlobal = new Global();
        if (this.initialGlobal.init(props) != 0) {
            System.out.println("AppletServlet: Global initialization problem: " + this.initialGlobal.getErrorText());
        }
        this.initialGlobal.getLog("servlet").info(this.getClass().getName(), "Initialize ...");
        AppletServlet.initSystemProperties(conf);
        this.timeout = new Timeout("xmlBlaster.appletPinger");
    }

    protected void connect(String ME, LogChannel log, HttpSession session, String qos, HttpServletRequest req, HttpServletResponse res) throws XmlBlasterException, IOException, ServletException {
        ConnectQos connectQos;
        if (qos == null || qos.length() < 1) {
            throw new XmlBlasterException(this.initialGlobal, ErrorCode.USER_CONFIGURATION, ME, "Missing connect QoS. Pass xmlBlaster.connectQos='<qos> ... </qos>' with your URL in your POST in a hidden form field or in your cookie.");
        }
        Global glob = this.initialGlobal.getClone(null);
        boolean warnAuth = false;
        if (qos.toLowerCase().indexOf("securityservice") >= 0) {
            connectQos = new ConnectQos(glob, glob.getConnectQosFactory().readObject(qos));
        } else {
            connectQos = new ConnectQos(glob);
            warnAuth = true;
        }
        ME = "AppletServlet-" + req.getRemoteAddr() + "-" + connectQos.getSessionName().getLoginName() + "-" + session.getId();
        if (warnAuth) {
            log.warn(ME, "Login action, applet has not supplied connect QoS authentication information - we login with the servlets default authentication settings");
        } else {
            log.info(ME, "Login action with applet supplied connect QoS authentication information");
        }
        I_XmlBlasterAccess xmlBlasterAccess = glob.getXmlBlasterAccess();
        PushHandler pushHandler = new PushHandler(req, res, session.getId(), connectQos.getSessionName().getRelativeName(), xmlBlasterAccess, this.timeout);
        xmlBlasterAccess.connect(connectQos, pushHandler);
        pushHandler.startPing();
        session.setAttribute("PushHandler", (Object)pushHandler);
        log.info(ME, "Waiting forever, permanent HTTP connection from " + req.getRemoteHost() + "/" + req.getRemoteAddr() + ", sessionName=" + connectQos.getSessionName().getRelativeName() + " sessionId=" + session.getId() + "', protocol='" + req.getProtocol() + "', agent='" + req.getHeader("User-Agent") + "', referer='" + req.getHeader("Referer") + "'.");
        if (log.TRACE) {
            log.trace(ME, "user='" + req.getRemoteUser() + "', serverPort='" + req.getServerPort() + "', query='" + req.getQueryString() + "', pathInfo='" + req.getPathInfo() + "', pathTranslated='" + req.getPathTranslated() + "', servletPath='" + req.getServletPath() + "', documentRoot='" + this.getServletConfig().getServletContext().getRealPath("/") + "', accept='" + req.getHeader("Accept") + "', referer='" + req.getHeader("Referer") + "', authorization='" + req.getHeader("Authorization") + "'.");
        }
        pushHandler.ping("loginSucceeded");
        while (!pushHandler.isClosed()) {
            try {
                Thread.sleep(10000L);
            }
            catch (InterruptedException i) {
                log.error(ME, "Error in Thread handling, don't know what to do: " + i.toString());
                pushHandler.cleanup();
                break;
            }
        }
        pushHandler = null;
        log.info(ME, "Persistent HTTP connection lost, leaving doGet() ....");
    }

    public void doGetFake(HttpServletRequest req, HttpServletResponse res, String actionType, MsgHolder msgHolder) throws ServletException, IOException {
        block19: {
            res.setContentType("text/plain");
            String errorText = "";
            String ME = this.getClass().getName() + "-" + req.getRemoteAddr();
            LogChannel log = this.initialGlobal.getLog("servlet");
            if (log.CALL) {
                log.call(this.getClass().getName(), "Entering doGet() ... " + Memory.getStatistic());
            }
            if (actionType.equalsIgnoreCase("NONE")) {
                String str = "Please call servlet with some ActionType";
                log.error(ME, str);
                XmlBlasterException x = new XmlBlasterException(this.initialGlobal, ErrorCode.USER_CONFIGURATION, ME, str);
                this.writeResponse(res, "exception", x.getMessage());
                return;
            }
            HttpSession session = req.getSession(true);
            if (actionType.equals("connect")) {
                boolean invalidate = AppletServlet.getParameter(req, "xmlBlaster.invalidate", true);
                if (invalidate) {
                    log.info(ME, "Entering servlet doGet(), forcing a new sessionId");
                    session.invalidate();
                }
                session = req.getSession(true);
            }
            String sessionId = session.getId();
            ME = ME + "-" + sessionId;
            if (log.TRACE) {
                log.trace(ME, "Entering servlet doGet() ...");
            }
            if (sessionId == null) {
                String str = "Sorry, your sessionId is invalid";
                XmlBlasterException x = new XmlBlasterException(this.initialGlobal, ErrorCode.USER_CONFIGURATION, ME, str);
                this.writeResponse(res, "exception", str);
                return;
            }
            try {
                if (actionType.equals("connect")) {
                    String qos = AppletServlet.getParameter(req, "xmlBlaster.connectQos", null);
                    if (msgHolder != null) {
                        qos = msgHolder.getQos();
                    }
                    this.connect(ME, log, session, qos, req, res);
                    break block19;
                }
                if (actionType.equals("dummyToCreateASessionId")) {
                    log.info(ME, "doGet: dummyToCreateASessionId");
                    this.writeResponse(res, "dummyToCreateASessionId", "OK-" + System.currentTimeMillis());
                    return;
                }
                if (actionType.equals("pong")) {
                    try {
                        PushHandler pushHandler = this.getPushHandler(req);
                        pushHandler.pong();
                        if (log.TRACE) {
                            log.trace(ME, "Received pong");
                        }
                        this.writeResponse(res, "pong", "OK-" + System.currentTimeMillis());
                        return;
                    }
                    catch (XmlBlasterException e) {
                        log.error(ME, "Caught XmlBlaster Exception for actionType '" + actionType + "': " + e.getMessage());
                        return;
                    }
                }
                if (actionType.equals("disconnect")) {
                    log.info(ME, "Logout arrived ...");
                    try {
                        PushHandler pc = this.getPushHandler(req);
                        pc.cleanup();
                    }
                    catch (XmlBlasterException e) {
                        log.error(ME, e.toString());
                    }
                    this.writeResponse(res, "disconnect", "<qos/>");
                    break block19;
                }
                String text = "Unknown ActionType '" + actionType + "', request for permanent http connection ignored";
                throw new XmlBlasterException(this.initialGlobal, ErrorCode.USER_CONFIGURATION, ME, text);
            }
            catch (XmlBlasterException e) {
                log.warn(ME, "Caught XmlBlaster Exception: " + e.getMessage());
                this.writeResponse(res, "exception", e.getMessage());
            }
            catch (Exception e) {
                log.error(ME, "Caught Exception: " + e.toString());
                e.printStackTrace();
                this.writeResponse(res, "exception", e.toString());
            }
        }
    }

    private final String decode(String in, String encoding) {
        return Global.decode(in, encoding);
    }

    private byte[] readBodyContent(HttpServletRequest req) {
        try {
            String tmp;
            int length = req.getContentLength();
            if (length < 0 && (tmp = req.getHeader("Data-Length")) != null) {
                length = Integer.parseInt(tmp);
            }
            byte[] ret = new byte[length];
            DataInputStream in = new DataInputStream((InputStream)req.getInputStream());
            in.readFully(ret);
            return ret;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return new byte[0];
        }
    }

    private MsgHolder readBinaryProtocol(HttpServletRequest req, HttpServletResponse res) throws IOException {
        try {
            byte[] contentAsBytes = this.readBodyContent(req);
            String tmp = req.getHeader("BinaryProtocol");
            if (tmp == null || tmp.equalsIgnoreCase("false")) {
                return null;
            }
            String actionType = req.getHeader("ActionType");
            ServletInputStream in = req.getInputStream();
            int length = req.getContentLength();
            MsgHolder msg = ObjectInputStreamMicro.readMessage(contentAsBytes);
            return msg;
        }
        catch (IOException ex) {
            ex.printStackTrace();
            throw ex;
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            throw new IOException(ex.getMessage());
        }
    }

    protected MsgHolder extractMessage(String ME, LogChannel log, HttpServletRequest req, MsgHolder binaryMsg) {
        String contentStr;
        if (binaryMsg != null) {
            return binaryMsg;
        }
        String oid = AppletServlet.getParameter(req, "key.oid", null);
        if (log.TRACE) {
            log.trace(ME, "encoded oid=" + oid);
        }
        if (oid != null) {
            oid = this.decode(oid, ENCODING);
        }
        String key = AppletServlet.getParameter(req, "key", null);
        if (log.TRACE) {
            log.trace(ME, "encoded key=" + key);
        }
        if (key != null) {
            key = this.decode(key, ENCODING);
            if (log.DUMP) {
                log.dump(ME, "key=\n'" + key + "'");
            }
        }
        byte[] content = (contentStr = AppletServlet.getParameter(req, "content", null)) != null ? this.decode(contentStr, ENCODING).getBytes() : new byte[]{};
        if (log.DUMP) {
            log.dump(ME, "content=\n'" + new String(content) + "'");
        }
        String qos = AppletServlet.getParameter(req, "qos", null);
        if (log.TRACE) {
            log.trace(ME, "encoded qos=" + qos);
        }
        qos = qos != null ? this.decode(qos, ENCODING) : "";
        if (log.DUMP) {
            log.dump(ME, "qos=\n'" + qos + "'");
        }
        String xmlRequest = AppletServlet.getParameter(req, "xmlRequest", null);
        if (log.TRACE) {
            log.trace(ME, "encoded xmlRequest=" + xmlRequest);
        }
        if (xmlRequest != null) {
            xmlRequest = this.decode(xmlRequest, ENCODING);
            if (log.DUMP) {
                log.dump(ME, "xmlRequest=\n'" + xmlRequest + "'");
            }
        }
        return new MsgHolder(oid, key, qos, content);
    }

    public void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        this.doPost(req, res);
    }

    /*
     * Unable to fully structure code
     */
    public void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        binaryMsg = this.readBinaryProtocol(req, res);
        actionType = req.getHeader("ActionType");
        if (actionType == null) {
            actionType = AppletServlet.getParameter(req, "ActionType", "NONE");
        }
        System.err.println("Received actionType=" + actionType);
        if (actionType.equalsIgnoreCase("connect") || actionType.equalsIgnoreCase("disconnect") || actionType.equalsIgnoreCase("pong") || actionType.equalsIgnoreCase("dummyToCreateASessionId")) {
            this.doGetFake(req, res, actionType, binaryMsg);
            return;
        }
        res.setContentType("text/plain");
        session = req.getSession(false);
        sessionId = req.getRequestedSessionId();
        log = this.initialGlobal.getLog("servlet");
        ME = "AppletServlet-" + req.getRemoteAddr() + "-" + sessionId;
        if (log.TRACE) {
            log.trace(ME, "Entering servlet doPost() ...");
        }
        glob = null;
        xmlBlaster = null;
        pushHandler = null;
        returnObject = null;
        try {
            pushHandler = this.getPushHandler(req);
            xmlBlaster = pushHandler.getXmlBlasterAccess();
            glob = xmlBlaster.getGlobal();
        }
        catch (XmlBlasterException e) {
            log.warn(ME, "Caught XmlBlaster Exception: " + e.getMessage());
            this.writeResponse(res, "exception", e.getMessage());
            return;
        }
        try {
            msg = this.extractMessage(ME, log, req, binaryMsg);
            oid = msg.getOid();
            key = msg.getKey();
            qos = msg.getQos();
            xmlRequest = msg.getKey();
            content = msg.getContent();
            if (!actionType.equals("subscribe")) ** GOTO lbl55
            if (log.TRACE) {
                log.trace(ME, "subscribe arrived ... oid=" + oid + ", key=" + key + ", qos=" + qos);
            }
            if (oid != null) {
                xmlKey = new SubscribeKey(glob, oid);
                ret = xmlBlaster.subscribe(xmlKey.toXml(), qos);
                returnObject = ret.getData().toJXPath();
                if (log.TRACE) {
                    log.trace(ME, "Subscribed to simple key.oid=" + oid + ": " + ret.getSubscriptionId());
                }
            } else if (key != null) {
                ret = xmlBlaster.subscribe(key, qos);
                returnObject = ret.getData().toJXPath();
                if (log.TRACE) {
                    log.trace(ME, "Subscribed to " + key + ": SubscriptionId=" + ret.getSubscriptionId() + " qos=" + qos + " returnObject=" + returnObject.getClass().getName());
                }
            } else {
                str = "Please call servlet with some 'key.oid=...' or 'key=<key ...' when subscribing";
                log.warn(ME, str);
                throw new XmlBlasterException(this.initialGlobal, ErrorCode.USER_CONFIGURATION, ME, str);
lbl55:
                // 1 sources

                if (actionType.equals("unSubscribe")) {
                    if (log.TRACE) {
                        log.trace(ME, "unSubscribe arrived ...");
                    }
                    if (oid != null) {
                        xmlKey = new UnSubscribeKey(glob, oid);
                        ret = xmlBlaster.unSubscribe(xmlKey.toXml(), qos);
                    } else if (key != null) {
                        ret = xmlBlaster.unSubscribe(key, qos);
                    } else {
                        str = "Please call servlet with some 'key.oid=...' or 'key=<key ...' when unsubscribing";
                        log.warn(ME, str);
                        throw new XmlBlasterException(this.initialGlobal, ErrorCode.USER_CONFIGURATION, ME, str);
                    }
                    arr = new Vector<Hashtable>();
                    ii = 0;
                    while (ii < ret.length) {
                        arr.add(ret[ii].getData().toJXPath());
                        if (log.TRACE) {
                            log.trace(ME, "UnSubscribed " + ret[ii].getSubscriptionId());
                        }
                        ++ii;
                    }
                    returnObject = arr.toArray(new Hashtable[arr.size()]);
                } else if (actionType.equals("get")) {
                    if (log.TRACE) {
                        log.trace(ME, "get arrived ...");
                    }
                    msgUnitArr = xmlBlaster.get(key, qos);
                    list = new Vector<Object>(msgUnitArr.length * 3);
                    i = 0;
                    while (i < msgUnitArr.length) {
                        list.add(((MsgQosData)msgUnitArr[i].getQosData()).toJXPath());
                        list.add(((MsgKeyData)msgUnitArr[i].getKeyData()).toJXPath());
                        list.add(msgUnitArr[i].getContent());
                        ++i;
                    }
                    returnObject = list;
                } else if (actionType.equals("publish")) {
                    if (log.TRACE) {
                        log.trace(ME, "publish arrived ...");
                    }
                    if (key == null) {
                        str = "Please call servlet with some key when publishing";
                        log.warn(ME, str);
                        x = new XmlBlasterException(this.initialGlobal, ErrorCode.USER_ILLEGALARGUMENT, ME, str);
                        this.writeResponse(res, "exception", x.getMessage());
                        return;
                    }
                    if (log.TRACE) {
                        log.trace(ME, "Publishing '" + key + "'");
                    }
                    msgUnit = new MsgUnit(glob, key, content, qos);
                    try {
                        prq = xmlBlaster.publish(msgUnit);
                        returnObject = prq.getData().toJXPath();
                        if (log.TRACE) {
                            log.trace(ME, "Success: Publishing done, returned oid=" + prq.getKeyOid());
                        }
                    }
                    catch (XmlBlasterException e) {
                        log.warn(ME, "XmlBlasterException: " + e.getMessage());
                    }
                } else if (actionType.equals("erase")) {
                    if (log.TRACE) {
                        log.trace(ME, "erase arrived ...");
                    }
                    if (oid != null) {
                        ek = new EraseKey(glob, oid);
                        ret = xmlBlaster.erase(ek.toXml(), qos);
                    } else if (key != null) {
                        ret = xmlBlaster.erase(key, qos);
                    } else {
                        str = "Please call servlet with some 'key.oid=...' or 'key=<key ...' when subscribing";
                        log.warn(ME, str);
                        throw new XmlBlasterException(this.initialGlobal, ErrorCode.USER_CONFIGURATION, ME, str);
                    }
                    arr = new Vector<Hashtable>();
                    ii = 0;
                    while (ii < ret.length) {
                        arr.add(ret[ii].getData().toJXPath());
                        if (log.TRACE) {
                            log.trace(ME, "Erased " + ret[ii].getKeyOid());
                        }
                        ++ii;
                    }
                    returnObject = arr.toArray(new Hashtable[arr.size()]);
                } else if (actionType.equals("xmlScript")) {
                    reader = new StringReader(xmlRequest);
                    outStream = new ByteArrayOutputStream();
                    interpreter = new XmlScriptInterpreter(glob, xmlBlaster, pushHandler, null, outStream);
                    interpreter.parse(reader);
                    returnObject = outStream.toString();
                } else {
                    str = "Unknown or missing 'ActionType=" + actionType + "' please choose 'subscribe' 'unSubscribe' 'erase' etc.";
                    log.warn(ME, str);
                    throw new XmlBlasterException(this.initialGlobal, ErrorCode.USER_CONFIGURATION, ME, str);
                }
            }
            this.writeResponse(res, actionType, returnObject);
        }
        catch (XmlBlasterException e) {
            log.warn(ME, "Caught XmlBlaster Exception: " + e.getMessage());
            this.writeResponse(res, "exception", e.getMessage());
        }
        catch (Exception e) {
            log.error(ME, "Exception: " + e.toString());
            this.writeResponse(res, "exception", XmlBlasterException.convert(this.initialGlobal, ME, "", e).getMessage());
        }
    }

    public static final void initSystemProperties(ServletConfig conf) {
        String ME = "AppletServlet";
        Properties props = System.getProperties();
        LogChannel log = Global.instance().getLog("http");
        if (conf.getInitParameter("org.omg.CORBA.ORBClass") != null) {
            ((Hashtable)props).put("org.omg.CORBA.ORBClass", conf.getInitParameter("org.omg.CORBA.ORBClass"));
            log.info(ME, "Using servlet system parameter org.omg.CORBA.ORBClass=" + ((Hashtable)props).get("org.omg.CORBA.ORBClass"));
        }
        if (conf.getInitParameter("org.omg.CORBA.ORBSingletonClass") != null) {
            ((Hashtable)props).put("org.omg.CORBA.ORBSingletonClass", conf.getInitParameter("org.omg.CORBA.ORBSingletonClass"));
            log.info(ME, "Using servlet system parameter org.omg.CORBA.ORBSingletonClass=" + ((Hashtable)props).get("org.omg.CORBA.ORBSingletonClass"));
        }
        if (conf.getInitParameter("org.xml.sax.parser") != null) {
            ((Hashtable)props).put("org.xml.sax.parser", conf.getInitParameter("org.xml.sax.parser"));
            if (log.TRACE) {
                log.trace(ME, "Found system parameter org.xml.sax.parser=" + conf.getInitParameter("org.xml.sax.parser"));
            }
        } else {
            ((Hashtable)props).put("org.xml.sax.parser", "org.apache.crimson.parser.Parser2");
        }
        log.info(ME, "Using system parameter org.xml.sax.parser=" + ((Hashtable)props).get("org.xml.sax.parser"));
        if (((Hashtable)props).size() > 0) {
            System.setProperties(props);
        }
    }

    private void writeResponse(HttpServletResponse res, String actionType, String text) throws IOException {
        this.writeResponse(res, actionType, text == null ? (Object)null : text);
    }

    private void writeResponse(HttpServletResponse res, String actionType, Object obj) throws IOException {
        ByteArrayOutputStream dump = new ByteArrayOutputStream(1024);
        ObjectOutputStreamMicro objectOut = new ObjectOutputStreamMicro(dump);
        objectOut.writeObject(actionType);
        if (obj != null) {
            objectOut.writeObject(obj);
        }
        boolean isChunked = false;
        byte[] base64 = Base64.encodeBase64((byte[])dump.toByteArray(), (boolean)isChunked);
        PrintWriter out = res.getWriter();
        out.println(new String(base64));
        out.flush();
    }

    private PushHandler getPushHandler(HttpServletRequest req) throws XmlBlasterException {
        HttpSession session = req.getSession(false);
        if (session == null) {
            throw new XmlBlasterException(this.initialGlobal, ErrorCode.USER_SECURITY_AUTHENTICATION_ACCESSDENIED, "No servlet session available");
        }
        PushHandler pushHandler = (PushHandler)session.getAttribute("PushHandler");
        if (pushHandler == null) {
            throw new XmlBlasterException(this.initialGlobal, ErrorCode.USER_SECURITY_AUTHENTICATION_ACCESSDENIED, "The PushHandler is missing in the session scope");
        }
        return pushHandler;
    }

    public void log(int level, String source, String str) {
        this.getServletContext().log(str);
    }

    public static final String getParameter(HttpServletRequest req, String name, String defaultVal) {
        if (name == null) {
            return defaultVal;
        }
        String obj = req.getParameter(name);
        if (obj != null) {
            return obj;
        }
        return defaultVal;
    }

    public static final String getAttribute(HttpServletRequest req, String name, String defaultVal) {
        if (name == null) {
            return defaultVal;
        }
        Object obj = req.getAttribute(name);
        if (obj != null) {
            return (String)obj;
        }
        HttpSession session = req.getSession(false);
        if (session == null) {
            return defaultVal;
        }
        obj = session.getAttribute(name);
        if (obj != null) {
            return (String)obj;
        }
        return defaultVal;
    }

    public static final boolean getParameter(HttpServletRequest req, String name, boolean defaultVal) {
        Boolean b = new Boolean(AppletServlet.getParameter(req, name, new Boolean(defaultVal).toString()));
        return b;
    }
}

