/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.protocol.http.appletproxy;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Hashtable;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.codec.binary.Base64;
import org.jutils.log.LogChannel;
import org.xmlBlaster.client.I_Callback;
import org.xmlBlaster.client.I_XmlBlasterAccess;
import org.xmlBlaster.client.key.UpdateKey;
import org.xmlBlaster.client.protocol.http.common.ObjectOutputStreamMicro;
import org.xmlBlaster.client.qos.UpdateQos;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.I_Timeout;
import org.xmlBlaster.util.Timeout;
import org.xmlBlaster.util.Timestamp;
import org.xmlBlaster.util.XmlBlasterException;
import org.xmlBlaster.util.def.ErrorCode;

public class PushHandler
implements I_Callback,
I_Timeout {
    private String ME = "PushHandler";
    private Global glob;
    private LogChannel log = Global.instance().getLog("servlet");
    private long pingInterval = 10000L;
    private final Timeout timeout;
    private Timestamp pingTimeoutHandle;
    private long pingCounter;
    private long missingPongs;
    private I_XmlBlasterAccess xmlBlasterAccess;
    private I_Callback callbackInterceptor;
    private HttpServletResponse res;
    private String sessionId;
    private boolean closed = false;
    private ServletOutputStream outMulti;
    boolean isChunked = false;

    public PushHandler(HttpServletRequest req, HttpServletResponse res, String sessionId, String loginName, I_XmlBlasterAccess xmlBlasterAccess, Timeout timeout) throws ServletException, IOException {
        this.res = res;
        this.sessionId = sessionId;
        this.xmlBlasterAccess = xmlBlasterAccess;
        this.glob = this.xmlBlasterAccess.getGlobal();
        this.timeout = timeout;
        String appletId = req.getRemoteAddr() + "-" + loginName + "-" + sessionId;
        this.ME = "PushHandler-" + appletId;
        this.outMulti = this.res.getOutputStream();
        this.res.setContentType("multipart/x-mixed-replace;boundary=End");
        this.outMulti.println();
        this.outMulti.println("--End");
    }

    public void timeout(Object userData) {
        if (this.log.CALL) {
            this.log.call(this.ME, "Pinging applet ...");
        }
        ++this.pingCounter;
        try {
            if (this.missingPongs > 2L) {
                this.log.warn(this.ME, "Applet seems to have disappeared, no response for my ping=" + this.pingCounter + ", missing " + this.missingPongs + " responses. Closing connection.");
                this.cleanup();
            } else {
                String text = "refresh-" + this.pingCounter;
                if (this.log.TRACE) {
                    this.log.trace(this.ME, "Sending ping '" + text + "'  to applet, missingPongs=" + this.missingPongs + " ...");
                }
                this.ping(text);
                ++this.missingPongs;
            }
        }
        catch (Exception e) {
            this.log.warn(this.ME, "We tried to ping=" + this.pingCounter + " an applet who is not interested. Close PushHandler.");
            this.cleanup();
        }
        PushHandler pushHandler = this;
        synchronized (pushHandler) {
            if (this.pingInterval > 0L) {
                this.pingTimeoutHandle = this.timeout.addTimeoutListener(this, this.pingInterval, userData);
            }
        }
    }

    public void startPing() throws XmlBlasterException {
        this.log.trace(this.ME, "startPing ...");
        this.setPingInterval(this.pingInterval);
        this.ping("refresh");
    }

    public void stopPing() throws XmlBlasterException {
        this.log.trace(this.ME, "stopPing ...");
        this.setPingInterval(0L);
    }

    public boolean isClosed() {
        return this.closed;
    }

    public synchronized void setPingInterval(long pingInterval) throws XmlBlasterException {
        this.pingInterval = pingInterval;
        if (this.pingInterval < 1L) {
            if (this.pingTimeoutHandle != null) {
                this.timeout.removeTimeoutListener(this.pingTimeoutHandle);
            }
            return;
        }
        this.pingTimeoutHandle = this.timeout.addOrRefreshTimeoutListener(this, this.pingInterval, null, this.pingTimeoutHandle);
    }

    public I_XmlBlasterAccess getXmlBlasterAccess() {
        return this.xmlBlasterAccess;
    }

    public void shutdownAppletConnection() {
        try {
            this.closed = true;
            this.stopPing();
            if (this.outMulti != null) {
                this.outMulti.close();
            }
            this.log.info(this.ME, "Closed push connection to applet");
        }
        catch (Exception e) {
            e.printStackTrace();
            this.log.error(this.ME, "Error occurred while de-initializing the push handler :" + e.toString());
        }
    }

    public void setProxyInterceptor(I_Callback interceptor) {
        this.callbackInterceptor = interceptor;
    }

    public void cleanup() {
        if (this.log.CALL) {
            this.log.call(this.ME, "Entering cleanup() ...");
        }
        if (this.xmlBlasterAccess != null) {
            try {
                this.xmlBlasterAccess.disconnect(null);
                this.log.info(this.ME, "XmlBlaster connection removed");
                this.xmlBlasterAccess = null;
            }
            catch (Exception e) {
                e.printStackTrace();
                this.log.error(this.ME, "Can't destroy http connection: " + e.toString());
            }
        }
        this.callbackInterceptor = null;
        try {
            this.shutdownAppletConnection();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.log.error(this.ME, "Can't destroy http connection: " + e.toString());
        }
    }

    private void pushToApplet(byte[] chunk) throws IOException {
        if (this.log.TRACE) {
            this.log.trace(this.ME, "Pushing multipart for applet, size=" + chunk.length);
        }
        if (this.log.TRACE) {
            this.log.trace(this.ME, "Pushing multipart for applet, content='" + new String(chunk) + "'");
        }
        byte[] base64 = Base64.encodeBase64((byte[])chunk, (boolean)this.isChunked);
        if (this.log.TRACE) {
            this.log.trace(this.ME, "Pushing multipart for applet, content (encoded)='" + new String(base64) + "'");
        }
        ServletOutputStream servletOutputStream = this.outMulti;
        synchronized (servletOutputStream) {
            this.outMulti.println(new String(base64));
            this.outMulti.println("--End");
            this.outMulti.flush();
            this.log.trace(this.ME, "Pushed data successfully as multipart to applet.");
        }
    }

    public String update(String sessionId, UpdateKey updateKey, byte[] content, UpdateQos updateQos) {
        try {
            if (this.log.TRACE) {
                this.log.trace(this.ME, "update '" + updateKey.getOid() + "'");
            }
            if (this.callbackInterceptor != null) {
                this.callbackInterceptor.update(sessionId, updateKey, content, updateQos);
            }
            ByteArrayOutputStream dump = new ByteArrayOutputStream(1024);
            ObjectOutputStreamMicro out = new ObjectOutputStreamMicro(dump);
            out.writeObject("update".toString());
            out.writeObject(sessionId);
            Hashtable qosMap = updateQos.getData().toJXPath();
            out.writeObject(qosMap);
            Hashtable keyMap = updateKey.getData().toJXPath();
            out.writeObject(keyMap);
            out.writeObject(new String(Base64.encodeBase64((byte[])content, (boolean)this.isChunked)));
            this.pushToApplet(dump.toByteArray());
            if (this.log.TRACE) {
                this.log.trace(this.ME, "Sent update message '" + updateKey.getOid() + "' content='" + new String(content) + "' to applet");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.log.error(this.ME, e.toString());
        }
        return "<qos/>";
    }

    public void ping(String state) throws XmlBlasterException {
        try {
            ByteArrayOutputStream dump = new ByteArrayOutputStream(1024);
            ObjectOutputStreamMicro out = new ObjectOutputStreamMicro(dump);
            out.writeObject("ping");
            out.writeObject("<qos id='" + state + "'/>");
            this.pushToApplet(dump.toByteArray());
            if (this.log.TRACE) {
                this.log.trace(this.ME, "Sent ping '" + state + "' to applet");
            }
        }
        catch (IOException e) {
            throw XmlBlasterException.convert(this.glob, ErrorCode.RESOURCE_UNAVAILABLE, this.ME, "ping(" + state + ") failed", e);
        }
    }

    public void pong() {
        this.missingPongs = 0L;
    }
}

