/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.protocol.jdbc;

import org.jutils.log.LogChannel;
import org.xmlBlaster.protocol.I_CallbackDriver;
import org.xmlBlaster.protocol.jdbc.JdbcDriver;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.MsgUnit;
import org.xmlBlaster.util.MsgUnitRaw;
import org.xmlBlaster.util.XmlBlasterException;
import org.xmlBlaster.util.def.ErrorCode;
import org.xmlBlaster.util.plugin.PluginInfo;
import org.xmlBlaster.util.qos.MsgQosData;
import org.xmlBlaster.util.qos.address.CallbackAddress;

public class CallbackJdbcDriver
implements I_CallbackDriver {
    private String ME = "CallbackJdbcDriver";
    private Global glob = null;
    private LogChannel log = null;
    private CallbackAddress callbackAddress = null;

    public String getName() {
        return this.ME;
    }

    public String getProtocolId() {
        return "JDBC";
    }

    public String getType() {
        return this.getProtocolId();
    }

    public String getVersion() {
        return "1.0";
    }

    public void init(Global glob, PluginInfo pluginInfo) {
    }

    public String getRawAddress() {
        if (this.log.TRACE) {
            this.log.trace(this.ME + ".getRawAddress()", "No external access address available");
        }
        return null;
    }

    public void init(Global glob, CallbackAddress callbackAddress) throws XmlBlasterException {
        this.glob = glob;
        this.log = glob.getLog("jdbc");
        if (this.log.CALL) {
            this.log.call(this.ME, "Entering init");
        }
        this.callbackAddress = callbackAddress;
    }

    public final String[] sendUpdate(MsgUnitRaw[] msgArr) throws XmlBlasterException {
        try {
            if (msgArr == null || msgArr.length < 1) {
                throw new XmlBlasterException(this.glob, ErrorCode.INTERNAL_ILLEGALARGUMENT, this.ME, "Illegal sendUpdate() argument");
            }
            String id = "JdbcDriver-" + this.glob.getId();
            JdbcDriver driver = (JdbcDriver)this.glob.getObjectEntry(id);
            if (driver == null) {
                this.log.error(this.ME, "Can't find JdbcDriver instance");
                Thread.currentThread();
                Thread.dumpStack();
                throw new XmlBlasterException(this.glob, ErrorCode.INTERNAL_UNKNOWN, this.ME, "Internal error, can't find JdbcDriver instance '" + id + "'");
            }
            int ii = 0;
            while (ii < msgArr.length) {
                MsgQosData msgQosData = (MsgQosData)((MsgUnit)msgArr[ii].getMsgUnit()).getQosData();
                driver.update(msgQosData.getSender().getAbsoluteName(), msgArr[ii].getContent());
                ++ii;
            }
            String[] ret = new String[msgArr.length];
            int ii2 = 0;
            while (ii2 < ret.length) {
                ret[ii2] = "<qos><state id='OK'/></qos>";
                ++ii2;
            }
            return ret;
        }
        catch (XmlBlasterException xmlBlasterException) {
            if (xmlBlasterException.isUser()) {
                throw xmlBlasterException;
            }
            throw new XmlBlasterException(this.glob, ErrorCode.USER_UPDATE_ERROR, this.ME, "JDBC processing problem", xmlBlasterException);
        }
        catch (Throwable throwable) {
            throw new XmlBlasterException(this.glob, ErrorCode.COMMUNICATION_NOCONNECTION, this.ME, "Internal JDBC processing problem", throwable);
        }
    }

    public void sendUpdateOneway(MsgUnitRaw[] msgArr) throws XmlBlasterException {
        if (msgArr == null || msgArr.length < 1) {
            throw new XmlBlasterException(this.glob, ErrorCode.INTERNAL_ILLEGALARGUMENT, this.ME, "Illegal sendUpdateOneway() argument");
        }
        String id = "JdbcDriver-" + this.glob.getId();
        JdbcDriver driver = (JdbcDriver)this.glob.getObjectEntry(id);
        if (driver == null) {
            this.log.error(this.ME, "Can't find JdbcDriver instance");
            Thread.currentThread();
            Thread.dumpStack();
            throw new XmlBlasterException(this.glob, ErrorCode.INTERNAL_UNKNOWN, this.ME, "Internal error, can't find JdbcDriver instance '" + id + "'");
        }
        int ii = 0;
        while (ii < msgArr.length) {
            try {
                MsgQosData msgQosData = (MsgQosData)((MsgUnit)msgArr[ii].getMsgUnit()).getQosData();
                driver.update(msgQosData.getSender().getAbsoluteName(), msgArr[ii].getContent());
            }
            catch (Throwable e) {
                throw new XmlBlasterException(this.glob, ErrorCode.COMMUNICATION_NOCONNECTION, this.ME, "JDBC Callback of " + ii + "th message to client [" + this.callbackAddress.getSecretSessionId() + "] failed.", e);
            }
            ++ii;
        }
    }

    public final String ping(String qos) throws XmlBlasterException {
        return "<qos><state id='OK'/></qos>";
    }

    public void shutdown() {
    }

    public boolean isAlive() {
        return true;
    }
}

