/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.protocol.jdbc;

import org.apache.crimson.tree.TreeWalker;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class ConnectionDescriptor {
    private String url = "";
    private String username = "";
    private String password = "";
    private String interaction = "query";
    private String command = "";
    private String connectionkey = "";
    private long connectionlifespan = 300000L;
    private boolean confirmation = true;
    private String documentrootnode = "dbadapterresults";
    private String rowrootnode = "row";
    private int rowlimit = -1;
    private Document document = null;

    public ConnectionDescriptor(Document document) {
        this.document = document;
        this.parse();
    }

    private void parse() {
        Node firstNode = this.document.getFirstChild();
        TreeWalker tw = new TreeWalker(firstNode);
        Node curNode = null;
        while ((curNode = tw.getNext()) != null) {
            if (curNode.getNodeType() == 1 && curNode.getNodeName().equalsIgnoreCase("database:url")) {
                if (curNode.getFirstChild().getNodeType() != 3) continue;
                this.url = curNode.getFirstChild().getNodeValue();
                continue;
            }
            if (curNode.getNodeType() == 1 && curNode.getNodeName().equalsIgnoreCase("database:username")) {
                if (curNode.getFirstChild() == null) {
                    this.username = "";
                    continue;
                }
                if (curNode.getFirstChild().getNodeType() != 3) continue;
                this.username = curNode.getFirstChild().getNodeValue();
                continue;
            }
            if (curNode.getNodeType() == 1 && curNode.getNodeName().equalsIgnoreCase("database:password")) {
                if (curNode.getFirstChild() == null) {
                    this.password = "";
                    continue;
                }
                if (curNode.getFirstChild().getNodeType() != 3) continue;
                this.password = curNode.getFirstChild().getNodeValue();
                continue;
            }
            if (curNode.getNodeType() == 1 && curNode.getNodeName().equalsIgnoreCase("database:interaction")) {
                this.interaction = curNode.getAttributes().getNamedItem("type").getNodeValue();
                if (this.interaction != null && !this.interaction.equals("")) continue;
                this.interaction = "query";
                continue;
            }
            if (curNode.getNodeType() == 1 && curNode.getNodeName().equalsIgnoreCase("database:command")) {
                if (curNode.getFirstChild().getNodeType() == 4) {
                    this.command = curNode.getFirstChild().getNodeValue();
                    continue;
                }
                if (curNode.getFirstChild().getNodeType() != 3) continue;
                this.command = curNode.getFirstChild().getNodeValue();
                continue;
            }
            if (curNode.getNodeType() == 1 && curNode.getNodeName().equalsIgnoreCase("database:connectionkey")) {
                if (curNode.getFirstChild().getNodeType() != 3) continue;
                this.connectionkey = curNode.getFirstChild().getNodeValue();
                continue;
            }
            if (curNode.getNodeType() == 1 && curNode.getNodeName().equalsIgnoreCase("database:connectionlifespan")) {
                String ttl = curNode.getAttributes().getNamedItem("ttl").getNodeValue();
                try {
                    this.connectionlifespan = Long.parseLong(ttl);
                    this.connectionlifespan *= 60000L;
                }
                catch (NumberFormatException e) {
                    this.connectionlifespan = -1L;
                }
                continue;
            }
            if (curNode.getNodeType() == 1 && curNode.getNodeName().equalsIgnoreCase("database:confirmation")) {
                String con = curNode.getAttributes().getNamedItem("confirm").getNodeValue();
                this.confirmation = new Boolean(con);
                continue;
            }
            if (curNode.getNodeType() == 1 && curNode.getNodeName().equalsIgnoreCase("database:documentrootnode")) {
                if (curNode.getFirstChild().getNodeType() != 3) continue;
                this.documentrootnode = curNode.getFirstChild().getNodeValue();
                continue;
            }
            if (curNode.getNodeType() == 1 && curNode.getNodeName().equalsIgnoreCase("database:rowrootnode")) {
                if (curNode.getFirstChild().getNodeType() != 3) continue;
                this.rowrootnode = curNode.getFirstChild().getNodeValue();
                continue;
            }
            if (curNode.getNodeType() != 1 || !curNode.getNodeName().equalsIgnoreCase("database:rowlimit")) continue;
            String lim = curNode.getAttributes().getNamedItem("max").getNodeValue();
            try {
                this.rowlimit = Integer.parseInt(lim);
            }
            catch (NumberFormatException e) {
                this.rowlimit = -1;
            }
        }
    }

    public String getUrl() {
        return this.url;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getInteraction() {
        return this.interaction;
    }

    public String getCommand() {
        return this.command;
    }

    public long getConnectionlifespan() {
        return this.connectionlifespan;
    }

    public boolean getConfirmation() {
        return this.confirmation;
    }

    public String getDocumentrootnode() {
        return this.documentrootnode;
    }

    public String getRowrootnode() {
        return this.rowrootnode;
    }

    public int getRowlimit() {
        return this.rowlimit;
    }
}

