/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.protocol.jdbc;

import java.sql.Date;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.Timestamp;
import org.apache.crimson.tree.XmlDocument;
import org.jutils.log.LogChannel;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.XmlBlasterException;

public class DBAdapterUtils {
    private static final String ME = "DBAdapterUtils";
    private static final String NULL_STR = "NULL";

    public static Document createDocument(ResultSet rs) throws XmlBlasterException {
        return DBAdapterUtils.createDocument("jdbcresults", "row", -1, rs);
    }

    public static Document createDocument(String rootnode, String rownode, int rowlimit, ResultSet rs) throws XmlBlasterException {
        LogChannel log = Global.instance().getLog("jdbc");
        int rows = 0;
        XmlDocument doc = new XmlDocument();
        Element root = doc.createElement(rootnode);
        Element results = doc.createElement("results");
        Element desc = doc.createElement("desc");
        root.appendChild(desc);
        root.appendChild(results);
        String columnName = null;
        try {
            ResultSetMetaData rsmd = rs.getMetaData();
            int columns = rsmd.getColumnCount();
            Element numColumns = doc.createElement("numcolumns");
            Text numColumnsValue = doc.createTextNode("" + columns);
            numColumns.appendChild(numColumnsValue);
            desc.appendChild(numColumns);
            Element columnNames = doc.createElement("columnnames");
            int i = 1;
            int j = columns;
            while (i <= j) {
                columnName = rsmd.getColumnName(i);
                Element name = doc.createElement("column");
                Text value = doc.createTextNode(columnName);
                name.appendChild(value);
                columnNames.appendChild(name);
                ++i;
            }
            desc.appendChild(columnNames);
            while (rs.next()) {
                if (log.TRACE) {
                    log.trace(ME, "Scanning SQL result with rowlimit=" + rowlimit + ", rows=" + rows);
                }
                if (rowlimit < 0) continue;
                if (rows < rowlimit) {
                    ++rows;
                    Element row = doc.createElement(rownode);
                    int i2 = 1;
                    int j2 = columns;
                    while (i2 <= j2) {
                        int cType = rsmd.getColumnType(i2);
                        columnName = rsmd.getColumnName(i2);
                        String columnValue = "";
                        switch (cType) {
                            case -1: 
                            case 1: 
                            case 12: {
                                columnValue = rs.getString(i2);
                                break;
                            }
                            case 8: {
                                columnValue = "" + rs.getDouble(i2);
                                break;
                            }
                            case 6: {
                                columnValue = "" + rs.getFloat(i2);
                                break;
                            }
                            case 4: {
                                columnValue = "" + rs.getInt(i2);
                                break;
                            }
                            case 2: {
                                columnValue = "" + rs.getLong(i2);
                                break;
                            }
                            case 91: {
                                Date d = rs.getDate(i2);
                                columnValue = d == null ? NULL_STR : d.toString();
                                break;
                            }
                            case 93: {
                                Timestamp t = rs.getTimestamp(i2);
                                columnValue = t == null ? NULL_STR : t.toString();
                                break;
                            }
                            case -7: 
                            case -6: 
                            case -5: 
                            case -4: 
                            case -3: 
                            case -2: 
                            case 0: 
                            case 3: 
                            case 5: 
                            case 7: 
                            case 92: 
                            case 1111: 
                            case 2000: 
                            case 2001: 
                            case 2002: 
                            case 2003: 
                            case 2004: 
                            case 2005: 
                            case 2006: {
                                Object o1 = rs.getObject(i2);
                                columnValue = o1 == null ? NULL_STR : o1.toString();
                                break;
                            }
                            default: {
                                Object o2;
                                if (log.TRACE) {
                                    log.warn(ME, "Datatype '" + cType + "' of column '" + columnName + "' is not implemented, plase add a case statement in DBAdapterUtils.java");
                                }
                                String string = columnValue = (o2 = rs.getObject(i2)) == null ? NULL_STR : o2.toString();
                            }
                        }
                        if (log.TRACE) {
                            log.trace(ME, "row=" + rows + ", columnName=" + columnName + ", type=" + cType + " columnValue='" + columnValue + "'");
                        }
                        Element col = doc.createElement(columnName);
                        CDATASection cvalue = doc.createCDATASection(columnValue);
                        col.appendChild(cvalue);
                        row.appendChild(col);
                        results.appendChild(row);
                        ++i2;
                    }
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            log.error(ME, "Error in scanning result set for '" + columnName + "': " + e.toString());
            throw new XmlBlasterException("DBAdapterUtils.DomResultSetError", "Error in scanning result set for '" + columnName + "': " + e.getMessage());
        }
        Element numRows = doc.createElement("rownum");
        Text numRowsValue = doc.createTextNode("" + rows);
        numRows.appendChild(numRowsValue);
        desc.appendChild(numRows);
        doc.appendChild(root);
        return doc;
    }
}

