/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.protocol.jdbc;

import java.sql.Driver;
import java.sql.DriverManager;
import java.util.StringTokenizer;
import org.jutils.log.LogChannel;
import org.xmlBlaster.client.qos.ConnectQos;
import org.xmlBlaster.engine.qos.AddressServer;
import org.xmlBlaster.engine.qos.ConnectQosServer;
import org.xmlBlaster.engine.qos.ConnectReturnQosServer;
import org.xmlBlaster.engine.qos.DisconnectQosServer;
import org.xmlBlaster.protocol.I_Authenticate;
import org.xmlBlaster.protocol.I_Driver;
import org.xmlBlaster.protocol.I_XmlBlaster;
import org.xmlBlaster.protocol.jdbc.CallbackJdbcDriver;
import org.xmlBlaster.protocol.jdbc.I_Publish;
import org.xmlBlaster.protocol.jdbc.NamedConnectionPool;
import org.xmlBlaster.protocol.jdbc.XmlDBAdapterWorker;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.MsgUnitRaw;
import org.xmlBlaster.util.XmlBlasterException;
import org.xmlBlaster.util.def.ErrorCode;
import org.xmlBlaster.util.plugin.PluginInfo;
import org.xmlBlaster.util.qos.address.CallbackAddress;

public class JdbcDriver
implements I_Driver,
I_Publish {
    private String ME = "JdbcDriver";
    private Global glob = null;
    private LogChannel log = null;
    private I_Authenticate authenticate = null;
    private I_XmlBlaster xmlBlasterImpl = null;
    private String sessionId = null;
    private NamedConnectionPool namedPool = null;
    private String cbRegistrationKey = null;
    private String loginName = null;
    private String passwd = null;

    public String getName() {
        return this.ME;
    }

    public String getProtocolId() {
        return "JDBC";
    }

    public String getType() {
        return this.getProtocolId();
    }

    public String getVersion() {
        return "1.0";
    }

    public void init(Global glob, PluginInfo pluginInfo) throws XmlBlasterException {
        this.glob = glob;
        this.ME = "JdbcDriver" + this.glob.getLogPrefixDashed();
        this.log = glob.getLog("jdbc");
        org.xmlBlaster.engine.Global engineGlob = (org.xmlBlaster.engine.Global)glob.getObjectEntry("ServerNodeScope");
        if (engineGlob == null) {
            throw new XmlBlasterException(this.glob, ErrorCode.INTERNAL_UNKNOWN, this.ME + ".init", "could not retreive the ServerNodeScope. Am I really on the server side ?");
        }
        try {
            this.authenticate = engineGlob.getAuthenticate();
            if (this.authenticate == null) {
                throw new XmlBlasterException(this.glob, ErrorCode.INTERNAL_UNKNOWN, this.ME + ".init", "authenticate object is null");
            }
            I_XmlBlaster xmlBlasterImpl = this.authenticate.getXmlBlaster();
            if (xmlBlasterImpl == null) {
                throw new XmlBlasterException(this.glob, ErrorCode.INTERNAL_UNKNOWN, this.ME + ".init", "xmlBlasterImpl object is null");
            }
            this.init(glob, new AddressServer(glob, this.getType(), glob.getId()), this.authenticate, xmlBlasterImpl);
            this.activate();
        }
        catch (XmlBlasterException ex) {
            throw ex;
        }
        catch (Throwable ex) {
            throw new XmlBlasterException(this.glob, ErrorCode.INTERNAL_UNKNOWN, this.ME + ".init", "init. Could'nt initialize the driver.", ex);
        }
    }

    public String getRawAddress() {
        if (this.log.TRACE) {
            this.log.trace(this.ME + ".getRawAddress()", "No external access address available");
        }
        return null;
    }

    private synchronized void init(Global glob, AddressServer addressServer, I_Authenticate authenticate, I_XmlBlaster xmlBlasterImpl) throws XmlBlasterException {
        this.glob.addObjectEntry("JdbcDriver-" + glob.getId(), this);
        this.authenticate = authenticate;
        this.xmlBlasterImpl = xmlBlasterImpl;
        this.namedPool = (NamedConnectionPool)this.glob.getObjectEntry("NamedConnectionPool-" + glob.getId());
        if (this.namedPool == null) {
            this.namedPool = new NamedConnectionPool(this.glob);
            this.glob.addObjectEntry("NamedConnectionPool-" + glob.getId(), this.namedPool);
        }
        this.initDrivers();
        if (this.log.TRACE) {
            this.log.trace(this.ME, "Initialized successfully JDBC driver.");
        }
    }

    public synchronized void activate() throws XmlBlasterException {
        if (this.log.CALL) {
            this.log.call(this.ME, "Entering activate");
        }
        this.loginName = this.glob.getProperty().get("JdbcDriver.loginName", "__sys__jdbc");
        this.passwd = this.glob.getProperty().get("JdbcDriver.password", "secret");
        if (this.loginName == null || this.passwd == null) {
            this.log.error(this.ME + "InvalidArguments", "login failed: please use no null arguments for connect()");
            throw new XmlBlasterException("LoginFailed.InvalidArguments", "login failed: please use no null arguments for connect()");
        }
        CallbackAddress cbAddress = new CallbackAddress(this.glob, "JDBC");
        cbAddress.setRawAddress("native-NameService:org.xmlBlaster.protocol.jdbc.CallbackJdbcDriver");
        CallbackJdbcDriver cbDriver = new CallbackJdbcDriver();
        cbDriver.init(this.glob, cbAddress);
        this.cbRegistrationKey = cbAddress.getType() + cbAddress.getRawAddress();
        this.glob.addNativeCallbackDriver(this.cbRegistrationKey, cbDriver);
        ConnectQos connectQos = new ConnectQos(this.glob);
        connectQos.addCallbackAddress(cbAddress);
        connectQos.loadClientPlugin("htpasswd", "1.0", this.loginName, this.passwd);
        connectQos.getSessionQos().setSessionTimeout(0L);
        ConnectReturnQosServer returnQos = this.authenticate.connect(new ConnectQosServer(this.glob, connectQos.getData()));
        this.sessionId = returnQos.getSecretSessionId();
        this.log.info(this.ME, "Started successfully JDBC driver with loginName=" + this.loginName);
    }

    public synchronized void deActivate() throws XmlBlasterException {
        if (this.log.CALL) {
            this.log.call(this.ME, "Entering deActivate");
        }
        this.glob.removeNativeCallbackDriver(this.cbRegistrationKey);
    }

    public void shutdown() throws XmlBlasterException {
        if (this.sessionId != null) {
            try {
                this.authenticate.disconnect(this.sessionId, new DisconnectQosServer(this.glob).toXml());
            }
            catch (XmlBlasterException xmlBlasterException) {
                // empty catch block
            }
        }
        this.namedPool.destroy();
        this.log.info(this.ME, "JDBC service stopped, resources released.");
    }

    public String usage() {
        String text = "\n";
        text = text + "JdbcDriver options:\n";
        text = text + "   -JdbcDriver.password\n";
        text = text + "                       The internal xmlBlaster-password for the JDBC driver.\n";
        text = text + "   -JdbcDriver.drivers List of all jdbc drivers to initalize, e.g.\n";
        text = text + "                       oracle.jdbc.driver.OracleDriver:org.gjt.mm.mysql.Driver,postgresql.Driver.\n";
        text = text + "\n";
        return text;
    }

    public void update(String sender, byte[] content) {
        if (this.log.CALL) {
            this.log.call(this.ME, "SQL message from '" + sender + "' received");
        }
        XmlDBAdapterWorker worker = new XmlDBAdapterWorker(this.glob, sender, content, this, this.namedPool);
        worker.start();
    }

    public String publish(MsgUnitRaw msgUnit) throws XmlBlasterException {
        return this.xmlBlasterImpl.publish(this.sessionId, msgUnit);
    }

    private void initDrivers() {
        String drivers = this.glob.getProperty().get("JdbcDriver.drivers", "sun.jdbc.odbc.JdbcOdbcDriver");
        StringTokenizer st = new StringTokenizer(drivers, ":");
        int numDrivers = st.countTokens();
        String driver = "";
        int i = 0;
        while (i < numDrivers) {
            try {
                driver = st.nextToken().trim();
                if (this.log.TRACE) {
                    this.log.trace(this.ME, "Trying JDBC driver Class.forName('" + driver + "') ...");
                }
                Class<?> cl = Class.forName(driver);
                Driver dr = (Driver)cl.newInstance();
                DriverManager.registerDriver(dr);
                this.log.info(this.ME, "Jdbc driver '" + driver + "' loaded.");
            }
            catch (Throwable e) {
                this.log.warn(this.ME, "Couldn't initialize driver <" + driver + ">, please check your CLASSPATH");
            }
            ++i;
        }
        if (numDrivers == 0) {
            this.log.warn(this.ME, "No JDBC driver in xmlBlaster.properties given, set 'JdbcDriver.drivers' to point to your DB drivers if wanted, e.g. JdbcDriver.drivers=oracle.jdbc.driver.OracleDriveri:org.gjt.mm.mysql.Driver:postgresql.Driver");
        }
    }
}

