/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.protocol.jdbc;

import java.sql.Connection;
import java.sql.DriverManager;
import java.util.Enumeration;
import java.util.Hashtable;
import org.jutils.log.LogChannel;
import org.jutils.runtime.Sleeper;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.I_Timeout;
import org.xmlBlaster.util.Timestamp;
import org.xmlBlaster.util.XmlBlasterException;
import org.xmlBlaster.util.def.ErrorCode;
import org.xmlBlaster.util.pool.I_PoolManager;
import org.xmlBlaster.util.pool.PoolManager;
import org.xmlBlaster.util.pool.ResourceWrapper;

public class NamedConnectionPool {
    private static final String ME = "NamedConnectionPool";
    private Global glob;
    private LogChannel log;
    private Hashtable namedPools = new Hashtable();
    private final Object meetingPoint = new Object();

    NamedConnectionPool(Global glob) {
        this.glob = glob;
        this.log = glob.getLog("jdbc");
    }

    Connection reserve(String dbUrl, String dbUser, String dbPasswd) throws XmlBlasterException {
        return this.reserve(dbUrl, dbUser, dbPasswd, -1L, -1, -1L);
    }

    Connection reserve(String dbUrl, String dbUser, String dbPasswd, long eraseUnusedPoolTimeout, int maxInstances, long idleToErase) throws XmlBlasterException {
        long busyToIdle = 0L;
        UnnamedConnectionPool pool = this.getPool(dbUrl, dbUser, dbPasswd);
        if (pool == null) {
            Object object = this.meetingPoint;
            synchronized (object) {
                pool = this.getPool(dbUrl, dbUser, dbPasswd);
                if (pool == null) {
                    if (dbPasswd == null) {
                        throw new XmlBlasterException("NamedConnectionPool.MissingPasswd", "Please give a password for '" + dbUser + "' when creating a JDBC pool");
                    }
                    pool = new UnnamedConnectionPool(this, dbUrl, dbUser, dbPasswd, eraseUnusedPoolTimeout, maxInstances, busyToIdle, idleToErase);
                    this.namedPools.put(this.getKey(dbUrl, dbUser, dbPasswd), pool);
                }
            }
        }
        try {
            Connection con = pool.reserve();
            if (this.log.TRACE) {
                this.log.trace(ME, "reserve(" + dbUrl + ", " + dbUser + ") con=" + con);
            }
            return con;
        }
        catch (XmlBlasterException e) {
            throw e;
        }
        catch (Throwable e) {
            this.log.error(ME, "Unexpected exception in connect(" + dbUrl + ", " + dbUser + "): " + e.toString());
            throw new XmlBlasterException("NamedConnectionPool.NoOpen", "Couldn't open database connection: " + e.toString());
        }
    }

    void release(String dbUrl, String dbUser, String dbPasswd, Connection con) throws XmlBlasterException {
        UnnamedConnectionPool pool = this.getPool(dbUrl, dbUser, dbPasswd);
        if (pool != null) {
            pool.release(con);
            if (this.log.TRACE) {
                this.log.trace(ME, "release(" + dbUrl + ", " + dbUser + ") con=" + con);
            }
        }
    }

    void eraseConnection(String dbUrl, String dbUser, String dbPasswd, Connection con) throws XmlBlasterException {
        UnnamedConnectionPool pool = this.getPool(dbUrl, dbUser, dbPasswd);
        if (pool != null) {
            if (this.log.TRACE) {
                this.log.trace(ME, "erase(" + dbUrl + ", " + dbUser + ") con=" + con);
            }
            pool.erase(con);
        }
    }

    void destroy(String dbUrl, String dbUser, String dbPasswd) throws XmlBlasterException {
        if (this.log.TRACE) {
            this.log.trace(ME, "Entering destroy() ...");
        }
        try {
            String key = this.getKey(dbUrl, dbUser, dbPasswd);
            UnnamedConnectionPool pool = (UnnamedConnectionPool)this.namedPools.remove(key);
            if (pool != null) {
                pool.destroy();
            }
            if (this.log.TRACE) {
                this.log.trace(ME, "All JDBC connections for '" + dbUrl + "' destroyed");
            }
        }
        catch (Exception e) {
            this.log.error(ME, "System Exception in destroy JDBC connection for '" + dbUrl + "': " + e.toString());
            throw new XmlBlasterException("NamedConnectionPool.DestroyError", "System Exception in destroy JDBC connection for '" + dbUrl + "': " + e.toString());
        }
    }

    void destroy() {
        Enumeration e = this.namedPools.elements();
        while (e.hasMoreElements()) {
            UnnamedConnectionPool pool = (UnnamedConnectionPool)e.nextElement();
            pool.destroy();
        }
        this.namedPools.clear();
    }

    private String getKey(String dbUrl, String dbUser, String dbPasswd) {
        StringBuffer buf = new StringBuffer(80);
        return buf.append(dbUrl).append("^").append(dbUser).append("/").append(dbPasswd).toString();
    }

    private UnnamedConnectionPool getPool(String dbUrl, String dbUser, String dbPasswd) {
        String key = this.getKey(dbUrl, dbUser, dbPasswd);
        return (UnnamedConnectionPool)this.namedPools.get(key);
    }

    public final String toXml() {
        StringBuffer buf = new StringBuffer(256);
        String offset = "\n";
        buf.append(offset).append("<").append(ME).append(">");
        buf.append(offset).append("   <namedPools num='").append(this.namedPools.size()).append("'>");
        Enumeration e = this.namedPools.elements();
        while (e.hasMoreElements()) {
            UnnamedConnectionPool pool = (UnnamedConnectionPool)e.nextElement();
            buf.append(pool.toXml());
        }
        buf.append(offset).append("   </namedPools>");
        buf.append(offset).append("</NamedConnectionPool>");
        return buf.toString();
    }

    public static void main(String[] args) {
    }

    private class UnnamedConnectionPool
    implements I_PoolManager,
    I_Timeout {
        private static final String ME = "UnnamedConnectionPool";
        private NamedConnectionPool boss = null;
        PoolManager poolManager = null;
        private String dbUrl;
        private String dbUser;
        private String dbPasswd;
        private long eraseUnusedPoolTimeout;
        private int maxResourceExhaustRetries;
        private long resourceExhaustSleepGap;
        private Timestamp timeoutHandle;
        private final Object timeoutMonitor = new Object();
        private final Object meetingPoint = new Object();

        public UnnamedConnectionPool(NamedConnectionPool boss, String dbUrl, String dbUser, String dbPasswd, long eraseUnusedPoolTimeout, int maxInstances, long busyToIdle, long idleToErase) {
            this.boss = boss;
            this.dbUrl = dbUrl;
            this.dbUser = dbUser;
            this.dbPasswd = dbPasswd;
            this.eraseUnusedPoolTimeout = eraseUnusedPoolTimeout;
            if (this.eraseUnusedPoolTimeout == -1L) {
                this.eraseUnusedPoolTimeout = NamedConnectionPool.this.glob.getProperty().get("JdbcPool.eraseUnusedPoolTimeout", 3600000L);
            }
            if (this.eraseUnusedPoolTimeout > 0L && this.eraseUnusedPoolTimeout < 1000L) {
                this.eraseUnusedPoolTimeout = 1000L;
            }
            if (maxInstances == -1) {
                maxInstances = NamedConnectionPool.this.glob.getProperty().get("JdbcPool.maxInstances", 20);
            }
            if (busyToIdle == -1L) {
                busyToIdle = NamedConnectionPool.this.glob.getProperty().get("JdbcPool.busyToIdleTimeout", 0);
            }
            if (idleToErase == -1L) {
                idleToErase = NamedConnectionPool.this.glob.getProperty().get("JdbcPool.idleToEraseTimeout", 600000L);
            }
            this.maxResourceExhaustRetries = NamedConnectionPool.this.glob.getProperty().get("JdbcPool.maxResourceExhaustRetries", 5);
            this.resourceExhaustSleepGap = NamedConnectionPool.this.glob.getProperty().get("JdbcPool.resourceExhaustSleepGap", 1000);
            this.poolManager = new PoolManager(ME, this, maxInstances, busyToIdle, idleToErase);
            if (this.eraseUnusedPoolTimeout >= 1000L) {
                Object object = this.timeoutMonitor;
                synchronized (object) {
                    this.timeoutHandle = this.poolManager.getTransistionTimer().addTimeoutListener(this, this.eraseUnusedPoolTimeout, "dummy");
                }
            }
        }

        public void idleToBusy(Object resource) {
        }

        public void busyToIdle(Object resource) {
        }

        public Object toCreate(String instanceId) throws XmlBlasterException {
            try {
                return DriverManager.getConnection(this.dbUrl, this.dbUser, this.dbPasswd);
            }
            catch (Exception e) {
                throw new XmlBlasterException(ME, "Couldn't open database connection dbUrl=" + this.dbUrl + " dbUser=" + this.dbUser + ": " + e.toString());
            }
        }

        public void toErased(Object resource) {
            Connection con = (Connection)resource;
            try {
                con.close();
                if (((NamedConnectionPool)NamedConnectionPool.this).log.TRACE) {
                    NamedConnectionPool.this.log.trace(ME, "JDBC connection closed for '" + this.dbUrl + "', '" + this.dbUser + "'");
                }
            }
            catch (Exception e) {
                NamedConnectionPool.this.log.error(ME, "System Exception in close JDBC connection: " + e.toString());
            }
        }

        Connection reserve() throws XmlBlasterException {
            if (this.poolManager == null) {
                throw new XmlBlasterException("UnnamedConnectionPool.Destroyed", "Pool is destroyed");
            }
            if (((NamedConnectionPool)NamedConnectionPool.this).log.TRACE) {
                NamedConnectionPool.this.log.trace(ME, "Entering reserve '" + this.dbUrl + "', '" + this.dbUser + "'");
            }
            int ii = 0;
            while (true) {
                try {
                    Object object = this.meetingPoint;
                    synchronized (object) {
                        Connection con;
                        if (this.eraseUnusedPoolTimeout > 200L) {
                            Object object2 = this.timeoutMonitor;
                            synchronized (object2) {
                                this.timeoutHandle = this.poolManager.getTransistionTimer().refreshTimeoutListener(this.timeoutHandle, this.eraseUnusedPoolTimeout);
                            }
                        }
                        ResourceWrapper rw = this.poolManager.reserve("o");
                        Connection connection = con = (Connection)rw.getResource();
                        return connection;
                    }
                }
                catch (XmlBlasterException e) {
                    if (e.getErrorCode() == ErrorCode.RESOURCE_EXHAUST && ii < this.maxResourceExhaustRetries) {
                        if (ii == 0) {
                            NamedConnectionPool.this.log.warn(ME, "Caught exception in reserve(), going to poll " + this.maxResourceExhaustRetries + " times every " + this.resourceExhaustSleepGap + " millis");
                        }
                        Sleeper.sleep(this.resourceExhaustSleepGap);
                        ++ii;
                        continue;
                    }
                    throw e;
                }
                break;
            }
        }

        void release(Connection con) throws XmlBlasterException {
            if (this.poolManager == null) {
                throw new XmlBlasterException("UnnamedConnectionPool.Destroyed", "Pool is destroyed");
            }
            if (((NamedConnectionPool)NamedConnectionPool.this).log.TRACE) {
                NamedConnectionPool.this.log.trace(ME, "Entering release '" + this.dbUrl + "', '" + this.dbUser + "' conId=" + con);
            }
            try {
                Object object = this.meetingPoint;
                synchronized (object) {
                    this.poolManager.release("" + con);
                }
            }
            catch (XmlBlasterException e) {
                Thread.currentThread();
                Thread.dumpStack();
                NamedConnectionPool.this.log.error(ME, "Caught exception in release(): " + e.toString());
                throw e;
            }
        }

        void erase(Connection con) throws XmlBlasterException {
            if (this.poolManager == null) {
                throw new XmlBlasterException("UnnamedConnectionPool.Destroyed", "Pool is destroyed");
            }
            if (((NamedConnectionPool)NamedConnectionPool.this).log.TRACE) {
                NamedConnectionPool.this.log.trace(ME, "Entering erase '" + this.dbUrl + "', '" + this.dbUser + "' conId=" + con);
            }
            Object object = this.meetingPoint;
            synchronized (object) {
                this.poolManager.erase("" + con);
            }
        }

        public void timeout(Object o) {
            if (((NamedConnectionPool)NamedConnectionPool.this).log.TRACE) {
                NamedConnectionPool.this.log.trace(ME, "Entering pool destroy timeout for '" + this.dbUrl + "', '" + this.dbUser + "' ...");
            }
            Object object = this.meetingPoint;
            synchronized (object) {
                if (this.poolManager.getNumBusy() != 0) {
                    NamedConnectionPool.this.log.warn(ME, "Can't destroy pool from '" + this.dbUrl + "', '" + this.dbUser + "', he seems to be busy working on his database.");
                    if (this.eraseUnusedPoolTimeout > 200L) {
                        Object object2 = this.timeoutMonitor;
                        synchronized (object2) {
                            this.timeoutHandle = this.poolManager.getTransistionTimer().addTimeoutListener(this, this.eraseUnusedPoolTimeout, "dummy");
                        }
                    }
                    return;
                }
                try {
                    this.boss.destroy(this.dbUrl, this.dbUser, this.dbPasswd);
                }
                catch (XmlBlasterException e) {
                    NamedConnectionPool.this.log.error(ME, "timeout: " + e.toString());
                }
            }
        }

        void destroy() {
            Object object = this.meetingPoint;
            synchronized (object) {
                if (this.poolManager != null) {
                    if (((NamedConnectionPool)NamedConnectionPool.this).log.TRACE) {
                        NamedConnectionPool.this.log.trace(ME, "Destroying pool: " + this.poolManager.toXml());
                    }
                    this.poolManager.destroy();
                    this.poolManager = null;
                }
            }
            Object boss = null;
            this.dbUrl = null;
            this.dbUser = null;
        }

        public final String toXml() {
            StringBuffer buf = new StringBuffer(256);
            String offset = "\n   ";
            buf.append(offset).append("<").append(ME).append(" url='").append(this.dbUrl).append("' user='").append(this.dbUser).append("' this.eraseUnusedPoolTimeout='").append(this.eraseUnusedPoolTimeout).append("'>");
            if (this.poolManager != null) {
                buf.append(this.poolManager.toXml("      "));
            } else {
                buf.append(this.poolManager.toXml("      DESTROYED"));
            }
            buf.append(offset).append("</UnnamedConnectionPool>");
            return buf.toString();
        }
    }
}

