/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.protocol.jdbc;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.jutils.log.LogChannel;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;
import org.xmlBlaster.client.key.PublishKey;
import org.xmlBlaster.engine.qos.GetReturnQosServer;
import org.xmlBlaster.protocol.jdbc.ConnectionDescriptor;
import org.xmlBlaster.protocol.jdbc.DBAdapterUtils;
import org.xmlBlaster.protocol.jdbc.NamedConnectionPool;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.MsgUnit;
import org.xmlBlaster.util.XmlBlasterException;
import org.xmlBlaster.util.XmlNotPortable;

public class XmlDBAdapter {
    private static final String ME = "XmlDBAdapter";
    private final Global glob;
    private final LogChannel log;
    private byte[] content;
    private NamedConnectionPool namedPool = null;

    public XmlDBAdapter(Global glob, byte[] content, NamedConnectionPool namedPool) {
        this.glob = glob;
        this.log = glob.getLog("jdbc");
        this.content = content;
        this.namedPool = namedPool;
        if (this.namedPool == null) {
            Thread.currentThread();
            Thread.dumpStack();
            throw new IllegalArgumentException("XmlDBAdapter: namedPool is null, check your -ProtocolPlugin[JDBC][1.0] configuration");
        }
    }

    public MsgUnit[] query() {
        Document document = null;
        try {
            document = this.createDocument();
        }
        catch (Exception e) {
            this.log.exception("XmlDBAdapter.SqlInitError", e);
            this.log.warn("XmlDBAdapter.SqlInitError", "Problems with request: " + new String(this.content));
            XmlBlasterException ex = new XmlBlasterException("XmlDBAdapter.SqlInitError", e.getMessage());
            return this.getResponseMessage(ex.toXml().getBytes(), "XmlBlasterException");
        }
        ConnectionDescriptor descriptor = null;
        if (this.log.TRACE) {
            this.log.trace(ME, "Get connection ...");
        }
        descriptor = new ConnectionDescriptor(document);
        try {
            if (this.log.TRACE) {
                this.log.trace(ME, "Access DB ...");
            }
            document = this.queryDB(descriptor);
        }
        catch (XmlBlasterException e) {
            return this.getResponseMessage(e.toXml().getBytes(), "XmlBlasterException");
        }
        if (descriptor.getConfirmation()) {
            return this.getResponseMessage(document);
        }
        return new MsgUnit[0];
    }

    private Document createDocument() throws Exception {
        DocumentBuilderFactory dbf = this.glob.getDocumentBuilderFactory();
        dbf.setNamespaceAware(true);
        DocumentBuilder db = dbf.newDocumentBuilder();
        if (this.log.TRACE) {
            this.log.trace(ME, "Tracing " + new String(this.content));
        }
        ByteArrayInputStream inputStream = new ByteArrayInputStream(this.content);
        Document doc = db.parse(inputStream);
        return doc;
    }

    /*
     * Loose catch block
     */
    private Document queryDB(ConnectionDescriptor descriptor) throws XmlBlasterException {
        Document doc;
        block21: {
            ResultSet rs;
            Statement stmt;
            Connection conn;
            block19: {
                if (this.log.CALL) {
                    this.log.call(ME, "Entering queryDB() ...");
                }
                conn = null;
                stmt = null;
                rs = null;
                doc = null;
                conn = this.namedPool.reserve(descriptor.getUrl(), descriptor.getUsername(), descriptor.getPassword());
                stmt = conn.createStatement();
                String command = descriptor.getCommand();
                if (descriptor.getInteraction().equalsIgnoreCase("update")) {
                    if (this.log.TRACE) {
                        this.log.trace(ME, "Trying DB update '" + command + "' ...");
                    }
                    int rowsAffected = stmt.executeUpdate(command);
                    doc = this.createUpdateDocument(rowsAffected, descriptor);
                } else {
                    if (this.log.TRACE) {
                        this.log.trace(ME, "Trying SQL query '" + command + "' ...");
                    }
                    rs = stmt.executeQuery(command);
                    doc = DBAdapterUtils.createDocument(descriptor.getDocumentrootnode(), descriptor.getRowrootnode(), descriptor.getRowlimit(), rs);
                }
                if (!this.log.TRACE) break block19;
                this.log.trace(ME, "Query successful done, connection released");
            }
            Object var10_11 = null;
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (SQLException e) {
                this.log.warn(ME, "Closing of stmt failed: " + e.toString());
            }
            if (conn != null) {
                this.namedPool.release(descriptor.getUrl(), descriptor.getUsername(), descriptor.getPassword(), conn);
            }
            break block21;
            {
                catch (SQLException e) {
                    String str = "SQLException in query '" + descriptor.getCommand() + "' : " + e;
                    this.log.warn(ME, str + ": sqlSTATE=" + e.getSQLState() + " we destroy the connection in case it's stale");
                    String sqlState = e.getSQLState();
                    this.namedPool.eraseConnection(descriptor.getUrl(), descriptor.getUsername(), descriptor.getPassword(), conn);
                    conn = null;
                    throw new XmlBlasterException(ME, str);
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    String str = "Unexpected exception in query '" + descriptor.getCommand() + "' : " + e;
                    this.log.error(ME, str + ": We destroy the connection in case it's stale");
                    this.namedPool.eraseConnection(descriptor.getUrl(), descriptor.getUsername(), descriptor.getPassword(), conn);
                    conn = null;
                    throw new XmlBlasterException(ME, str);
                }
            }
            catch (Throwable throwable) {
                Object var10_12 = null;
                try {
                    if (rs != null) {
                        rs.close();
                    }
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (SQLException e) {
                    this.log.warn(ME, "Closing of stmt failed: " + e.toString());
                }
                if (conn != null) {
                    this.namedPool.release(descriptor.getUrl(), descriptor.getUsername(), descriptor.getPassword(), conn);
                }
                throw throwable;
            }
        }
        return doc;
    }

    private Document createEmptyDocument() throws XmlBlasterException {
        String factoryBackup = System.getProperty("javax.xml.parsers.DocumentBuilderFactory");
        String newFactory = this.glob.getProperty().get("javax.xml.parsers.DocumentBuilderFactory", "org.apache.crimson.jaxp.DocumentBuilderFactoryImpl");
        System.setProperty("javax.xml.parsers.DocumentBuilderFactory", newFactory);
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        if (factoryBackup != null) {
            System.setProperty("javax.xml.parsers.DocumentBuilderFactory", factoryBackup);
        }
        factory.setValidating(false);
        factory.setIgnoringComments(false);
        factory.setNamespaceAware(false);
        try {
            return factory.newDocumentBuilder().newDocument();
        }
        catch (ParserConfigurationException e) {
            this.log.error(ME, "Can't create xml document: " + e.toString());
            throw new XmlBlasterException(ME, "Can't create xml document: " + e.toString());
        }
    }

    private Document createUpdateDocument(int rowsAffected, ConnectionDescriptor descriptor) throws XmlBlasterException {
        Document document = this.createEmptyDocument();
        Element root = document.createElement(descriptor.getDocumentrootnode());
        document.appendChild(root);
        Element row = document.createElement(descriptor.getRowrootnode());
        root.appendChild(row);
        Text rows = document.createTextNode(rowsAffected + " row(s) were affected during the update.");
        row.appendChild(rows);
        return document;
    }

    private MsgUnit[] getResponseMessage(Document doc) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            out = XmlNotPortable.write(doc);
        }
        catch (IOException e) {
            this.log.error(ME, "getResponseMessage failed: " + e.getMessage());
        }
        return this.getResponseMessage(out.toByteArray(), "QueryResults");
    }

    private MsgUnit[] getResponseMessage(byte[] content, String contentMimeExtended) {
        PublishKey key = new PublishKey(this.glob, "__sys_jdbc.XmlDBAdapter", "text/xml", contentMimeExtended);
        GetReturnQosServer retQos = new GetReturnQosServer(this.glob, null, "OK");
        MsgUnit mu = new MsgUnit(key.getData(), content, retQos.getData());
        if (this.log.DUMP) {
            this.log.plain(ME, "SQL Results...\n" + new String(content));
        }
        MsgUnit[] msgArr = new MsgUnit[]{mu};
        return msgArr;
    }
}

