/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.protocol.jdbc;

import org.jutils.log.LogChannel;
import org.xmlBlaster.client.key.PublishKey;
import org.xmlBlaster.client.qos.PublishQos;
import org.xmlBlaster.protocol.jdbc.I_Publish;
import org.xmlBlaster.protocol.jdbc.NamedConnectionPool;
import org.xmlBlaster.protocol.jdbc.XmlDBAdapter;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.MsgUnit;
import org.xmlBlaster.util.MsgUnitRaw;
import org.xmlBlaster.util.SessionName;
import org.xmlBlaster.util.XmlBlasterException;
import org.xmlBlaster.util.qos.address.Destination;

public class XmlDBAdapterWorker
extends Thread {
    private static final String ME = "WorkerThread";
    private final Global glob;
    private final LogChannel log;
    private String cust;
    private byte[] content;
    private I_Publish callback = null;
    private NamedConnectionPool namedPool = null;

    public XmlDBAdapterWorker(Global glob, String cust, byte[] content, I_Publish callback, NamedConnectionPool namedPool) {
        this.glob = glob;
        this.log = glob.getLog("jdbc");
        this.cust = cust;
        this.content = content;
        this.callback = callback;
        this.namedPool = namedPool;
    }

    public void run() {
        XmlDBAdapter adap = new XmlDBAdapter(this.glob, this.content, this.namedPool);
        MsgUnit[] msgArr = adap.query();
        try {
            if (msgArr == null || msgArr.length == 0) {
                if (this.log.TRACE) {
                    this.log.trace(ME, "No result message returned to client");
                }
                return;
            }
            int ii = 0;
            while (ii < msgArr.length) {
                PublishKey key = new PublishKey(this.glob, "__sys_jdbc.WorkerThread", "text/xml", "SQLQuery");
                PublishQos qos = new PublishQos(this.glob, new Destination(new SessionName(this.glob, this.cust)));
                MsgUnitRaw msgUnitRaw = new MsgUnitRaw(msgArr[ii], key.toXml(), msgArr[ii].getContent(), qos.toXml());
                String oid = this.callback.publish(msgUnitRaw);
                if (this.log.DUMP) {
                    this.log.plain(ME, "Delivered Results...\n" + new String(this.content));
                }
                ++ii;
            }
        }
        catch (XmlBlasterException e) {
            this.log.error(ME, "Exception in notify: " + e.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
            this.log.error(ME, "Exception in notify: " + e);
        }
    }
}

