/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.protocol.local;

import org.jutils.log.LogChannel;
import org.xmlBlaster.protocol.I_CallbackDriver;
import org.xmlBlaster.protocol.local.I_LocalCallback;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.MsgUnitRaw;
import org.xmlBlaster.util.XmlBlasterException;
import org.xmlBlaster.util.def.ErrorCode;
import org.xmlBlaster.util.plugin.PluginInfo;
import org.xmlBlaster.util.qos.address.CallbackAddress;

public class CallbackLocalDriver
implements I_CallbackDriver {
    private String ME = "CallbackLocalDriver";
    private Global glob;
    private LogChannel log;
    private I_LocalCallback localCallback;
    private CallbackAddress callbackAddress;

    public final String getName() {
        return this.ME;
    }

    public String getProtocolId() {
        return "LOCAL";
    }

    public String getType() {
        return this.getProtocolId();
    }

    public String getVersion() {
        return "1.0";
    }

    public void init(Global glob, PluginInfo pluginInfo) {
    }

    public String getRawAddress() {
        return this.callbackAddress.getRawAddress();
    }

    public final void init(Global glob, CallbackAddress callbackAddress) throws XmlBlasterException {
        this.glob = glob;
        this.log = glob.getLog("local");
        this.callbackAddress = callbackAddress;
        String callbackId = callbackAddress.getRawAddress();
        try {
            this.localCallback = (I_LocalCallback)glob.getObjectEntry(callbackId);
            if (this.localCallback == null) {
                throw new XmlBlasterException(this.glob, ErrorCode.INTERNAL_UNKNOWN, this.ME + ".init", "could not retreive the LocalCallbackImpl, was there really one started");
            }
        }
        catch (Throwable e) {
            this.log.error(this.ME, "The given callback id ='" + callbackId + "' is invalid: " + e.toString());
            throw new XmlBlasterException(glob, ErrorCode.RESOURCE_CONFIGURATION_ADDRESS, "Local-CallbackHandleInvalid", "The given callback Id is invalid: " + e.toString());
        }
    }

    public final String[] sendUpdate(MsgUnitRaw[] msgArr) throws XmlBlasterException {
        if (msgArr == null || msgArr.length < 1) {
            throw new XmlBlasterException(this.glob, ErrorCode.INTERNAL_ILLEGALARGUMENT, this.ME, "Illegal sendUpdate() argument");
        }
        if (this.log.TRACE) {
            this.log.trace(this.ME, "xmlBlaster.update() to " + this.callbackAddress.getSecretSessionId());
        }
        try {
            return this.localCallback.update(this.callbackAddress.getSecretSessionId(), msgArr);
        }
        catch (XmlBlasterException xmlBlasterException) {
            if (xmlBlasterException.isUser()) {
                throw xmlBlasterException;
            }
            throw new XmlBlasterException(this.glob, ErrorCode.USER_UPDATE_ERROR, this.ME, "Local Callback of " + msgArr.length + " messages to client [" + this.callbackAddress.getSecretSessionId() + "] failed.", xmlBlasterException);
        }
    }

    public void sendUpdateOneway(MsgUnitRaw[] msgArr) throws XmlBlasterException {
        if (msgArr == null || msgArr.length < 1) {
            throw new XmlBlasterException(this.glob, ErrorCode.INTERNAL_ILLEGALARGUMENT, this.ME, "Illegal sendUpdateOneway() argument");
        }
        if (this.log.TRACE) {
            this.log.trace(this.ME, "xmlBlaster.updateOneway() to " + this.callbackAddress.getSecretSessionId());
        }
        try {
            this.localCallback.updateOneway(this.callbackAddress.getSecretSessionId(), msgArr);
        }
        catch (Throwable e) {
            throw new XmlBlasterException(this.glob, ErrorCode.COMMUNICATION_NOCONNECTION, this.ME, "Local oneway callback of message to client [" + this.callbackAddress.getSecretSessionId() + "] failed", e);
        }
    }

    public final String ping(String qos) throws XmlBlasterException {
        try {
            return this.localCallback.ping(qos);
        }
        catch (Throwable e) {
            throw new XmlBlasterException(this.glob, ErrorCode.COMMUNICATION_NOCONNECTION, this.ME, "Local callback ping failed", e);
        }
    }

    public void shutdown() {
        this.localCallback = null;
        this.callbackAddress = null;
        if (this.log.TRACE) {
            this.log.trace(this.ME, "Shutdown implementation is missing");
        }
    }

    public boolean isAlive() {
        return true;
    }
}

