/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.protocol.rmi;

import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import org.jutils.log.LogChannel;
import org.jutils.time.StopWatch;
import org.xmlBlaster.engine.qos.ConnectQosServer;
import org.xmlBlaster.engine.qos.ConnectReturnQosServer;
import org.xmlBlaster.protocol.I_Authenticate;
import org.xmlBlaster.protocol.I_XmlBlaster;
import org.xmlBlaster.protocol.rmi.I_AuthServer;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.XmlBlasterException;

public class AuthServerImpl
extends UnicastRemoteObject
implements I_AuthServer {
    private String ME = "AuthServerImpl";
    private final Global glob;
    private final LogChannel log;
    private final I_Authenticate authenticate;

    public AuthServerImpl(Global glob, I_Authenticate authenticate, I_XmlBlaster blasterNative) throws RemoteException {
        this.glob = glob;
        this.log = glob.getLog("rmi");
        this.authenticate = authenticate;
    }

    public String connect(String qos_literal) throws RemoteException, XmlBlasterException {
        String returnValue = null;
        ConnectQosServer connectQos = new ConnectQosServer(this.glob, qos_literal);
        if (this.log.CALL) {
            this.log.call(this.ME, "Entering connect(qos=" + qos_literal + ")");
        }
        StopWatch stop = null;
        if (this.log.TIME) {
            stop = new StopWatch();
        }
        ConnectReturnQosServer returnQos = this.authenticate.connect(connectQos);
        returnValue = returnQos.toXml();
        if (this.log.TIME) {
            this.log.time(this.ME, "Elapsed time in connect()" + stop.nice());
        }
        return returnValue;
    }

    public void disconnect(String sessionId, String qos_literal) throws RemoteException, XmlBlasterException {
        if (this.log.CALL) {
            this.log.call(this.ME, "Entering disconnect()");
        }
        this.authenticate.disconnect(sessionId, qos_literal);
        if (this.log.CALL) {
            this.log.call(this.ME, "Exiting disconnect()");
        }
    }

    public String ping(String qos) throws RemoteException {
        return this.authenticate.ping(qos);
    }
}

