/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.protocol.rmi;

import java.net.MalformedURLException;
import java.rmi.Naming;
import java.rmi.NotBoundException;
import java.rmi.RMISecurityManager;
import java.rmi.Remote;
import java.rmi.RemoteException;
import org.jutils.log.LogChannel;
import org.xmlBlaster.protocol.I_CallbackDriver;
import org.xmlBlaster.protocol.rmi.I_XmlBlasterCallback;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.MsgUnitRaw;
import org.xmlBlaster.util.XmlBlasterException;
import org.xmlBlaster.util.def.ErrorCode;
import org.xmlBlaster.util.plugin.PluginInfo;
import org.xmlBlaster.util.qos.address.CallbackAddress;

public class CallbackRmiDriver
implements I_CallbackDriver {
    private String ME = "CallbackRmiDriver";
    private I_XmlBlasterCallback cb = null;
    private CallbackAddress callbackAddress = null;
    private Global glob = null;
    private LogChannel log = null;

    public String getName() {
        return this.ME;
    }

    public String getProtocolId() {
        return "RMI";
    }

    public String getType() {
        return this.getProtocolId();
    }

    public String getVersion() {
        return "1.0";
    }

    public void init(Global glob, PluginInfo pluginInfo) {
    }

    public String getRawAddress() {
        return this.callbackAddress.getRawAddress();
    }

    public void init(Global glob, CallbackAddress callbackAddress) throws XmlBlasterException {
        this.glob = glob;
        this.log = glob.getLog("rmi");
        if (System.getSecurityManager() == null) {
            System.setSecurityManager(new RMISecurityManager());
            if (this.log.TRACE) {
                this.log.trace(this.ME, "Started RMISecurityManager");
            }
        }
        this.callbackAddress = callbackAddress;
        String addr = callbackAddress.getRawAddress();
        Remote rem = null;
        try {
            rem = Naming.lookup(addr);
        }
        catch (RemoteException e) {
            this.log.error(this.ME, "Can't access callback address ='" + addr + "', no client rmi registry running");
            throw new XmlBlasterException(glob, ErrorCode.RESOURCE_CONFIGURATION_ADDRESS, this.ME, "Can't access callback address ='" + addr + "', no client rmi registry running", e);
        }
        catch (NotBoundException e) {
            this.log.error(this.ME, "The given callback address ='" + addr + "' is not bound to rmi registry: " + e.toString());
            throw new XmlBlasterException(glob, ErrorCode.RESOURCE_CONFIGURATION_ADDRESS, this.ME, "The given callback address '" + addr + "' is not bound to rmi registry", e);
        }
        catch (MalformedURLException e) {
            this.log.error(this.ME, "The given callback address ='" + addr + "' is invalid: " + e.toString());
            throw new XmlBlasterException(glob, ErrorCode.RESOURCE_CONFIGURATION_ADDRESS, this.ME, "The given callback address '" + addr + "' is invalid.", e);
        }
        catch (Throwable e) {
            this.log.error(this.ME, "The given callback address ='" + addr + "' is invalid : " + e.toString());
            throw new XmlBlasterException(glob, ErrorCode.RESOURCE_CONFIGURATION_ADDRESS, this.ME, "The given callback address '" + addr + "' is invalid.", e);
        }
        if (!(rem instanceof I_XmlBlasterCallback)) {
            throw new XmlBlasterException(glob, ErrorCode.RESOURCE_CONFIGURATION_ADDRESS, this.ME, "No callback to '" + addr + "' possible, class needs to implement interface I_XmlBlasterCallback.");
        }
        this.cb = (I_XmlBlasterCallback)rem;
        this.log.info(this.ME, "Accessing client callback reference using given '" + addr + "' string");
    }

    private I_XmlBlasterCallback getCb() throws XmlBlasterException {
        if (this.cb == null) {
            throw new XmlBlasterException(this.glob, ErrorCode.RESOURCE_CONFIGURATION_ADDRESS, this.ME, "No callback to '" + this.callbackAddress.getRawAddress() + "' possible, no connection.");
        }
        return this.cb;
    }

    public final String[] sendUpdate(MsgUnitRaw[] msgArr) throws XmlBlasterException {
        if (msgArr == null || msgArr.length < 1) {
            throw new XmlBlasterException(this.glob, ErrorCode.INTERNAL_ILLEGALARGUMENT, this.ME, "Illegal sendUpdate() argument");
        }
        if (this.log.TRACE) {
            this.log.trace(this.ME, "xmlBlaster.update() to " + this.callbackAddress.getSecretSessionId());
        }
        try {
            return this.getCb().update(this.callbackAddress.getSecretSessionId(), msgArr);
        }
        catch (RemoteException remote) {
            Throwable nested = remote.detail;
            if (nested != null && nested instanceof XmlBlasterException) {
                XmlBlasterException xmlBlasterException = (XmlBlasterException)nested;
                if (xmlBlasterException.isUser()) {
                    throw xmlBlasterException;
                }
                throw new XmlBlasterException(this.glob, ErrorCode.USER_UPDATE_ERROR, this.ME, "RMI Callback of " + msgArr.length + " messages to client [" + this.callbackAddress.getSecretSessionId() + "] failed.", xmlBlasterException);
            }
            throw new XmlBlasterException(this.glob, ErrorCode.COMMUNICATION_NOCONNECTION, this.ME, "RMI Callback of " + msgArr.length + " messages to client [" + this.callbackAddress.getSecretSessionId() + "] failed", remote);
        }
    }

    public void sendUpdateOneway(MsgUnitRaw[] msgArr) throws XmlBlasterException {
        if (msgArr == null || msgArr.length < 1) {
            throw new XmlBlasterException(this.glob, ErrorCode.INTERNAL_ILLEGALARGUMENT, this.ME, "Illegal sendUpdateOneway() argument");
        }
        if (this.log.TRACE) {
            this.log.trace(this.ME, "xmlBlaster.updateOneway() to " + this.callbackAddress.getSecretSessionId());
        }
        try {
            this.getCb().updateOneway(this.callbackAddress.getSecretSessionId(), msgArr);
        }
        catch (Throwable e) {
            throw new XmlBlasterException(this.glob, ErrorCode.COMMUNICATION_NOCONNECTION, this.ME, "RMI oneway callback of message to client [" + this.callbackAddress.getSecretSessionId() + "] failed", e);
        }
    }

    public final String ping(String qos) throws XmlBlasterException {
        try {
            return this.getCb().ping(qos);
        }
        catch (Throwable e) {
            throw new XmlBlasterException(this.glob, ErrorCode.COMMUNICATION_NOCONNECTION, this.ME, "RMI callback ping failed", e);
        }
    }

    public void shutdown() {
        this.cb = null;
        this.callbackAddress = null;
        if (this.log.TRACE) {
            this.log.trace(this.ME, "Shutdown implementation is missing");
        }
    }

    public boolean isAlive() {
        return true;
    }
}

