/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.protocol.rmi;

import java.rmi.AlreadyBoundException;
import java.rmi.Naming;
import java.rmi.NoSuchObjectException;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.server.ExportException;
import java.rmi.server.UnicastRemoteObject;
import org.jutils.log.LogChannel;
import org.xmlBlaster.engine.qos.AddressServer;
import org.xmlBlaster.protocol.I_Authenticate;
import org.xmlBlaster.protocol.I_Driver;
import org.xmlBlaster.protocol.I_XmlBlaster;
import org.xmlBlaster.protocol.rmi.AuthServerImpl;
import org.xmlBlaster.protocol.rmi.XmlBlasterImpl;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.XmlBlasterException;
import org.xmlBlaster.util.XmlBlasterSecurityManager;
import org.xmlBlaster.util.def.ErrorCode;
import org.xmlBlaster.util.plugin.PluginInfo;

public class RmiDriver
implements I_Driver {
    private String ME = "RmiDriver";
    private Global glob = null;
    private LogChannel log = null;
    public static final int DEFAULT_REGISTRY_PORT = 1099;
    private I_Authenticate authenticate = null;
    private I_XmlBlaster xmlBlasterImpl = null;
    private AuthServerImpl authRmiServer = null;
    private String authBindName = null;
    private XmlBlasterImpl xmlBlasterRmiServer = null;
    private String xmlBlasterBindName = null;
    private boolean isActive = false;

    public String getName() {
        return this.ME;
    }

    public String getProtocolId() {
        return "RMI";
    }

    public String getType() {
        return this.getProtocolId();
    }

    public String getVersion() {
        return "1.0";
    }

    public void init(Global glob, PluginInfo pluginInfo) throws XmlBlasterException {
        this.glob = glob;
        this.ME = "RmiDriver" + this.glob.getLogPrefixDashed();
        this.log = glob.getLog("rmi");
        org.xmlBlaster.engine.Global engineGlob = (org.xmlBlaster.engine.Global)glob.getObjectEntry("ServerNodeScope");
        if (engineGlob == null) {
            throw new XmlBlasterException(this.glob, ErrorCode.INTERNAL_UNKNOWN, this.ME + ".init", "could not retreive the ServerNodeScope. Am I really on the server side ?");
        }
        try {
            this.authenticate = engineGlob.getAuthenticate();
            if (this.authenticate == null) {
                throw new XmlBlasterException(this.glob, ErrorCode.INTERNAL_UNKNOWN, this.ME + ".init", "authenticate object is null");
            }
            I_XmlBlaster xmlBlasterImpl = this.authenticate.getXmlBlaster();
            if (xmlBlasterImpl == null) {
                throw new XmlBlasterException(this.glob, ErrorCode.INTERNAL_UNKNOWN, this.ME + ".init", "xmlBlasterImpl object is null");
            }
            this.init(glob, new AddressServer(glob, this.getType(), glob.getId()), this.authenticate, xmlBlasterImpl);
            this.activate();
        }
        catch (XmlBlasterException ex) {
            throw ex;
        }
        catch (Throwable ex) {
            throw new XmlBlasterException(this.glob, ErrorCode.INTERNAL_UNKNOWN, this.ME + ".init", "init. Could'nt initialize the driver.", ex);
        }
    }

    public String getRawAddress() {
        return this.authBindName;
    }

    private synchronized void init(Global glob, AddressServer addressServer, I_Authenticate authenticate, I_XmlBlaster xmlBlasterImpl) throws XmlBlasterException {
        this.authenticate = authenticate;
        this.xmlBlasterImpl = xmlBlasterImpl;
        XmlBlasterSecurityManager.createSecurityManager(glob);
        int registryPort = addressServer.getEnv("registryPort", 1099).getValue();
        String hostname = addressServer.getEnv("hostname", glob.getLocalIP()).getValue();
        try {
            if (registryPort > 0) {
                try {
                    LocateRegistry.createRegistry(registryPort);
                    this.log.info(this.ME, "Started RMI registry on port " + registryPort);
                }
                catch (ExportException e) {
                    try {
                        LocateRegistry.getRegistry(hostname, registryPort);
                        this.log.info(this.ME, "Another rmiregistry is running on port 1099 we will use this one. You could change the port with e.g. '-plugin/rmi/registryPort 1122' to run your own rmiregistry.");
                    }
                    catch (RemoteException e2) {
                        String text = "Port 1099 is already in use, but does not seem to be a rmiregistry. Please can change the port with e.g. -plugin/rmi/registryPortCB=1122 : " + e.toString();
                        this.log.error(this.ME, text);
                        throw new XmlBlasterException(this.ME, text);
                    }
                }
            }
            String prefix = "rmi://";
            this.authBindName = prefix + hostname + ":" + registryPort + "/I_AuthServer";
            this.authBindName = addressServer.getEnv("AuthServerUrl", this.authBindName).getValue();
            this.xmlBlasterBindName = prefix + hostname + ":" + registryPort + "/I_XmlBlaster";
            this.xmlBlasterBindName = addressServer.getEnv("XmlBlasterUrl", this.xmlBlasterBindName).getValue();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new XmlBlasterException("InitRmiFailed", "Could not initialize RMI registry: " + e.toString());
        }
        if (this.log.TRACE) {
            this.log.trace(this.ME, "Initialized RMI server");
        }
    }

    public synchronized void activate() throws XmlBlasterException {
        if (this.log.CALL) {
            this.log.call(this.ME, "Entering activate");
        }
        try {
            this.authRmiServer = new AuthServerImpl(this.glob, this.authenticate, this.xmlBlasterImpl);
            this.xmlBlasterRmiServer = new XmlBlasterImpl(this.glob, this.xmlBlasterImpl);
        }
        catch (RemoteException e) {
            this.log.error(this.ME, e.toString());
            throw new XmlBlasterException("RmiDriverFailed", e.toString());
        }
        this.bindToRegistry();
        this.isActive = true;
        this.log.info(this.ME, "Started successfully RMI driver.");
    }

    public synchronized void deActivate() throws XmlBlasterException {
        if (this.log.CALL) {
            this.log.call(this.ME, "Entering deActivate");
        }
        try {
            if (this.authBindName != null) {
                Naming.unbind(this.authBindName);
            }
            UnicastRemoteObject.unexportObject(this.authRmiServer, true);
        }
        catch (Exception e) {
            this.log.warn(this.ME, "Can't shutdown authentication server: " + e.toString());
        }
        try {
            if (this.xmlBlasterBindName != null) {
                Naming.unbind(this.xmlBlasterBindName);
            }
            UnicastRemoteObject.unexportObject(this.xmlBlasterRmiServer, true);
        }
        catch (Exception e) {
            this.log.warn(this.ME, "Can't shutdown xmlBlaster server: " + e.toString());
        }
        this.isActive = false;
        this.log.info(this.ME, "RMI deactivated, no client access possible.");
    }

    public void shutdown() throws XmlBlasterException {
        if (this.log.TRACE) {
            this.log.trace(this.ME, "Shutting down RMI driver ...");
        }
        if (this.isActive) {
            try {
                this.deActivate();
            }
            catch (XmlBlasterException e) {
                this.log.error(this.ME, e.toString());
            }
        }
        this.authBindName = null;
        this.log.info(this.ME, "RMI driver stopped, naming entries released.");
    }

    private void bindToRegistry() throws XmlBlasterException {
        if (this.log.CALL) {
            this.log.call(this.ME, "bindToRegistry() ...");
        }
        try {
            Naming.bind(this.authBindName, this.authRmiServer);
            this.log.info(this.ME, "Bound authentication RMI server to registry with name '" + this.authBindName + "'");
        }
        catch (AlreadyBoundException e) {
            try {
                Naming.rebind(this.authBindName, this.authRmiServer);
                this.log.warn(this.ME, "Removed another entry while binding authentication RMI server to registry with name '" + this.authBindName + "'");
            }
            catch (Exception e2) {
                if (this.log.TRACE) {
                    this.log.trace(this.ME + ".RmiRegistryFailed", "RMI registry of '" + this.authBindName + "' failed: " + e2.toString());
                }
                throw new XmlBlasterException(this.ME + ".RmiRegistryFailed", "RMI registry of '" + this.authBindName + "' failed: " + e2.toString());
            }
        }
        catch (NoSuchObjectException e) {
            if (this.log.TRACE) {
                this.log.trace(this.ME + ".RmiRegistryFailed", "RMI registry of '" + this.authBindName + "' authRmiServer=" + this.authRmiServer + " failed: " + e.getMessage());
            }
            throw new XmlBlasterException(this.glob, ErrorCode.RESOURCE_CONFIGURATION, this.ME + ".RmiRegistryFailed", "RMI registry of '" + this.authBindName + "' failed, probably another server instance is running already (implementation to handle this is missing): " + e.toString());
        }
        catch (Throwable e) {
            if (this.log.TRACE) {
                this.log.trace(this.ME + ".RmiRegistryFailed", "RMI registry of '" + this.authBindName + "' failed: " + e.getMessage());
            }
            throw new XmlBlasterException(this.glob, ErrorCode.RESOURCE_CONFIGURATION, this.ME + ".RmiRegistryFailed", "RMI registry of '" + this.authBindName + "' failed: ", e);
        }
        try {
            Naming.bind(this.xmlBlasterBindName, this.xmlBlasterRmiServer);
            this.log.info(this.ME, "Bound xmlBlaster RMI server to registry with name '" + this.xmlBlasterBindName + "'");
        }
        catch (AlreadyBoundException e) {
            try {
                Naming.rebind(this.xmlBlasterBindName, this.xmlBlasterRmiServer);
                this.log.warn(this.ME, "Removed another entry while binding xmlBlaster RMI server to registry with name '" + this.xmlBlasterBindName + "'");
            }
            catch (Exception e2) {
                this.log.error(this.ME + ".RmiRegistryFailed", "RMI registry of '" + this.xmlBlasterBindName + "' failed: " + e.toString());
                throw new XmlBlasterException(this.glob, ErrorCode.RESOURCE_CONFIGURATION, this.ME + ".RmiRegistryFailed", "RMI registry of '" + this.xmlBlasterBindName + "' failed: " + e.toString());
            }
        }
        catch (Throwable e) {
            this.log.error(this.ME + ".RmiRegistryFailed", "RMI registry of '" + this.xmlBlasterBindName + "' failed: " + e.toString());
            throw new XmlBlasterException(this.glob, ErrorCode.RESOURCE_CONFIGURATION, this.ME + ".RmiRegistryFailed", "RMI registry of '" + this.xmlBlasterBindName + "' failed", e);
        }
    }

    public String usage() {
        String text = "\n";
        text = text + "RmiDriver options:\n";
        text = text + "   -plugin/rmi/registryPort\n";
        text = text + "                       Specify a port number where rmiregistry listens.\n";
        text = text + "                       Default is port 1099, the port 0 switches this feature off.\n";
        text = text + "   -plugin/rmi/hostname\n";
        text = text + "                       Specify a hostname where rmiregistry runs.\n";
        text = text + "                       Default is the localhost.\n";
        text = text + "\n";
        return text;
    }
}

