/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.protocol.rmi;

import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import org.jutils.log.LogChannel;
import org.jutils.time.StopWatch;
import org.xmlBlaster.protocol.rmi.I_XmlBlaster;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.MsgUnitRaw;
import org.xmlBlaster.util.XmlBlasterException;

public class XmlBlasterImpl
extends UnicastRemoteObject
implements I_XmlBlaster {
    private final String ME = "RMI.XmlBlasterImpl";
    private final LogChannel log;
    private org.xmlBlaster.protocol.I_XmlBlaster blasterNative;

    public XmlBlasterImpl(Global glob, org.xmlBlaster.protocol.I_XmlBlaster blasterNative) throws RemoteException, XmlBlasterException {
        this.log = glob.getLog("rmi");
        if (this.log.CALL) {
            this.log.call("RMI.XmlBlasterImpl", "Entering constructor ...");
        }
        this.blasterNative = blasterNative;
    }

    public String subscribe(String sessionId, String xmlKey_literal, String qos_literal) throws RemoteException, XmlBlasterException {
        if (this.log.CALL) {
            this.log.call("RMI.XmlBlasterImpl", "Entering subscribe() xmlKey=\n" + xmlKey_literal + ") ...");
        }
        StopWatch stop = null;
        if (this.log.TIME) {
            stop = new StopWatch();
        }
        String oid = this.blasterNative.subscribe(sessionId, xmlKey_literal, qos_literal);
        if (this.log.TIME) {
            this.log.time("RMI.XmlBlasterImpl", "Elapsed time in subscribe()" + stop.nice());
        }
        return oid;
    }

    public String[] unSubscribe(String sessionId, String xmlKey_literal, String qos_literal) throws RemoteException, XmlBlasterException {
        if (this.log.CALL) {
            this.log.call("RMI.XmlBlasterImpl", "Entering unSubscribe() xmlKey=\n" + xmlKey_literal + ") ...");
        }
        StopWatch stop = null;
        if (this.log.TIME) {
            stop = new StopWatch();
        }
        String[] retArr = this.blasterNative.unSubscribe(sessionId, xmlKey_literal, qos_literal);
        if (this.log.TIME) {
            this.log.time("RMI.XmlBlasterImpl", "Elapsed time in unSubscribe()" + stop.nice());
        }
        return retArr;
    }

    public String publish(String sessionId, MsgUnitRaw msgUnit) throws RemoteException, XmlBlasterException {
        if (this.log.CALL) {
            this.log.call("RMI.XmlBlasterImpl", "Entering publish() ...");
        }
        String retVal = this.blasterNative.publish(sessionId, msgUnit);
        return retVal;
    }

    public String[] publishArr(String sessionId, MsgUnitRaw[] msgUnitArr) throws RemoteException, XmlBlasterException {
        if (this.log.CALL) {
            this.log.trace("RMI.XmlBlasterImpl", "Entering xmlBlaster.publish() for " + msgUnitArr.length + " Messages");
        }
        if (msgUnitArr.length < 1) {
            if (this.log.TRACE) {
                this.log.trace("RMI.XmlBlasterImpl", "Entering xmlBlaster.publishArr(), nothing to do, zero msgUnits sent");
            }
            return new String[0];
        }
        return this.blasterNative.publishArr(sessionId, msgUnitArr);
    }

    public void publishOneway(String sessionId, MsgUnitRaw[] msgUnitArr) throws RemoteException {
        if (this.log.CALL) {
            this.log.trace("RMI.XmlBlasterImpl", "Entering xmlBlaster.publishOneway() for " + msgUnitArr.length + " Messages");
        }
        if (msgUnitArr.length < 1) {
            if (this.log.TRACE) {
                this.log.trace("RMI.XmlBlasterImpl", "Entering xmlBlaster.publishOneway(), nothing to do, zero msgUnits sent");
            }
            return;
        }
        this.blasterNative.publishOneway(sessionId, msgUnitArr);
    }

    public String[] erase(String sessionId, String xmlKey_literal, String qos_literal) throws RemoteException, XmlBlasterException {
        if (this.log.CALL) {
            this.log.call("RMI.XmlBlasterImpl", "Entering erase() xmlKey=\n" + xmlKey_literal + ") ...");
        }
        String[] retArr = this.blasterNative.erase(sessionId, xmlKey_literal, qos_literal);
        return retArr;
    }

    public MsgUnitRaw[] get(String sessionId, String xmlKey_literal, String qos_literal) throws RemoteException, XmlBlasterException {
        if (this.log.CALL) {
            this.log.call("RMI.XmlBlasterImpl", "Entering get() xmlKey=\n" + xmlKey_literal + ") ...");
        }
        StopWatch stop = null;
        if (this.log.TIME) {
            stop = new StopWatch();
        }
        MsgUnitRaw[] msgUnitArr = this.blasterNative.get(sessionId, xmlKey_literal, qos_literal);
        if (this.log.TIME) {
            this.log.time("RMI.XmlBlasterImpl", "Elapsed time in get()" + stop.nice());
        }
        return msgUnitArr;
    }

    public String ping(String qos) throws RemoteException {
        return this.blasterNative.ping(qos);
    }
}

