/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.protocol.socket;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;

public class ByteArray
extends OutputStream {
    protected byte[] buf;
    protected int count;

    public ByteArray() {
        this(32);
    }

    public ByteArray(int size) {
        if (size < 0) {
            throw new IllegalArgumentException("Negative initial size: " + size);
        }
        this.buf = new byte[size];
    }

    public byte[] toByteArray(int len) {
        byte[] newbuf = new byte[len];
        System.arraycopy(this.buf, this.count, newbuf, 0, len);
        this.count += len;
        return newbuf;
    }

    public byte[] getByteArray() {
        return this.buf;
    }

    public void insert(int index, byte b) {
        if (index < 0 || index >= this.buf.length) {
            throw new IllegalArgumentException("Index is too small or too big: " + index);
        }
        this.buf[index] = b;
    }

    public void insert(int index, byte[] b) {
        if (index < 0 || index + b.length >= this.buf.length) {
            throw new IllegalArgumentException("Index is too small or too big: " + index);
        }
        int ii = 0;
        while (ii < b.length) {
            this.buf[index] = b[ii];
            ++index;
            ++ii;
        }
    }

    public final void write(int b) {
        int newcount = this.count + 1;
        if (newcount > this.buf.length) {
            byte[] newbuf = new byte[Math.max(this.buf.length << 1, newcount)];
            System.arraycopy(this.buf, 0, newbuf, 0, this.count);
            this.buf = newbuf;
        }
        this.buf[this.count] = (byte)b;
        this.count = newcount;
    }

    public final void write(byte[] b, int off, int len) {
        if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return;
        }
        int newcount = this.count + len;
        if (newcount > this.buf.length) {
            byte[] newbuf = new byte[Math.max(this.buf.length << 1, newcount)];
            System.arraycopy(this.buf, 0, newbuf, 0, this.count);
            this.buf = newbuf;
        }
        System.arraycopy(b, off, this.buf, this.count, len);
        this.count = newcount;
    }

    public void writeTo(OutputStream out) throws IOException {
        out.write(this.buf, 0, this.count);
    }

    public void reset() {
        this.count = 0;
    }

    public byte[] toByteArray() {
        byte[] newbuf = new byte[this.count];
        System.arraycopy(this.buf, 0, newbuf, 0, this.count);
        return newbuf;
    }

    public int size() {
        return this.count;
    }

    public String toString() {
        return new String(this.buf, 0, this.count);
    }

    public String toString(String enc) throws UnsupportedEncodingException {
        return new String(this.buf, 0, this.count, enc);
    }

    public void close() throws IOException {
    }
}

