/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.protocol.socket;

import org.jutils.log.LogChannel;
import org.xmlBlaster.protocol.I_CallbackDriver;
import org.xmlBlaster.protocol.socket.HandleClient;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.MsgUnitRaw;
import org.xmlBlaster.util.XmlBlasterException;
import org.xmlBlaster.util.def.ErrorCode;
import org.xmlBlaster.util.plugin.PluginInfo;
import org.xmlBlaster.util.qos.address.CallbackAddress;

public class CallbackSocketDriver
implements I_CallbackDriver {
    private String ME = "CallbackSocketDriver";
    private Global glob = null;
    private LogChannel log;
    private String loginName;
    private HandleClient handler;
    private CallbackAddress callbackAddress;
    private boolean isFirstPing_hack = true;

    public CallbackSocketDriver() {
    }

    public CallbackSocketDriver(String loginName, HandleClient handler) {
        this.loginName = loginName;
        this.ME = this.ME + "-" + this.loginName;
        this.handler = handler;
    }

    public CallbackSocketDriver(String loginName) {
        this.loginName = loginName;
        this.ME = this.ME + "-" + this.loginName;
    }

    public String getName() {
        return this.loginName;
    }

    public String getProtocolId() {
        return "SOCKET";
    }

    public String getType() {
        return this.getProtocolId();
    }

    public String getVersion() {
        return "1.0";
    }

    public void init(Global glob, PluginInfo pluginInfo) {
    }

    public String getRawAddress() {
        return this.callbackAddress.getRawAddress();
    }

    public void init(Global glob, CallbackAddress callbackAddress) throws XmlBlasterException {
        this.glob = glob;
        this.log = glob.getLog("socket");
        this.ME = "CallbackSocketDriver" + this.glob.getLogPrefixDashed();
        if (this.log.CALL) {
            this.log.call(this.ME, "init()");
        }
        this.callbackAddress = callbackAddress;
    }

    public final String[] sendUpdate(MsgUnitRaw[] msgArr) throws XmlBlasterException {
        if (this.handler == null) {
            throw new XmlBlasterException(this.glob, ErrorCode.COMMUNICATION_NOCONNECTION, this.ME, "SOCKET sendUpdate failed");
        }
        return this.handler.sendUpdate(this.callbackAddress.getSecretSessionId(), msgArr, true);
    }

    public void sendUpdateOneway(MsgUnitRaw[] msgArr) throws XmlBlasterException {
        if (this.handler == null) {
            throw new XmlBlasterException(this.glob, ErrorCode.COMMUNICATION_NOCONNECTION, this.ME, "SOCKET sendUpdateOneway failed");
        }
        this.handler.sendUpdate(this.callbackAddress.getSecretSessionId(), msgArr, false);
    }

    public final String ping(String qos) throws XmlBlasterException {
        if (this.isFirstPing_hack) {
            this.isFirstPing_hack = false;
            return "";
        }
        if (this.handler == null) {
            throw new XmlBlasterException(this.glob, ErrorCode.COMMUNICATION_NOCONNECTION, this.ME, "SOCKET callback ping failed");
        }
        try {
            return this.handler.ping(qos);
        }
        catch (Throwable e) {
            throw new XmlBlasterException(this.glob, ErrorCode.COMMUNICATION_NOCONNECTION, this.ME, "SOCKET callback ping failed", e);
        }
    }

    public void shutdown() {
        if (this.log != null && this.log.CALL) {
            this.log.call(this.ME, "shutdown()");
        }
        if (this.handler != null) {
            this.handler.shutdown();
        }
    }

    public boolean isAlive() {
        return this.handler != null;
    }
}

