/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.protocol.socket;

import EDU.oswego.cs.dl.util.concurrent.Latch;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.Socket;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.jutils.log.LogChannel;
import org.xmlBlaster.client.protocol.I_CallbackExtended;
import org.xmlBlaster.protocol.I_XmlBlaster;
import org.xmlBlaster.protocol.socket.ExecutorBase;
import org.xmlBlaster.protocol.socket.Parser;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.I_ResponseListener;
import org.xmlBlaster.util.MsgUnitRaw;
import org.xmlBlaster.util.XmlBlasterException;
import org.xmlBlaster.util.def.ErrorCode;
import org.xmlBlaster.util.def.MethodName;
import org.xmlBlaster.util.qos.address.AddressBase;

public abstract class Executor
implements ExecutorBase {
    private String ME = "SocketExecutor";
    protected Global glob;
    private LogChannel log;
    protected Socket sock;
    protected InputStream iStream;
    protected OutputStream oStream;
    protected String prefix = null;
    protected String sessionId = null;
    protected String loginName = "";
    protected long responseWaitTime = 0L;
    protected long soTimeout = 0L;
    protected long soLingerTimeout = 0L;
    protected I_CallbackExtended cbClient = null;
    protected I_XmlBlaster xmlBlasterImpl = null;
    private final String DUMMY_OBJECT = "";
    private final Set latchSet = new HashSet();
    private AddressBase addressConfig;
    protected final Map responseListenerMap = Collections.synchronizedMap(new HashMap());

    protected void initialize(Global glob, AddressBase addressConfig, Socket sock, I_XmlBlaster xmlBlasterImpl) throws IOException {
        this.glob = glob == null ? Global.instance() : glob;
        this.log = this.glob.getLog("socket");
        this.addressConfig = addressConfig;
        this.sock = sock;
        this.xmlBlasterImpl = xmlBlasterImpl;
        this.oStream = sock.getOutputStream();
        this.iStream = sock.getInputStream();
        this.setResponseWaitTime(addressConfig.getEnv("responseTimeout", 60000L).getValue());
        if (this.log.TRACE) {
            this.log.trace(this.ME, this.addressConfig.getEnvLookupKey("responseTimeout") + "=" + this.responseWaitTime);
        }
        this.setSoTimeout(addressConfig.getEnv("SoTimeout", 0L).getValue());
        this.sock.setSoTimeout((int)this.soTimeout);
        if (this.log.TRACE) {
            this.log.trace(this.ME, this.addressConfig.getEnvLookupKey("SoTimeout") + "=" + this.soTimeout);
        }
        this.setSoLingerTimeout(addressConfig.getEnv("SoLingerTimeout", 60000L).getValue());
        if (this.log.TRACE) {
            this.log.trace(this.ME, this.addressConfig.getEnvLookupKey("SoLingerTimeout") + "=" + this.getSoLingerTimeout());
        }
        if (this.getSoLingerTimeout() > 0L) {
            this.sock.setSoLinger(true, (int)this.soLingerTimeout);
        } else {
            this.sock.setSoLinger(false, 0);
        }
    }

    public final void setResponseWaitTime(long millis) {
        if (millis <= 0L) {
            this.log.warn(this.ME, this.addressConfig.getEnvLookupKey("responseTimeout") + "=" + millis + " is invalid, setting it to " + 60000L + " millis");
            this.responseWaitTime = 60000L;
        }
        this.responseWaitTime = millis;
    }

    public final void setSoTimeout(long millis) {
        if (millis < 0L) {
            this.log.warn(this.ME, this.addressConfig.getEnvLookupKey("SoTimeout") + "=" + millis + " is invalid, is invalid, deactivating timeout");
            this.soTimeout = 0L;
        }
        this.soTimeout = millis;
    }

    public final long getSoTimeout() {
        return this.soTimeout;
    }

    public final void setSoLingerTimeout(long millis) {
        if (millis < 0L) {
            this.log.warn(this.ME, this.addressConfig.getEnvLookupKey("SoLingerTimeout") + "=" + millis + " is invalid, setting it to " + 60000L + " millis");
            this.soLingerTimeout = 60000L;
        }
        this.soLingerTimeout = millis;
    }

    public final long getSoLingerTimeout() {
        return this.soLingerTimeout;
    }

    public final void setCbClient(I_CallbackExtended cbClient) {
        this.cbClient = cbClient;
    }

    public final I_CallbackExtended getCbClient() {
        return this.cbClient;
    }

    public final OutputStream getOutputStream() {
        return this.oStream;
    }

    public final InputStream getInputStream() {
        return this.iStream;
    }

    public void finalize() {
        if (this.log.TRACE) {
            this.log.trace(this.ME, "Garbage Collected");
        }
    }

    public Socket getSocket() throws XmlBlasterException {
        if (this.sock == null) {
            if (this.log.TRACE) {
                this.log.trace(this.ME, "No socket connection available.");
            }
            throw new XmlBlasterException(this.glob, ErrorCode.COMMUNICATION_NOCONNECTION, this.ME, "No plain socket connection available.");
        }
        return this.sock;
    }

    protected final void setLoginName(String loginName) {
        this.loginName = loginName;
        this.prefix = loginName != null && loginName.length() > 0 ? this.loginName + ":" : null;
    }

    public final void addResponseListener(String requestId, I_ResponseListener l) {
        if (requestId == null || l == null) {
            throw new IllegalArgumentException("addResponseListener() with requestId=null");
        }
        this.responseListenerMap.put(requestId, l);
    }

    public final void removeResponseListener(String requestId) {
        if (requestId == null) {
            throw new IllegalArgumentException("removeResponseListener() with requestId=null");
        }
        Map map = this.responseListenerMap;
        synchronized (map) {
            Object o = this.responseListenerMap.remove(requestId);
            if (o == null) {
                this.log.error(this.ME, "removeResponseListener(" + requestId + ") entry not found");
            }
        }
    }

    public final I_ResponseListener getResponseListener(String requestId) {
        if (requestId == null) {
            throw new IllegalArgumentException("getResponseListener() with requestId=null");
        }
        return (I_ResponseListener)this.responseListenerMap.get(requestId);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean receive(Parser receiver) throws XmlBlasterException, IOException {
        if (this.log.TRACE) {
            this.log.trace(this.ME, "Receiving '" + receiver.getTypeStr() + "' message " + receiver.getMethodName() + "(" + receiver.getRequestId() + ")");
        }
        if (receiver.isInvoke()) {
            if (MethodName.PUBLISH_ONEWAY == receiver.getMethodName()) {
                MsgUnitRaw[] arr = receiver.getMessageArr();
                if (arr == null || arr.length < 1) {
                    this.log.error(this.ME, "Invocation of " + receiver.getMethodName() + "() failed, missing arguments");
                    return true;
                }
                this.xmlBlasterImpl.publishOneway(receiver.getSecretSessionId(), arr);
                return true;
            } else if (MethodName.PUBLISH == receiver.getMethodName()) {
                MsgUnitRaw[] arr = receiver.getMessageArr();
                if (arr == null || arr.length < 1) {
                    throw new XmlBlasterException(this.glob, ErrorCode.INTERNAL_ILLEGALARGUMENT, this.ME, "Invocation of " + receiver.getMethodName() + "() failed, missing arguments");
                }
                String[] response = this.xmlBlasterImpl.publishArr(receiver.getSecretSessionId(), arr);
                this.executeResponse(receiver, response);
                return true;
            } else if (MethodName.UPDATE_ONEWAY == receiver.getMethodName()) {
                try {
                    I_CallbackExtended cbClientTmp = this.cbClient;
                    if (cbClientTmp == null) {
                        throw new XmlBlasterException(this.glob, ErrorCode.COMMUNICATION_NOCONNECTION_CALLBACKSERVER_NOTAVAILABLE, this.ME, "The SOCKET callback driver is not created, can't process the remote invocation. Try configuration ' -protocol SOCKET'");
                    }
                    MsgUnitRaw[] arr = receiver.getMessageArr();
                    if (arr == null || arr.length < 1) {
                        this.log.error(this.ME, "Invocation of " + receiver.getMethodName() + "() failed, missing arguments");
                        return true;
                    }
                    cbClientTmp.updateOneway(receiver.getSecretSessionId(), arr);
                    return true;
                }
                catch (XmlBlasterException e) {
                    this.executeException(receiver, e);
                    return true;
                }
                catch (Throwable e) {
                    XmlBlasterException xmlBlasterException = new XmlBlasterException(this.glob, ErrorCode.USER_UPDATE_INTERNALERROR, this.ME, "Invocation of " + receiver.getMethodName() + "() failed, missing arguments", e);
                    this.executeException(receiver, xmlBlasterException);
                    return true;
                }
            } else if (MethodName.UPDATE == receiver.getMethodName()) {
                try {
                    I_CallbackExtended cbClientTmp = this.cbClient;
                    if (cbClientTmp == null) {
                        throw new XmlBlasterException(this.glob, ErrorCode.COMMUNICATION_NOCONNECTION_CALLBACKSERVER_NOTAVAILABLE, this.ME, "No SOCKET callback driver is available, can't process the remote invocation.");
                    }
                    MsgUnitRaw[] arr = receiver.getMessageArr();
                    if (arr == null || arr.length < 1) {
                        throw new XmlBlasterException(this.glob, ErrorCode.USER_UPDATE_INTERNALERROR, this.ME, "Invocation of " + receiver.getMethodName() + "() failed, missing arguments");
                    }
                    String[] response = cbClientTmp.update(receiver.getSecretSessionId(), arr);
                    this.executeResponse(receiver, response);
                    return true;
                }
                catch (XmlBlasterException e) {
                    this.executeException(receiver, e);
                    return true;
                }
                catch (Throwable e) {
                    XmlBlasterException xmlBlasterException = new XmlBlasterException(this.glob, ErrorCode.USER_UPDATE_INTERNALERROR, this.ME, "Invocation of " + receiver.getMethodName() + "() failed, missing arguments", e);
                    this.executeException(receiver, xmlBlasterException);
                    return true;
                }
            } else if (MethodName.GET == receiver.getMethodName()) {
                MsgUnitRaw[] arr = receiver.getMessageArr();
                if (arr == null || arr.length != 1) {
                    throw new XmlBlasterException(this.glob, ErrorCode.INTERNAL_ILLEGALARGUMENT, this.ME, "Invocation of " + receiver.getMethodName() + "() failed, wrong arguments");
                }
                MsgUnitRaw[] response = this.xmlBlasterImpl.get(receiver.getSecretSessionId(), arr[0].getKey(), arr[0].getQos());
                this.executeResponse(receiver, response);
                return true;
            } else if (MethodName.PING == receiver.getMethodName()) {
                MsgUnitRaw[] arr = receiver.getMessageArr();
                if (this.cbClient == null && !this.glob.isServerSide()) {
                    XmlBlasterException xmlBlasterException = new XmlBlasterException(this.glob, ErrorCode.COMMUNICATION_NOCONNECTION_CALLBACKSERVER_NOTAVAILABLE, this.ME, "No SOCKET callback driver is available, can't process the remote invocation.");
                    this.executeException(receiver, xmlBlasterException);
                    return true;
                }
                if (this.xmlBlasterImpl == null) return true;
                String response = this.xmlBlasterImpl.ping(arr.length > 0 ? arr[0].getQos() : "<qos/>");
                this.executeResponse(receiver, response);
                return true;
            } else if (MethodName.SUBSCRIBE == receiver.getMethodName()) {
                MsgUnitRaw[] arr = receiver.getMessageArr();
                if (arr == null || arr.length != 1) {
                    throw new XmlBlasterException(this.glob, ErrorCode.INTERNAL_ILLEGALARGUMENT, this.ME, "Invocation of " + receiver.getMethodName() + "() failed, wrong arguments");
                }
                String response = this.xmlBlasterImpl.subscribe(receiver.getSecretSessionId(), arr[0].getKey(), arr[0].getQos());
                this.executeResponse(receiver, response);
                return true;
            } else if (MethodName.UNSUBSCRIBE == receiver.getMethodName()) {
                MsgUnitRaw[] arr = receiver.getMessageArr();
                if (arr == null || arr.length != 1) {
                    throw new XmlBlasterException(this.glob, ErrorCode.INTERNAL_ILLEGALARGUMENT, this.ME, "Invocation of " + receiver.getMethodName() + "() failed, wrong arguments");
                }
                String[] response = this.xmlBlasterImpl.unSubscribe(receiver.getSecretSessionId(), arr[0].getKey(), arr[0].getQos());
                this.executeResponse(receiver, response);
                return true;
            } else if (MethodName.ERASE == receiver.getMethodName()) {
                MsgUnitRaw[] arr = receiver.getMessageArr();
                if (arr == null || arr.length != 1) {
                    throw new XmlBlasterException(this.glob, ErrorCode.INTERNAL_ILLEGALARGUMENT, this.ME, "Invocation of " + receiver.getMethodName() + "() failed, wrong arguments");
                }
                String[] response = this.xmlBlasterImpl.erase(receiver.getSecretSessionId(), arr[0].getKey(), arr[0].getQos());
                this.executeResponse(receiver, response);
                return true;
            } else {
                if (MethodName.CONNECT == receiver.getMethodName()) {
                    return false;
                }
                if (MethodName.DISCONNECT == receiver.getMethodName()) {
                    return false;
                }
                this.log.info(this.ME, "Ignoring received message '" + receiver.getMethodName() + "' with requestId=" + receiver.getRequestId() + ", nobody is interested in it");
                if (!this.log.DUMP) return true;
                this.log.dump(this.ME, "Ignoring received message, nobody is interested in it:\n>" + receiver.toLiteral() + "<");
            }
            return true;
        }
        I_ResponseListener listener = this.getResponseListener(receiver.getRequestId());
        if (listener == null) {
            this.log.warn(this.ME, "Ignoring received '" + receiver.getMethodName() + "' message id=" + receiver.getRequestId() + ", nobody is interested in it");
            if (!this.log.DUMP) return true;
            this.log.dump(this.ME, "Ignoring received message, nobody is interested in it: >" + receiver.toLiteral() + "<");
            return true;
        }
        this.removeResponseListener(receiver.getRequestId());
        if (receiver.isResponse()) {
            if (receiver.getMethodName().returnsMsgArr()) {
                listener.responseEvent(receiver.getRequestId(), receiver.getMessageArr());
                return true;
            } else if (receiver.getMethodName().returnsStringArr()) {
                listener.responseEvent(receiver.getRequestId(), receiver.getQosArr());
                return true;
            } else {
                if (!receiver.getMethodName().returnsString()) throw new XmlBlasterException(this.glob, ErrorCode.INTERNAL_UNKNOWN, this.ME, "The method " + receiver.getMethodName() + " is not expected in this context");
                listener.responseEvent(receiver.getRequestId(), receiver.getQos());
            }
            return true;
        } else if (receiver.isException()) {
            listener.responseEvent(receiver.getRequestId(), receiver.getException());
            return true;
        } else {
            this.log.error(this.ME, "PANIC: Invalid response message for " + receiver.getMethodName());
            listener.responseEvent(receiver.getRequestId(), new XmlBlasterException(this.glob, ErrorCode.INTERNAL_ILLEGALARGUMENT, this.ME, "Invalid response message '" + receiver.getMethodName()));
        }
        return true;
    }

    public Object execute(Parser parser, boolean expectingResponse) throws XmlBlasterException, IOException {
        Set set;
        Object e3;
        Latch startSignal;
        String requestId = parser.createRequestId(this.prefix);
        if (this.log.TRACE) {
            this.log.trace(this.ME, "Invoking  parser type='" + parser.getTypeStr() + "' message " + parser.getMethodName() + "(requestId=" + requestId + ") expectingResponse=" + expectingResponse);
        }
        final Object[] response = new Object[]{null};
        if (expectingResponse) {
            startSignal = new Latch();
            Set set2 = this.latchSet;
            synchronized (set2) {
                this.latchSet.add(startSignal);
            }
            if (this.sock == null) {
                return null;
            }
            this.addResponseListener(requestId, new I_ResponseListener(){

                public void responseEvent(String reqId, Object responseObj) {
                    if (((Executor)Executor.this).log.TRACE) {
                        Executor.this.log.trace(Executor.this.ME + ".responseEvent()", "RequestId=" + reqId + ": return value arrived ...");
                    }
                    response[0] = responseObj;
                    startSignal.release();
                }
            });
        } else {
            startSignal = null;
        }
        byte[] rawMsg = parser.createRawMsg();
        if (this.log.DUMP) {
            this.log.dump(this.ME, "Sending now : >" + Parser.toLiteral(rawMsg) + "<");
        }
        try {
            OutputStream outputStream = this.oStream;
            synchronized (outputStream) {
                this.oStream.write(rawMsg);
                this.oStream.flush();
            }
        }
        catch (InterruptedIOException e2) {
            String str = "Socket blocked for " + this.sock.getSoTimeout() + " millis, giving up now waiting on " + parser.getMethodName() + "(" + requestId + ") response. You can change it with -dispatch/callback/plugin/socket/responseTimeout <millis>";
            throw new XmlBlasterException(this.glob, ErrorCode.RESOURCE_EXHAUST, this.ME, str);
        }
        if (this.log.DUMP) {
            this.log.dump(this.ME, "Successful sent message: >" + Parser.toLiteral(rawMsg) + "<");
        }
        if (!expectingResponse) {
            return null;
        }
        try {
            boolean awakened = false;
            while (true) {
                try {
                    awakened = startSignal.attempt(this.responseWaitTime);
                }
                catch (InterruptedException e3) {
                    this.log.warn(this.ME, "Waking up (waited on " + parser.getMethodName() + "(" + requestId + ") response): " + e3.toString());
                    continue;
                }
                break;
            }
            if (!awakened) break block30;
            if (this.log.TRACE) {
                this.log.trace(this.ME, "Waking up, got response for " + parser.getMethodName() + "(requestId=" + requestId + ")");
            }
            if (response[0] == null) {
                throw new IOException(this.ME + ": Lost socket connection for " + parser.getMethodName() + "(requestId=" + requestId + ")");
            }
            if (this.log.DUMP) {
                this.log.dump(this.ME, "Response for " + parser.getMethodName() + "(" + requestId + ") is: " + response[0].toString());
            }
            if (response[0] instanceof XmlBlasterException) {
                throw (XmlBlasterException)response[0];
            }
            e3 = response[0];
            Object var10_16 = null;
            set = this.latchSet;
        }
        catch (Throwable throwable) {
            Object var10_17 = null;
            Set set3 = this.latchSet;
            synchronized (set3) {
                this.latchSet.remove(startSignal);
            }
            throw throwable;
        }
        synchronized (set) {
            this.latchSet.remove(startSignal);
        }
        {
            block30: {
                return e3;
            }
            String str = "Timeout of " + this.responseWaitTime + " milliseconds occured when waiting on " + parser.getMethodName() + "(" + requestId + ") response. You can change it with -dispatch/callback/plugin/socket/responseTimeout <millis>";
            this.removeResponseListener(requestId);
            throw new XmlBlasterException(this.glob, ErrorCode.RESOURCE_EXHAUST, this.ME, str);
        }
    }

    public final void freePendingThreads() {
        if (this.log != null && this.log.TRACE) {
            this.log.trace(this.ME, "Freeing " + (this.latchSet == null ? 0 : this.latchSet.size()) + " pending threads (waiting on responses) from their ugly blocking situation");
        }
        if (this.latchSet != null) {
            while (true) {
                Latch l = null;
                Set set = this.latchSet;
                synchronized (set) {
                    Iterator it = this.latchSet.iterator();
                    if (!it.hasNext()) {
                        break;
                    }
                    l = (Latch)it.next();
                    it.remove();
                }
                if (l == null) break;
                l.release();
            }
            Set set = this.latchSet;
            synchronized (set) {
                this.latchSet.clear();
            }
        }
    }

    protected final void executeResponse(Parser receiver, Object response) throws XmlBlasterException, IOException {
        Parser returner = new Parser(this.glob, 82, receiver.getRequestId(), receiver.getMethodName(), receiver.getSecretSessionId());
        if (response instanceof String) {
            returner.addMessage((String)response);
        } else if (response instanceof String[]) {
            returner.addMessage((String[])response);
        } else if (response instanceof MsgUnitRaw[]) {
            returner.addMessage((MsgUnitRaw[])response);
        } else if (response instanceof MsgUnitRaw) {
            returner.addMessage((MsgUnitRaw)response);
        } else {
            throw new XmlBlasterException(this.glob, ErrorCode.INTERNAL_ILLEGALARGUMENT, this.ME, "Invalid response data type " + response.toString());
        }
        OutputStream outputStream = this.oStream;
        synchronized (outputStream) {
            this.oStream.write(returner.createRawMsg());
            this.oStream.flush();
        }
        if (this.log.TRACE) {
            this.log.trace(this.ME, "Successfully sent response for " + receiver.getMethodName() + "(" + receiver.getRequestId() + ")");
        }
        if (this.log.DUMP) {
            this.log.dump(this.ME, "Successful sent response for " + receiver.getMethodName() + "() >" + Parser.toLiteral(returner.createRawMsg()) + "<");
        }
    }

    protected final void executeException(Parser receiver, XmlBlasterException e) throws XmlBlasterException, IOException {
        e.isServerSide(this.glob.isServerSide());
        Parser returner = new Parser(this.glob, 69, receiver.getRequestId(), receiver.getMethodName(), receiver.getSecretSessionId());
        returner.setChecksum(false);
        returner.setCompressed(false);
        returner.addException(e);
        OutputStream outputStream = this.oStream;
        synchronized (outputStream) {
            this.oStream.write(returner.createRawMsg());
            this.oStream.flush();
        }
        if (this.log.TRACE) {
            this.log.trace(this.ME, "Successfully sent exception for " + receiver.getMethodName() + "(" + receiver.getRequestId() + ")");
        }
        if (this.log.DUMP) {
            this.log.dump(this.ME, "Successful sent exception for " + receiver.getMethodName() + "() >" + Parser.toLiteral(returner.createRawMsg()) + "<");
        }
    }
}

