/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.protocol.socket;

import java.io.IOException;
import java.net.Socket;
import java.util.Iterator;
import org.jutils.log.LogChannel;
import org.xmlBlaster.engine.qos.ConnectQosServer;
import org.xmlBlaster.engine.qos.ConnectReturnQosServer;
import org.xmlBlaster.protocol.I_Authenticate;
import org.xmlBlaster.protocol.I_CallbackDriver;
import org.xmlBlaster.protocol.socket.CallbackSocketDriver;
import org.xmlBlaster.protocol.socket.Executor;
import org.xmlBlaster.protocol.socket.Parser;
import org.xmlBlaster.protocol.socket.SocketDriver;
import org.xmlBlaster.protocol.socket.SocketUrl;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.MsgUnitRaw;
import org.xmlBlaster.util.XmlBlasterException;
import org.xmlBlaster.util.def.ErrorCode;
import org.xmlBlaster.util.def.MethodName;
import org.xmlBlaster.util.qos.address.CallbackAddress;

public class HandleClient
extends Executor
implements Runnable {
    private String ME = "SOCKET-HandleClientRequest";
    private final LogChannel log;
    private SocketDriver driver;
    private I_Authenticate authenticate;
    private CallbackSocketDriver callback;
    private boolean running = true;
    private String cbKey = null;

    public HandleClient(Global glob, SocketDriver driver, Socket sock) throws IOException {
        super.initialize(glob, driver.getAddressServer(), sock, driver.getXmlBlaster());
        this.log = glob.getLog("socket");
        this.driver = driver;
        this.authenticate = driver.getAuthenticate();
        Thread t = new Thread((Runnable)this, "XmlBlaster.SOCKET");
        int threadPrio = driver.getAddressServer().getEnv("threadPrio", 5).getValue();
        try {
            t.setPriority(threadPrio);
            if (this.log.TRACE) {
                this.log.trace(this.ME, "-plugin/socket/threadPrio " + threadPrio);
            }
        }
        catch (IllegalArgumentException e) {
            this.log.warn(this.ME, "Your -plugin/socket/threadPrio " + threadPrio + " is out of range, we continue with default setting " + 5);
        }
        t.start();
    }

    public void shutdown() {
        if (this.log.TRACE) {
            this.log.trace(this.ME, "Schutdown cb connection to " + this.loginName + " ...");
        }
        if (this.cbKey != null) {
            this.driver.getGlobal().removeNativeCallbackDriver(this.cbKey);
        }
        this.running = false;
        this.driver.removeClient(this);
        this.closeSocket();
        if (this.sessionId != null) {
            String tmp = this.sessionId;
            this.sessionId = null;
            try {
                if (this.authenticate.sessionExists(this.sessionId)) {
                    this.authenticate.disconnect(tmp, "<qos/>");
                }
            }
            catch (Throwable e) {
                this.log.warn(this.ME, e.toString());
                e.printStackTrace();
            }
        }
        if (this.responseListenerMap.size() > 0) {
            Iterator iterator = this.responseListenerMap.keySet().iterator();
            StringBuffer buf = new StringBuffer(256);
            while (iterator.hasNext()) {
                if (buf.length() > 0) {
                    buf.append(", ");
                }
                String key = (String)iterator.next();
                buf.append(key);
            }
            this.log.warn(this.ME, "There are " + this.responseListenerMap.size() + " messages pending without a response, request IDs are " + buf.toString());
            this.responseListenerMap.clear();
        }
        this.freePendingThreads();
    }

    private synchronized void closeSocket() {
        try {
            if (this.iStream != null) {
                this.iStream.close();
            }
        }
        catch (IOException e) {
            this.log.warn(this.ME + ".shutdown", e.toString());
        }
        try {
            if (this.oStream != null) {
                this.oStream.close();
            }
        }
        catch (IOException e) {
            this.log.warn(this.ME + ".shutdown", e.toString());
        }
        try {
            if (this.sock != null) {
                this.sock.close();
                this.sock = null;
            }
        }
        catch (IOException e) {
            this.log.warn(this.ME + ".shutdown", e.toString());
        }
        if (this.log.TRACE) {
            this.log.trace(this.ME, "Closed socket for '" + this.loginName + "'.");
        }
    }

    public final String[] sendUpdate(String cbSessionId, MsgUnitRaw[] msgArr, boolean expectingResponse) throws XmlBlasterException {
        if (this.log.CALL) {
            this.log.call(this.ME, "Entering update: id=" + cbSessionId + " numSend=" + msgArr.length);
        }
        if (!this.running) {
            throw new XmlBlasterException(this.glob, ErrorCode.COMMUNICATION_NOCONNECTION, this.ME, "update() invocation ignored, we are shutdown.");
        }
        if (msgArr == null || msgArr.length < 1) {
            this.log.error(this.ME + ".InvalidArguments", "The argument of method update() are invalid");
            throw new XmlBlasterException(this.glob, ErrorCode.INTERNAL_ILLEGALARGUMENT, this.ME, "Illegal sendUpdate() argument");
        }
        try {
            Parser parser = new Parser(this.glob, 73, MethodName.UPDATE, cbSessionId);
            parser.addMessage(msgArr);
            if (expectingResponse) {
                Object response = this.execute(parser, true);
                if (this.log.TRACE) {
                    this.log.trace(this.ME, "Got update response " + response.toString());
                }
                return (String[])response;
            }
            this.execute(parser, false);
            return null;
        }
        catch (XmlBlasterException xmlBlasterException) {
            if (xmlBlasterException.isUser()) {
                throw xmlBlasterException;
            }
            if (xmlBlasterException.getErrorCode() == ErrorCode.COMMUNICATION_NOCONNECTION_CALLBACKSERVER_NOTAVAILABLE) {
                throw xmlBlasterException;
            }
            throw new XmlBlasterException(this.glob, ErrorCode.USER_UPDATE_ERROR, this.ME, "SOCKET callback of " + msgArr.length + " messages failed", xmlBlasterException);
        }
        catch (IOException e1) {
            if (this.log.TRACE) {
                this.log.trace(this.ME + ".update", "IO exception: " + e1.toString());
            }
            throw new XmlBlasterException(this.glob, ErrorCode.COMMUNICATION_NOCONNECTION, this.ME, "SOCKET callback of " + msgArr.length + " messages failed", e1);
        }
    }

    public final String ping(String qos) throws XmlBlasterException {
        if (!this.running) {
            throw new XmlBlasterException(this.glob, ErrorCode.COMMUNICATION_NOCONNECTION, this.ME, "ping() invocation ignored, we are shutdown.");
        }
        try {
            String cbSessionId = "";
            Parser parser = new Parser(this.glob, 73, MethodName.PING, cbSessionId);
            parser.addMessage(qos);
            Object response = this.execute(parser, true);
            if (this.log.TRACE) {
                this.log.trace(this.ME, "Got ping response " + response.toString());
            }
            return (String)response;
        }
        catch (Throwable e) {
            throw new XmlBlasterException(this.glob, ErrorCode.COMMUNICATION_NOCONNECTION, this.ME, "SOCKET callback ping failed", e);
        }
    }

    public void run() {
        if (this.log.CALL) {
            this.log.call(this.ME, "Handling client request ...");
        }
        Parser receiver = new Parser(this.glob);
        try {
            if (this.log.TRACE) {
                this.log.trace(this.ME, "Client accepted, coming from host=" + this.sock.getInetAddress().toString() + " port=" + this.sock.getPort());
            }
            while (this.running) {
                try {
                    receiver.parse(this.iStream);
                    if (this.log.TRACE) {
                        this.log.trace(this.ME, "Receiving message " + receiver.getMethodName() + "(" + receiver.getRequestId() + ")");
                    }
                    if (this.log.DUMP) {
                        this.log.dump(this.ME, "Receiving message >" + Parser.toLiteral(receiver.createRawMsg()) + "<");
                    }
                    if (this.receive(receiver)) continue;
                    if (MethodName.CONNECT == receiver.getMethodName()) {
                        ConnectQosServer conQos = new ConnectQosServer(this.driver.getGlobal(), receiver.getQos());
                        this.setLoginName(conQos.getUserId());
                        Thread.currentThread().setName("XmlBlaster.SOCKET.HandleClient-" + conQos.getUserId());
                        this.ME = "SOCKET-HandleClientRequest-" + this.loginName;
                        this.log.info(this.ME, "SOCKET client connected, coming from host=" + this.sock.getInetAddress().toString() + " port=" + this.sock.getPort());
                        CallbackAddress[] cbArr = conQos.getSessionCbQueueProperty().getCallbackAddresses();
                        int ii = 0;
                        while (cbArr != null && ii < cbArr.length) {
                            this.cbKey = cbArr[ii].getType() + cbArr[ii].getRawAddress();
                            SocketUrl cbUrl = new SocketUrl(this.glob, cbArr[ii].getRawAddress());
                            SocketUrl remoteUrl = new SocketUrl(this.glob, this.sock.getInetAddress().getHostName(), this.sock.getPort());
                            if (this.log.TRACE) {
                                this.log.trace(this.ME, "remoteUrl='" + remoteUrl.getUrl() + "' cbUrl='" + cbUrl.getUrl() + "'");
                            }
                            if (this.log.TRACE) {
                                this.log.trace(this.ME, "Tunneling callback messages through same SOCKET to '" + remoteUrl.getUrl() + "'");
                            }
                            this.callback = new CallbackSocketDriver(this.loginName, this);
                            I_CallbackDriver oldCallback = this.driver.getGlobal().getNativeCallbackDriver(this.cbKey);
                            if (oldCallback != null) {
                                this.log.warn(this.ME, "Destroying old callback driver '" + this.cbKey + "' ...");
                                this.driver.getGlobal().removeNativeCallbackDriver(this.cbKey);
                                oldCallback = null;
                            }
                            if (this.log.TRACE) {
                                this.log.trace(this.ME, "run: register new callback driver: '" + this.cbKey + "'");
                            }
                            this.driver.getGlobal().addNativeCallbackDriver(this.cbKey, this.callback);
                            ++ii;
                        }
                        ConnectReturnQosServer retQos = this.authenticate.connect(conQos);
                        this.sessionId = retQos.getSecretSessionId();
                        receiver.setSecretSessionId(retQos.getSecretSessionId());
                        this.executeResponse(receiver, retQos.toXml());
                        continue;
                    }
                    if (MethodName.DISCONNECT != receiver.getMethodName()) continue;
                    this.sessionId = null;
                    this.authenticate.disconnect(receiver.getSecretSessionId(), receiver.getQos());
                    this.shutdown();
                }
                catch (XmlBlasterException e) {
                    if (this.log.TRACE) {
                        this.log.trace(this.ME, "Can't handle message, throwing exception back to client: " + e.toString());
                    }
                    try {
                        this.executeException(receiver, e);
                    }
                    catch (Throwable e2) {
                        this.log.error(this.ME, "Lost connection, can't deliver exception message: " + e.toString() + " Reason is: " + e2.toString());
                        this.shutdown();
                    }
                }
                catch (IOException e) {
                    if (!this.running) continue;
                    if (this.log.TRACE) {
                        this.log.trace(this.ME, "Lost connection to client: " + e.toString());
                    }
                    this.shutdown();
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    this.log.error(this.ME, "Lost connection to client: " + e.toString());
                    this.shutdown();
                }
            }
            Object var9_12 = null;
            this.driver.removeClient(this);
            this.closeSocket();
            if (this.log.TRACE) {
                this.log.trace(this.ME, "Deleted thread for '" + this.loginName + "'.");
            }
        }
        catch (Throwable throwable) {
            Object var9_13 = null;
            this.driver.removeClient(this);
            this.closeSocket();
            if (this.log.TRACE) {
                this.log.trace(this.ME, "Deleted thread for '" + this.loginName + "'.");
            }
            throw throwable;
        }
    }
}

