/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.protocol.socket;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;
import org.jutils.log.LogChannel;
import org.xmlBlaster.protocol.socket.ByteArray;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.MsgUnitRaw;
import org.xmlBlaster.util.XmlBlasterException;
import org.xmlBlaster.util.def.ErrorCode;
import org.xmlBlaster.util.def.MethodName;

public class Parser {
    private static final String ME = "Parser";
    private final Global glob;
    private final LogChannel log;
    public static final int NUM_FIELD_LEN = 10;
    public static final int FLAG_FIELD_LEN = 6;
    public static final int MAX_STRING_LEN = Integer.MAX_VALUE;
    public static final String EMPTY_STRING = "";
    public static final byte CHECKSUM_ADLER_BYTE = 65;
    public static final byte COMPRESSED_GZIP_BYTE = 90;
    public static final byte INVOKE_BYTE = 73;
    public static final byte RESPONSE_BYTE = 82;
    public static final byte EXCEPTION_BYTE = 69;
    public static final byte VERSION_1_BYTE = 49;
    private static final byte[] EMPTY10 = new String("          ").getBytes();
    private static final byte NULL_BYTE = 0;
    private boolean checksum;
    private boolean compressed;
    private byte type;
    private byte byte4;
    private byte byte5;
    private int version;
    private String requestId;
    private MethodName methodName;
    private String sessionId;
    private long lenUnzipped;
    private long checkSumResult;
    private static long counter = 0L;
    private Vector msgVec;
    private Buf buf = new Buf();
    private byte[] first10 = new byte[10];
    static /* synthetic */ Class class$org$xmlBlaster$protocol$socket$Parser;

    public Parser(Global glob) {
        this(glob, 0, null, null, null);
    }

    public Parser(Global glob, byte type, MethodName methodName, String sessionId) {
        this(glob, type, null, methodName, sessionId);
    }

    public Parser(Global glob, byte type, String requestId, MethodName methodName, String sessionId) {
        this.glob = glob;
        this.log = glob.getLog("socket");
        this.msgVec = new Vector();
        this.initialize();
        this.setType(type);
        this.setRequestId(requestId);
        this.setMethodName(methodName);
        this.setSecretSessionId(sessionId);
    }

    public void initialize() {
        this.checksum = false;
        this.compressed = false;
        this.type = (byte)73;
        this.byte4 = 0;
        this.byte5 = 0;
        this.version = 1;
        this.requestId = null;
        this.methodName = null;
        this.sessionId = EMPTY_STRING;
        this.lenUnzipped = -1L;
        this.checkSumResult = -1L;
        this.msgVec.clear();
    }

    public int getNumMessages() {
        return this.msgVec.size();
    }

    public final void setType(byte type) {
        this.type = type;
    }

    public final byte getType() {
        return this.type;
    }

    public final String getTypeStr() {
        if (this.isInvoke()) {
            return "INVOKE";
        }
        if (this.isResponse()) {
            return "RESPONSE";
        }
        if (this.isException()) {
            return "EXCEPTION";
        }
        return "UNKNOWN_TYPE";
    }

    public final boolean isInvoke() {
        return 73 == this.type;
    }

    public final boolean isResponse() {
        return 82 == this.type;
    }

    public final boolean isException() {
        return 69 == this.type;
    }

    public final void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    public final String createRequestId(String prefix) {
        if (this.requestId == null || this.requestId.length() < 1) {
            if (prefix == null) {
                prefix = EMPTY_STRING;
            }
            Class clazz = class$org$xmlBlaster$protocol$socket$Parser == null ? (class$org$xmlBlaster$protocol$socket$Parser = Parser.class$("org.xmlBlaster.protocol.socket.Parser")) : class$org$xmlBlaster$protocol$socket$Parser;
            synchronized (clazz) {
                if (counter >= 0x7FFFFFFFFFFFFFFEL) {
                    counter = 0L;
                }
                this.requestId = prefix + ++counter;
            }
        }
        return this.requestId;
    }

    public final String getRequestId() {
        if (this.requestId == null) {
            throw new IllegalArgumentException("Parser: getRequestId returns null");
        }
        return this.requestId;
    }

    public final void setMethodName(MethodName methodName) {
        this.methodName = methodName;
    }

    public final MethodName getMethodName() {
        return this.methodName;
    }

    public final void setSecretSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    public final String getSecretSessionId() {
        if (this.sessionId == null) {
            return EMPTY_STRING;
        }
        return this.sessionId;
    }

    public final void setChecksum(boolean checksum) {
        if (checksum) {
            this.log.warn(ME, "Checksum for raw socket message is not supported");
            return;
        }
        this.checksum = checksum;
    }

    public final void setCompressed(boolean compressed) {
        if (compressed) {
            this.log.warn(ME, "Compression for raw socket message is not supported");
            return;
        }
        this.compressed = compressed;
    }

    public final void addKeyAndQos(String key, String qos) throws XmlBlasterException {
        if (!this.msgVec.isEmpty()) {
            throw new IllegalArgumentException("Parser.addKeyAndQos() may only be invoked once");
        }
        MsgUnitRaw msg = new MsgUnitRaw(key, null, qos);
        this.msgVec.add(msg);
    }

    public final void addException(XmlBlasterException e) throws XmlBlasterException {
        if (!this.msgVec.isEmpty()) {
            throw new IllegalArgumentException("Parser.addException() may only be invoked once");
        }
        MsgUnitRaw msg = new MsgUnitRaw(e.getMessage(), e.toByteArr(), e.getErrorCodeStr());
        this.msgVec.add(msg);
    }

    public final void addMessage(MsgUnitRaw msg) {
        this.msgVec.add(msg);
    }

    public final void removeMessage(MsgUnitRaw msg) {
        this.msgVec.remove(msg);
    }

    public final void addMessage(MsgUnitRaw[] arr) {
        int ii = 0;
        while (ii < arr.length) {
            this.msgVec.add(arr[ii]);
            ++ii;
        }
    }

    public final void addMessage(String qos) throws XmlBlasterException {
        if (!this.msgVec.isEmpty()) {
            throw new IllegalArgumentException("Parser.addQos() may only be invoked once");
        }
        MsgUnitRaw msg = new MsgUnitRaw(null, null, qos);
        this.msgVec.add(msg);
    }

    public final void addQos(String qos) throws XmlBlasterException {
        this.addMessage(qos);
    }

    public final void addMessage(String[] qos) throws XmlBlasterException {
        if (!this.msgVec.isEmpty()) {
            throw new IllegalArgumentException("Parser.addQos() may only be invoked once");
        }
        int ii = 0;
        while (ii < qos.length) {
            MsgUnitRaw msg = new MsgUnitRaw(null, null, qos[ii]);
            this.msgVec.add(msg);
            ++ii;
        }
    }

    public final void addQos(String[] qos) throws XmlBlasterException {
        this.addMessage(qos);
    }

    public final Vector getMessages() {
        return this.msgVec;
    }

    public final MsgUnitRaw[] getMessageArr() {
        if (this.msgVec.isEmpty()) {
            return new MsgUnitRaw[0];
        }
        MsgUnitRaw[] arr = new MsgUnitRaw[this.msgVec.size()];
        int ii = 0;
        while (ii < this.msgVec.size()) {
            arr[ii] = (MsgUnitRaw)this.msgVec.elementAt(ii);
            ++ii;
        }
        return arr;
    }

    public final String getQos() {
        if (this.msgVec.isEmpty()) {
            return null;
        }
        MsgUnitRaw msg = (MsgUnitRaw)this.msgVec.elementAt(0);
        return msg.getQos();
    }

    public final String[] getQosArr() {
        Vector msgs = this.getMessages();
        String[] strArr = new String[msgs.size()];
        int ii = 0;
        while (ii < strArr.length) {
            strArr[ii] = ((MsgUnitRaw)msgs.elementAt(ii)).getQos();
            ++ii;
        }
        return strArr;
    }

    public final XmlBlasterException getException() {
        if (this.msgVec.isEmpty()) {
            throw new IllegalArgumentException("Parser: getException() is called without having an exception");
        }
        MsgUnitRaw msg = (MsgUnitRaw)this.msgVec.elementAt(0);
        return XmlBlasterException.parseByteArr(this.glob, msg.getContent());
    }

    /*
     * WARNING - void declaration
     */
    public final Buf readOneMsg(InputStream in) throws IOException {
        int lenRead;
        if (this.log.TRACE) {
            this.log.trace(ME, "Entering readOneMsg(), waiting on inputStream");
        }
        int remainLength = 10;
        int msgLength = 0;
        InputStream inputStream = in;
        synchronized (inputStream) {
            int off = 0;
            while ((lenRead = in.read(this.first10, off, remainLength)) != -1) {
                void var3_8;
                if ((remainLength -= var3_8) == 0) break;
                off += var3_8;
            }
            if (lenRead == -1) {
                throw new IOException("Got EOF, lost socket connection");
            }
            try {
                msgLength = Integer.parseInt(new String(this.first10, 0, 10).trim());
            }
            catch (NumberFormatException e) {
                throw new IOException("Format of message header is corrupted '" + new String(this.first10) + "', expected integral value");
            }
            if (this.log.TRACE) {
                this.log.trace(ME, "Got first 10 bytes of total length=" + msgLength);
            }
            if (msgLength == 10) {
                Buf buf = null;
                return buf;
            }
            if (msgLength < 16) {
                throw new IOException("Message format is corrupted, the given message length=" + msgLength + " is invalid");
            }
            if (this.buf.buf == null || this.buf.buf.length != msgLength) {
                this.buf.buf = null;
                this.buf.buf = new byte[msgLength];
                this.buf.offset = 0;
            }
            this.buf.offset = 10;
            remainLength = msgLength - this.buf.offset;
            while ((lenRead = in.read(this.buf.buf, this.buf.offset, remainLength)) != -1) {
                if ((remainLength -= lenRead) == 0) break;
                this.buf.offset += lenRead;
            }
        }
        if (lenRead == -1) {
            throw new IOException("Can't read complete message (" + msgLength + " bytes) from socket, only " + remainLength + " received, message is corrupted");
        }
        if (remainLength != 0) {
            throw new IOException("Internal error, can't read complete message (" + msgLength + " bytes) from socket, only " + remainLength + " received, message is corrupted");
        }
        return this.buf;
    }

    public final void parse(InputStream in) throws IOException, IllegalArgumentException, XmlBlasterException {
        if (this.log.CALL) {
            this.log.call(ME, "Entering parse()");
        }
        this.initialize();
        Buf buf = this.readOneMsg(in);
        if (buf == null) {
            this.setMethodName(MethodName.PING);
            return;
        }
        if (this.log.DUMP) {
            this.log.dump(ME, "Raw message received '" + Parser.toLiteral(buf.buf) + "'");
        }
        boolean bl = this.checksum = buf.buf[10] > 0;
        if (this.checksum) {
            this.log.warn(ME, "Ignoring checksum flag");
        }
        boolean bl2 = this.compressed = buf.buf[11] > 0;
        if (this.compressed) {
            this.log.warn(ME, "Ignoring compress flag");
        }
        this.type = buf.buf[12];
        this.byte4 = buf.buf[13];
        this.byte5 = buf.buf[14];
        this.version = buf.buf[15] - 48;
        if (this.version != 1) {
            this.log.warn(ME, "Ignoring version=" + this.version + " on 1 is supported");
        }
        buf.offset = 16;
        this.requestId = this.toString(buf);
        this.methodName = MethodName.toMethodName(this.toString(buf));
        this.sessionId = this.toString(buf);
        this.lenUnzipped = this.toInt0(buf, -1);
        if (this.lenUnzipped != -1L && this.log.TRACE) {
            this.log.trace(ME, "Ignoring given unzipped message length of size " + this.lenUnzipped);
        }
        String qos = null;
        Object xmlKey = null;
        Object content = null;
        int ii = 0;
        while (ii < Integer.MAX_VALUE) {
            MsgUnitRaw msgUnit;
            qos = this.toString(buf);
            if (buf.offset >= buf.buf.length) {
                if (qos.length() <= 0) break;
                MsgUnitRaw msgUnit2 = new MsgUnitRaw(null, null, qos);
                this.addMessage(msgUnit2);
                break;
            }
            String key = this.toString(buf);
            if (buf.offset >= buf.buf.length) {
                msgUnit = new MsgUnitRaw(key, null, qos);
                this.addMessage(msgUnit);
                break;
            }
            if (this.log.TRACE) {
                this.log.trace(ME, "Getting messageUnit #" + ii);
            }
            msgUnit = new MsgUnitRaw(key, this.toByte(buf), qos);
            this.addMessage(msgUnit);
            if (buf.offset >= buf.buf.length) break;
            ++ii;
        }
        if (this.checksum) {
            this.checkSumResult = this.toLong0(buf, -1L);
        }
        if (buf.offset != buf.buf.length) {
            String str = "Format mismatch, read index=" + buf.offset + " expected message length=" + buf.buf.length + " we need to disconnect the client, can't recover.";
            throw new IOException(str);
        }
        if (this.log.TRACE) {
            this.log.trace(ME, "Leaving parse(), message successfully parsed");
        }
    }

    private long getUserDataLen() {
        long len = 0L;
        int ii = 0;
        while (ii < this.msgVec.size()) {
            MsgUnitRaw unit = (MsgUnitRaw)this.msgVec.elementAt(ii);
            len += unit.size() + 3L;
            String tmp = EMPTY_STRING + unit.getContent().length;
            len += (long)tmp.length();
            ++ii;
        }
        if (len > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Message size is limited to 2147483647 bytes");
        }
        return len;
    }

    public final byte[] createRawMsg() throws XmlBlasterException {
        try {
            long len = this.getUserDataLen() + 500L;
            ByteArray out = new ByteArray((int)len);
            out.write(EMPTY10, 0, EMPTY10.length);
            out.write(this.checksum ? 65 : 0);
            out.write(this.compressed ? 90 : 0);
            out.write(this.type);
            out.write(0);
            out.write(0);
            out.write(49);
            out.write(this.createRequestId(null).getBytes());
            out.write(0);
            out.write(this.getMethodName().getMethodNameBytes());
            out.write(0);
            out.write(this.getSecretSessionId().getBytes());
            out.write(0);
            if (this.lenUnzipped > 0L) {
                out.write(new String(EMPTY_STRING + this.lenUnzipped).getBytes());
            }
            out.write(0);
            int ii = 0;
            while (ii < this.msgVec.size()) {
                MsgUnitRaw unit = (MsgUnitRaw)this.msgVec.elementAt(ii);
                out.write(unit.getQos().getBytes());
                out.write(0);
                out.write(unit.getKey().getBytes());
                out.write(0);
                out.write((EMPTY_STRING + unit.getContent().length).getBytes());
                out.write(0);
                out.write(unit.getContent());
                ++ii;
            }
            if (this.checksum) {
                int pos = out.size();
                out.write(EMPTY10, 0, EMPTY10.length);
                byte[] checkSumResultB = new String(EMPTY_STRING + this.checkSumResult).getBytes();
                out.insert(pos + EMPTY10.length - checkSumResultB.length, checkSumResultB);
            }
            byte[] msgLengthB = new String(EMPTY_STRING + out.size()).getBytes();
            out.insert(EMPTY10.length - msgLengthB.length, msgLengthB);
            return out.toByteArray();
        }
        catch (IOException e) {
            String text = "Creation of message failed.";
            this.log.warn(ME, text + " " + e.toString());
            throw new XmlBlasterException(this.glob, ErrorCode.INTERNAL_UNKNOWN, ME, text, e);
        }
    }

    public final byte[] toByte(Buf buf) throws IOException {
        int len = this.toInt0(buf, 0);
        byte[] b = new byte[len];
        if ((long)len == 0L) {
            return b;
        }
        System.arraycopy(buf.buf, buf.offset, b, 0, len);
        buf.offset += len;
        return b;
    }

    public final long toLong0(Buf buf, long defaultVal) throws IOException {
        String tmp = this.toString(buf).trim();
        if (tmp == null || tmp.length() < 1) {
            return defaultVal;
        }
        try {
            return Long.parseLong(tmp);
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
            this.log.error(ME, "toLong0(" + this.niceAndShort(tmp) + ") " + buf.toLiteral());
            throw new IOException("Format is corrupted '" + this.dump() + "', expected long integral value");
        }
    }

    private final int toInt0(Buf buf, int defaultVal) throws IOException {
        String tmp = this.toString(buf).trim();
        if (tmp == null || tmp.length() < 1) {
            return defaultVal;
        }
        try {
            return Integer.parseInt(tmp.trim());
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
            this.log.error(ME, "toInt0(" + this.niceAndShort(tmp) + ") " + buf.toLiteral());
            throw new IOException("Format is corrupted '" + this.dump() + "', expected integral value");
        }
    }

    private String niceAndShort(String tmp) {
        if (tmp == null) {
            return "null";
        }
        if (tmp.length() > 50) {
            return tmp.substring(0, 50) + " ...";
        }
        return tmp;
    }

    private final String toString(Buf buf) throws IOException {
        int startOffset = buf.offset;
        while (buf.offset < buf.buf.length) {
            if (buf.buf[buf.offset] == 0) {
                if (startOffset == buf.offset) {
                    ++buf.offset;
                    return EMPTY_STRING;
                }
                ++buf.offset;
                return new String(buf.buf, startOffset, buf.offset - startOffset - 1);
            }
            ++buf.offset;
        }
        return new String(buf.buf, startOffset, buf.offset - startOffset);
    }

    public final String dump() {
        StringBuffer buffer = new StringBuffer(256);
        buffer.append("msgLength=" + this.buf.buf.length);
        buffer.append(", checksum=" + this.checksum);
        buffer.append(", compressed=" + this.compressed);
        buffer.append(", type=" + this.type);
        buffer.append(", byte4=" + this.byte4);
        buffer.append(", byte5=" + this.byte5);
        buffer.append(", version=" + this.version);
        buffer.append(", requestId=" + this.requestId);
        buffer.append(", methodName=" + this.methodName);
        buffer.append(", sessionId=" + this.sessionId);
        buffer.append(", lenUnzipped=" + this.lenUnzipped);
        buffer.append(", checkSumResult=" + this.checkSumResult);
        return buffer.toString();
    }

    public final String toLiteral() throws XmlBlasterException {
        return Parser.toLiteral(this.createRawMsg());
    }

    public static final String toLiteral(byte[] arr) {
        StringBuffer buffer = new StringBuffer(arr.length + 10);
        byte[] dummy = new byte[1];
        int ii = 0;
        while (ii < arr.length) {
            if (arr[ii] == 0) {
                buffer.append("*");
            } else {
                dummy[0] = arr[ii];
                buffer.append(new String(dummy));
            }
            ++ii;
        }
        return buffer.toString();
    }

    public static void main(String[] args) {
        try {
            String send;
            String send2;
            MsgUnitRaw msg;
            Parser parser;
            Global glob = new Global(args);
            byte[] rawMsg = null;
            String testName = "Testing qos/key/content";
            System.out.println("\n----------------------\n" + testName);
            try {
                parser = new Parser(glob);
                parser.setType((byte)73);
                parser.setRequestId("7711");
                parser.setMethodName(MethodName.PUBLISH);
                parser.setSecretSessionId("oxf6hZs");
                parser.setChecksum(false);
                parser.setCompressed(false);
                msg = new MsgUnitRaw("<key oid='hello'/>", "Hello world".getBytes(), "<qos></qos>");
                parser.addMessage(msg);
                rawMsg = parser.createRawMsg();
                send2 = Parser.toLiteral(rawMsg);
                System.out.println(testName + ": Created and ready to send: \n|" + send2 + "|");
            }
            catch (XmlBlasterException e) {
                System.out.println(e.getMessage());
            }
            Parser receiver = new Parser(glob);
            ByteArrayInputStream in = new ByteArrayInputStream(rawMsg);
            receiver.parse(in);
            String receive = Parser.toLiteral(receiver.createRawMsg());
            System.out.println("Received: \n|" + receive + "|");
            if (Parser.toLiteral(rawMsg).equals(receive)) {
                System.out.println(testName + ": SUCCESS");
            } else {
                System.out.println(testName + ": FAILURE");
            }
            testName = "Testing many qos/key/content";
            System.out.println("\n----------------------\n" + testName);
            try {
                parser = new Parser(glob);
                parser.setType((byte)73);
                parser.setRequestId("7711");
                parser.setMethodName(MethodName.PUBLISH);
                parser.setSecretSessionId("oxf6hZs");
                parser.setChecksum(false);
                parser.setCompressed(false);
                parser.addMessage(new MsgUnitRaw("<key oid='x1'/>", "Hello1".getBytes(), "<qos/>"));
                parser.addMessage(new MsgUnitRaw("<key oid='x2'/>", "Hello2".getBytes(), "<qos/>"));
                rawMsg = parser.createRawMsg();
                send = Parser.toLiteral(rawMsg);
                System.out.println(testName + ": Created and ready to send: \n|" + send + "|");
            }
            catch (XmlBlasterException e) {
                System.out.println(e.getMessage());
            }
            receiver = new Parser(glob);
            in = new ByteArrayInputStream(rawMsg);
            receiver.parse(in);
            receive = Parser.toLiteral(receiver.createRawMsg());
            System.out.println("Received: \n|" + receive + "|");
            if (Parser.toLiteral(rawMsg).equals(receive)) {
                System.out.println(testName + ": SUCCESS");
            } else {
                System.out.println(testName + ": FAILURE");
            }
            testName = "Testing qos/key";
            System.out.println("\n----------------------\n" + testName);
            parser = new Parser(glob);
            parser.setType((byte)73);
            parser.setRequestId("7711");
            parser.setMethodName(MethodName.GET);
            parser.setSecretSessionId("oxf6hZs");
            parser.setChecksum(false);
            parser.setCompressed(false);
            parser.addKeyAndQos("<key oid='ooo'></key>", "<qos></qos>");
            rawMsg = parser.createRawMsg();
            send = Parser.toLiteral(rawMsg);
            System.out.println(testName + ": Created and ready to send: \n|" + send + "|");
            receiver = new Parser(glob);
            in = new ByteArrayInputStream(rawMsg);
            receiver.parse(in);
            receive = Parser.toLiteral(receiver.createRawMsg());
            System.out.println("Received: \n|" + receive + "|");
            if (Parser.toLiteral(rawMsg).equals(receive)) {
                System.out.println(testName + ": SUCCESS");
            } else {
                System.out.println(testName + ": FAILURE");
            }
            testName = "Testing qos return";
            System.out.println("\n----------------------\n" + testName);
            parser = new Parser(glob);
            parser.setType((byte)82);
            parser.setRequestId("7711");
            parser.setMethodName(MethodName.PUBLISH);
            parser.setSecretSessionId("oxf6hZs");
            parser.setChecksum(false);
            parser.setCompressed(false);
            parser.addQos("<qos/>");
            rawMsg = parser.createRawMsg();
            send = Parser.toLiteral(rawMsg);
            System.out.println(testName + ": Created and ready to send: \n|" + send + "|");
            receiver = new Parser(glob);
            in = new ByteArrayInputStream(rawMsg);
            receiver.parse(in);
            if (receiver.getMessageArr().length != 1) {
                System.out.println(testName + ": FAILURE numMsg=" + receiver.getMessageArr().length);
            }
            receive = Parser.toLiteral(receiver.createRawMsg());
            System.out.println("Received: \n|" + receive + "|");
            if (Parser.toLiteral(rawMsg).equals(receive)) {
                System.out.println(testName + ": SUCCESS");
            } else {
                System.out.println(testName + ": FAILURE rawMsg sent=" + Parser.toLiteral(rawMsg));
            }
            testName = "Testing nothing";
            System.out.println("\n----------------------\n" + testName);
            parser = new Parser(glob);
            parser.setType((byte)73);
            parser.setRequestId("7711");
            parser.setMethodName(MethodName.GET);
            parser.setSecretSessionId("oxf6hZs");
            parser.setChecksum(false);
            parser.setCompressed(false);
            rawMsg = parser.createRawMsg();
            send = Parser.toLiteral(rawMsg);
            System.out.println(testName + ": Created and ready to send: \n|" + send + "|");
            receiver = new Parser(glob);
            in = new ByteArrayInputStream(rawMsg);
            receiver.parse(in);
            if (receiver.getMessageArr().length > 0) {
                System.out.println(testName + ": FAILURE msgLength=" + receiver.getMessageArr().length + " dump=" + receiver.getMessageArr()[0].toXml());
            } else {
                receive = Parser.toLiteral(receiver.createRawMsg());
                System.out.println("Received: \n|" + receive + "|");
                if (Parser.toLiteral(rawMsg).equals(receive)) {
                    System.out.println(testName + ": SUCCESS");
                } else {
                    System.out.println(testName + ": FAILURE");
                }
            }
            testName = "Testing really nothing";
            System.out.println("\n----------------------\n" + testName);
            rawMsg = "        10".getBytes();
            String send3 = Parser.toLiteral(rawMsg);
            System.out.println(testName + ": Created and ready to send: \n|" + send3 + "|");
            receiver = new Parser(glob);
            receiver.setSecretSessionId(null);
            in = new ByteArrayInputStream(rawMsg);
            receiver.parse(in);
            if (receiver.getMessageArr().length > 0) {
                System.out.println(testName + ": FAILURE");
            } else {
                receive = Parser.toLiteral(receiver.createRawMsg());
                System.out.println("Received: \n|" + receive + "|");
                if ("        25**I**11*ping***".equals(receive)) {
                    System.out.println(testName + ": SUCCESS");
                } else {
                    System.out.println(testName + ": FAILURE");
                }
            }
            testName = "Testing XmlBlasterException";
            System.out.println("\n----------------------\n" + testName);
            parser = new Parser(glob);
            parser.setType((byte)69);
            parser.setRequestId("7711");
            parser.setMethodName(MethodName.PUBLISH);
            parser.setSecretSessionId("oxf6hZs");
            parser.setChecksum(false);
            parser.setCompressed(false);
            XmlBlasterException ex = new XmlBlasterException("QueueOverflow", "The destination queue is full");
            parser.addException(ex);
            rawMsg = parser.createRawMsg();
            send2 = Parser.toLiteral(rawMsg);
            System.out.println(testName + ": Created and ready to send: \n|" + send2 + "|");
            receiver = new Parser(glob);
            in = new ByteArrayInputStream(rawMsg);
            receiver.parse(in);
            receive = Parser.toLiteral(receiver.createRawMsg());
            System.out.println("Received: \n|" + receive + "|");
            if (Parser.toLiteral(rawMsg).equals(receive)) {
                System.out.println(testName + ": SUCCESS");
            } else {
                System.out.println(testName + ": FAILURE");
            }
            testName = "Testing qos/key/content return value";
            System.out.println("\n----------------------\n" + testName);
            try {
                parser = new Parser(glob);
                parser.setType((byte)82);
                parser.setRequestId("7711");
                parser.setMethodName(MethodName.GET);
                parser.setChecksum(false);
                parser.setCompressed(false);
                msg = new MsgUnitRaw("<key oid='hello'/>", "Hello world response".getBytes(), "<qos></qos>");
                parser.addMessage(msg);
                rawMsg = parser.createRawMsg();
                send2 = Parser.toLiteral(rawMsg);
                System.out.println(testName + ": Created and ready to send: \n|" + send2 + "|");
            }
            catch (XmlBlasterException e) {
                System.out.println(e.getMessage());
            }
            receiver = new Parser(glob);
            in = new ByteArrayInputStream(rawMsg);
            receiver.parse(in);
            receive = Parser.toLiteral(receiver.createRawMsg());
            System.out.println("Received: \n|" + receive + "|");
            if (Parser.toLiteral(rawMsg).equals(receive)) {
                System.out.println(testName + ": SUCCESS");
            } else {
                System.out.println(testName + ": FAILURE");
            }
            testName = "Testing a QoS return value";
            System.out.println("\n----------------------\n" + testName);
            parser = new Parser(glob);
            parser.setType((byte)82);
            parser.setRequestId("7711");
            parser.setMethodName(MethodName.ERASE);
            parser.setChecksum(false);
            parser.setCompressed(false);
            parser.addQos("<qos><state id='OK'/></qos>");
            rawMsg = parser.createRawMsg();
            send = Parser.toLiteral(rawMsg);
            System.out.println(testName + ": Created and ready to send: \n|" + send + "|");
            receiver = new Parser(glob);
            in = new ByteArrayInputStream(rawMsg);
            receiver.parse(in);
            receive = Parser.toLiteral(receiver.createRawMsg());
            System.out.println("Received: \n|" + receive + "|");
            if (Parser.toLiteral(rawMsg).equals(receive)) {
                System.out.println(testName + ": SUCCESS");
            } else {
                System.out.println(testName + ": FAILURE");
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
            System.err.println(e.toString());
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class Buf {
        byte[] buf;
        int offset;

        private Buf() {
        }

        public String toString() {
            if (this.buf == null) {
                return "null";
            }
            byte[] tmp = new byte[this.buf.length];
            int ii = 0;
            while (ii < this.buf.length) {
                tmp[ii] = this.buf[ii] == 0 ? 42 : this.buf[ii];
                ++ii;
            }
            return new String(tmp);
        }

        public String toLiteral() {
            StringBuffer buffer = new StringBuffer(200);
            int start = 0;
            if (this.offset > 20) {
                start = this.offset - 20;
            }
            buffer.append("Dumping from offset=" + start + ", problemOffset=" + this.offset + " msgLen=" + this.buf.length + ": '");
            byte[] dummy = new byte[1];
            int ii = start;
            while (ii < this.offset + 100 && ii < this.buf.length) {
                if (this.buf[ii] == 0) {
                    buffer.append("*");
                } else {
                    dummy[0] = this.buf[ii];
                    buffer.append(new String(dummy));
                }
                ++ii;
            }
            buffer.append("'");
            if (ii < this.buf.length) {
                buffer.append(" ...");
            }
            return buffer.toString();
        }
    }
}

