/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.protocol.socket;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.Socket;
import java.net.UnknownHostException;
import org.jutils.log.LogChannel;
import org.xmlBlaster.protocol.socket.Executor;
import org.xmlBlaster.protocol.socket.Parser;
import org.xmlBlaster.protocol.socket.SocketUrl;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.MsgUnitRaw;
import org.xmlBlaster.util.XmlBlasterException;
import org.xmlBlaster.util.def.ErrorCode;
import org.xmlBlaster.util.def.MethodName;
import org.xmlBlaster.util.qos.address.CallbackAddress;

public class SocketCbConnection
extends Executor {
    private String ME = "SocketCbConnection";
    private Global glob;
    private LogChannel log;
    private SocketUrl socketUrl;
    protected Socket sock;
    protected InputStream iStream;
    protected OutputStream oStream;
    protected String cbSessionId;
    protected CallbackAddress clientAddress;

    public SocketCbConnection(Global glob) throws XmlBlasterException {
        this.glob = glob == null ? Global.instance() : glob;
        this.log = this.glob.getLog("socket");
        if (this.log.CALL) {
            this.log.call(this.ME, "Entering init()");
        }
    }

    public Socket getSocket() throws XmlBlasterException {
        if (this.sock == null) {
            if (this.log.TRACE) {
                this.log.trace(this.ME, "No socket connection available.");
            }
            throw new XmlBlasterException(this.glob, ErrorCode.COMMUNICATION_NOCONNECTION, this.ME, "No plain SOCKET connection available.");
        }
        return this.sock;
    }

    final Global getGlobal() {
        return this.glob;
    }

    public void connectLowlevel(CallbackAddress callbackAddress) throws XmlBlasterException {
        if (this.isConnected()) {
            return;
        }
        this.clientAddress = callbackAddress;
        this.socketUrl = new SocketUrl(this.glob, this.clientAddress);
        if (this.log.CALL) {
            this.log.call(this.ME, "Entering connectLowlevel(), connection with seperate raw socket to client " + this.socketUrl.getUrl() + " ...");
        }
        try {
            this.sock = new Socket(this.socketUrl.getInetAddress(), this.socketUrl.getPort());
            this.log.info(this.ME, "Created SOCKET client connected to '" + this.socketUrl.getUrl() + "', callback address is " + this.getLocalAddress());
            this.oStream = this.sock.getOutputStream();
            this.iStream = this.sock.getInputStream();
            this.initialize(this.glob, this.clientAddress, this.sock, null);
        }
        catch (UnknownHostException e) {
            String str = "XmlBlaster server host is unknown, '-dispatch/callback/plugin/socket/hostname=<ip>': " + e.toString();
            if (this.log.TRACE) {
                this.log.trace(this.ME + ".constructor", str);
            }
            throw new XmlBlasterException(this.glob, ErrorCode.COMMUNICATION_NOCONNECTION, this.ME, "XmlBlaster server is unknown, '-dispatch/callback/plugin/socket/hostname=<ip>'", e);
        }
        catch (IOException e) {
            String str = "Connection to xmlBlaster server failed: " + e.toString();
            if (this.log.TRACE) {
                this.log.trace(this.ME + ".constructor", str);
            }
            throw new XmlBlasterException(this.glob, ErrorCode.COMMUNICATION_NOCONNECTION, this.ME, str);
        }
        catch (Throwable e) {
            if (!(e instanceof IOException) && !(e instanceof ConnectException)) {
                e.printStackTrace();
            }
            String str = "Socket client connection to '" + this.socketUrl.getUrl() + "' failed, try options '-dispatch/callback/plugin/socket/hostname <ip> -dispatch/callback/plugin/socket/port <port>' and check if the client has established a callback SOCKET server";
            throw new XmlBlasterException(this.glob, ErrorCode.INTERNAL_UNKNOWN, this.ME, str, e);
        }
        if (this.log.TRACE) {
            this.log.trace(this.ME, "Created '" + this.getProtocol() + "' protocol plugin and connect to client side callback server on '" + this.socketUrl.getUrl() + "'");
        }
    }

    public void resetConnection() {
        if (this.log.TRACE) {
            this.log.trace(this.ME, "SocketClient is re-initialized, no connection available");
        }
        try {
            this.shutdown();
        }
        catch (XmlBlasterException ex) {
            this.log.error(this.ME, "disconnect. Could not shutdown properly. " + ex.getMessage());
        }
    }

    public String getLocalAddress() {
        if (this.sock == null) {
            if (this.log.TRACE) {
                this.log.trace(this.ME, "Can't determine xmlBlaster local address, no socket connection available");
            }
            return null;
        }
        return "" + this.sock.getLocalAddress().getHostAddress() + ":" + this.sock.getLocalPort();
    }

    public final String getProtocol() {
        return "SOCKET";
    }

    public void shutdown() throws XmlBlasterException {
        if (this.log.CALL) {
            this.log.call(this.ME, "Entering shutdown of callback server");
        }
        try {
            if (this.iStream != null) {
                this.iStream.close();
                this.iStream = null;
            }
        }
        catch (IOException e) {
            this.log.warn(this.ME + ".shutdown", e.toString());
        }
        try {
            if (this.oStream != null) {
                this.oStream.close();
                this.oStream = null;
            }
        }
        catch (IOException e) {
            this.log.warn(this.ME + ".shutdown", e.toString());
        }
        try {
            if (this.sock != null) {
                this.sock.close();
                this.sock = null;
            }
        }
        catch (IOException e) {
            this.log.warn(this.ME + ".shutdown", e.toString());
        }
    }

    public final boolean isConnected() {
        return this.sock != null;
    }

    public final String[] sendUpdate(String cbSessionId, MsgUnitRaw[] msgArr, boolean expectingResponse) throws XmlBlasterException {
        if (this.log.CALL) {
            this.log.call(this.ME, "Entering update: id=" + cbSessionId);
        }
        if (!this.isConnected()) {
            throw new XmlBlasterException(this.glob, ErrorCode.COMMUNICATION_NOCONNECTION, this.ME, "update() invocation ignored, we are not connected.");
        }
        if (msgArr == null || msgArr.length < 1) {
            this.log.error(this.ME + ".InvalidArguments", "The argument of method update() are invalid");
            throw new XmlBlasterException(this.glob, ErrorCode.INTERNAL_ILLEGALARGUMENT, this.ME, "Illegal sendUpdate() argument");
        }
        try {
            Parser parser = new Parser(this.glob, 73, MethodName.UPDATE, cbSessionId);
            parser.addMessage(msgArr);
            if (expectingResponse) {
                Object response = this.execute(parser, true);
                if (this.log.TRACE) {
                    this.log.trace(this.ME, "Got update response " + response.toString());
                }
                return (String[])response;
            }
            this.execute(parser, false);
            return null;
        }
        catch (XmlBlasterException xmlBlasterException) {
            if (xmlBlasterException.isUser()) {
                throw xmlBlasterException;
            }
            throw new XmlBlasterException(this.glob, ErrorCode.USER_UPDATE_ERROR, this.ME, "SOCKET callback of " + msgArr.length + " messages failed", xmlBlasterException);
        }
        catch (IOException e1) {
            if (this.log.TRACE) {
                this.log.trace(this.ME + ".update", "IO exception: " + e1.toString());
            }
            throw new XmlBlasterException(this.glob, ErrorCode.COMMUNICATION_NOCONNECTION, this.ME, "SOCKET callback of " + msgArr.length + " messages failed", e1);
        }
    }

    public final String ping(String qos) throws XmlBlasterException {
        if (!this.isConnected()) {
            throw new XmlBlasterException(this.glob, ErrorCode.COMMUNICATION_NOCONNECTION, this.ME, "ping() invocation ignored, we are shutdown.");
        }
        try {
            String cbSessionId = "";
            Parser parser = new Parser(this.glob, 73, MethodName.PING, cbSessionId);
            parser.addMessage(qos);
            Object response = this.execute(parser, true);
            return (String)response;
        }
        catch (Throwable e) {
            if (this.log.TRACE) {
                this.log.trace(this.ME + ".ping", "IO exception: " + e.toString());
            }
            throw new XmlBlasterException(this.glob, ErrorCode.COMMUNICATION_NOCONNECTION, this.ME, "SOCKET callback ping failed", e);
        }
    }

    public String toXml() throws XmlBlasterException {
        return this.toXml("");
    }

    public String toXml(String extraOffset) throws XmlBlasterException {
        if (this.sock == null) {
            return "<noConnection />";
        }
        return "<connected/>";
    }
}

