/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.protocol.socket;

import java.io.IOException;
import java.net.BindException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.jutils.log.LogChannel;
import org.xmlBlaster.engine.qos.AddressServer;
import org.xmlBlaster.protocol.I_Authenticate;
import org.xmlBlaster.protocol.I_Driver;
import org.xmlBlaster.protocol.I_XmlBlaster;
import org.xmlBlaster.protocol.socket.HandleClient;
import org.xmlBlaster.protocol.socket.SocketUrl;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.XmlBlasterException;
import org.xmlBlaster.util.def.ErrorCode;
import org.xmlBlaster.util.plugin.PluginInfo;

public class SocketDriver
extends Thread
implements I_Driver {
    private String ME = "SocketDriver";
    private Global glob;
    private LogChannel log;
    private I_Authenticate authenticate;
    private I_XmlBlaster xmlBlasterImpl;
    private SocketUrl socketUrl;
    private ServerSocket listen = null;
    private String serverUrl = null;
    private boolean running = true;
    private boolean listenerReady = false;
    private Set handleClientSet = new HashSet();
    private AddressServer addressServer;

    public SocketDriver() {
        super("XmlBlaster.SocketDriver");
        this.setDaemon(true);
    }

    public String getProtocolId() {
        return "SOCKET";
    }

    public String getType() {
        return this.getProtocolId();
    }

    public String getVersion() {
        return "1.0";
    }

    public void init(Global glob, PluginInfo pluginInfo) throws XmlBlasterException {
        org.xmlBlaster.engine.Global engineGlob = (org.xmlBlaster.engine.Global)glob.getObjectEntry("ServerNodeScope");
        if (engineGlob == null) {
            throw new XmlBlasterException(this.glob, ErrorCode.INTERNAL_UNKNOWN, this.ME + ".init", "could not retreive the ServerNodeScope. Am I really on the server side ?");
        }
        try {
            this.authenticate = engineGlob.getAuthenticate();
            if (this.authenticate == null) {
                throw new XmlBlasterException(this.glob, ErrorCode.INTERNAL_UNKNOWN, this.ME + ".init", "authenticate object is null");
            }
            I_XmlBlaster xmlBlasterImpl = this.authenticate.getXmlBlaster();
            if (xmlBlasterImpl == null) {
                throw new XmlBlasterException(this.glob, ErrorCode.INTERNAL_UNKNOWN, this.ME + ".init", "xmlBlasterImpl object is null");
            }
            this.init(glob, new AddressServer(glob, this.getType(), glob.getId()), this.authenticate, xmlBlasterImpl);
            this.activate();
        }
        catch (XmlBlasterException ex) {
            throw ex;
        }
        catch (Throwable ex) {
            throw new XmlBlasterException(this.glob, ErrorCode.INTERNAL_UNKNOWN, this.ME + ".init", "init. Could'nt initialize the driver.", ex);
        }
    }

    public String getRawAddress() {
        return this.socketUrl.getUrl();
    }

    I_Authenticate getAuthenticate() {
        return this.authenticate;
    }

    I_XmlBlaster getXmlBlaster() {
        return this.xmlBlasterImpl;
    }

    AddressServer getAddressServer() {
        return this.addressServer;
    }

    private synchronized void init(Global glob, AddressServer addressServer, I_Authenticate authenticate, I_XmlBlaster xmlBlasterImpl) throws XmlBlasterException {
        this.glob = glob;
        this.ME = "SocketDriver" + this.glob.getLogPrefixDashed();
        this.log = glob.getLog("socket");
        if (this.log.CALL) {
            this.log.call(this.ME, "Entering init()");
        }
        this.addressServer = addressServer;
        this.authenticate = authenticate;
        this.xmlBlasterImpl = xmlBlasterImpl;
        this.socketUrl = new SocketUrl(glob, this.addressServer);
        if (this.socketUrl.getPort() < 1) {
            this.log.info(this.ME, "Option protocl/socket/port set to " + this.socketUrl.getPort() + ", socket server not started");
            return;
        }
    }

    public synchronized void activate() throws XmlBlasterException {
        if (this.log.CALL) {
            this.log.call(this.ME, "Entering activate");
        }
        this.start();
        while (!this.listenerReady) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public synchronized void deActivate() throws XmlBlasterException {
        if (this.log.CALL) {
            this.log.call(this.ME, "Entering deActivate");
        }
        this.running = false;
        boolean closeHack = true;
        if (this.listen != null && closeHack) {
            try {
                Socket socket = new Socket(this.listen.getInetAddress(), this.socketUrl.getPort());
                socket.close();
            }
            catch (IOException e) {
                this.log.warn(this.ME, "shutdown problem: " + e.toString());
            }
        }
        try {
            if (this.listen != null) {
                this.listen.close();
                this.listen = null;
            }
        }
        catch (IOException e) {
            this.log.warn(this.ME, "shutdown problem: " + e.toString());
        }
        while (true) {
            HandleClient h = null;
            Set set = this.handleClientSet;
            synchronized (set) {
                Iterator it = this.handleClientSet.iterator();
                if (!it.hasNext()) {
                    break;
                }
                h = (HandleClient)it.next();
                it.remove();
            }
            if (h == null) break;
            h.shutdown();
        }
        Set set = this.handleClientSet;
        synchronized (set) {
            this.handleClientSet.clear();
        }
    }

    final void removeClient(HandleClient h) {
        Set set = this.handleClientSet;
        synchronized (set) {
            this.handleClientSet.remove(h);
        }
    }

    final Global getGlobal() {
        return this.glob;
    }

    /*
     * Loose catch block
     */
    public void run() {
        block23: {
            int backlog = this.addressServer.getEnv("backlog", 50).getValue();
            if (this.log.TRACE) {
                this.log.trace(this.ME, this.addressServer.getEnvLookupKey("backlog") + "=" + backlog);
            }
            this.listen = new ServerSocket(this.socketUrl.getPort(), backlog, this.socketUrl.getInetAddress());
            this.log.info(this.ME, "Started successfully socket driver on '" + this.socketUrl.getUrl() + "'");
            this.listenerReady = true;
            while (this.running) {
                Socket accept = this.listen.accept();
                if (!this.running) {
                    this.log.info(this.ME, "Closing server '" + this.socketUrl.getUrl() + "'");
                    break;
                }
                HandleClient hh = new HandleClient(this.glob, this, accept);
                Set set = this.handleClientSet;
                synchronized (set) {
                    this.handleClientSet.add(hh);
                }
            }
            Object var7_11 = null;
            this.listenerReady = true;
            if (this.listen == null) break block23;
            try {
                this.listen.close();
            }
            catch (IOException e2) {
                this.log.warn(this.ME, "listen.close()" + e2.toString());
            }
            this.listen = null;
            {
                break block23;
                catch (UnknownHostException e) {
                    this.log.error(this.ME, "Socket server problem, IP address '" + this.socketUrl.getHostname() + "' is invalid: " + e.toString());
                    Object var7_12 = null;
                    this.listenerReady = true;
                    if (this.listen == null) break block23;
                    try {
                        this.listen.close();
                    }
                    catch (IOException e2) {
                        this.log.warn(this.ME, "listen.close()" + e2.toString());
                    }
                    this.listen = null;
                    break block23;
                }
                catch (BindException e) {
                    this.log.error(this.ME, "Socket server problem '" + this.socketUrl.getUrl() + "', the port " + this.socketUrl.getPort() + " is not available: " + e.toString());
                    Object var7_13 = null;
                    this.listenerReady = true;
                    if (this.listen == null) break block23;
                    try {
                        this.listen.close();
                    }
                    catch (IOException e2) {
                        this.log.warn(this.ME, "listen.close()" + e2.toString());
                    }
                    this.listen = null;
                    break block23;
                }
                catch (SocketException e) {
                    this.log.info(this.ME, "Socket '" + this.socketUrl.getUrl() + "' closed successfully: " + e.toString());
                    Object var7_14 = null;
                    this.listenerReady = true;
                    if (this.listen == null) break block23;
                    try {
                        this.listen.close();
                    }
                    catch (IOException e2) {
                        this.log.warn(this.ME, "listen.close()" + e2.toString());
                    }
                    this.listen = null;
                    break block23;
                }
                catch (IOException e) {
                    this.log.error(this.ME, "Socket server problem on '" + this.socketUrl.getUrl() + "': " + e.toString());
                    Object var7_15 = null;
                    this.listenerReady = true;
                    if (this.listen == null) break block23;
                    try {
                        this.listen.close();
                    }
                    catch (IOException e2) {
                        this.log.warn(this.ME, "listen.close()" + e2.toString());
                    }
                    this.listen = null;
                    break block23;
                }
                catch (Throwable e) {
                    this.log.error(this.ME, "Socket server problem on '" + this.socketUrl.getUrl() + "': " + e.toString());
                    e.printStackTrace();
                    Object var7_16 = null;
                    this.listenerReady = true;
                    if (this.listen == null) break block23;
                    try {
                        this.listen.close();
                    }
                    catch (IOException e2) {
                        this.log.warn(this.ME, "listen.close()" + e2.toString());
                    }
                    this.listen = null;
                }
            }
            catch (Throwable throwable) {
                Object var7_17 = null;
                this.listenerReady = true;
                if (this.listen != null) {
                    try {
                        this.listen.close();
                    }
                    catch (IOException e2) {
                        this.log.warn(this.ME, "listen.close()" + e2.toString());
                    }
                    this.listen = null;
                }
                throw throwable;
            }
        }
    }

    public void shutdown() throws XmlBlasterException {
        if (this.log.CALL) {
            this.log.call(this.ME, "Entering shutdown");
        }
        try {
            this.deActivate();
        }
        catch (XmlBlasterException e) {
            this.log.error(this.ME, e.toString());
        }
        this.log.info(this.ME, "Socket driver stopped, all resources released.");
    }

    public String usage() {
        String text = "\n";
        text = text + "SocketDriver options:\n";
        text = text + "   -plugin/socket/port\n";
        text = text + "                       The SOCKET server port [7607].\n";
        text = text + "   -plugin/socket/hostname\n";
        text = text + "                       Specify a hostname where the SOCKET server runs.\n";
        text = text + "                       Default is the localhost.\n";
        text = text + "   -plugin/socket/SoTimeout\n";
        text = text + "                       How long may a socket read block in msec [0] (0 is forever).\n";
        text = text + "   -plugin/socket/responseTimeout\n";
        text = text + "                       Max wait for the method return value/exception [60000] msec.\n";
        text = text + "   -plugin/socket/backlog\n";
        text = text + "                       Queue size for incoming connection request [50].\n";
        text = text + "   -plugin/socket/threadPrio\n";
        text = text + "                       The priority 1=min - 10=max of the listener thread [5].\n";
        text = text + "   -dump[socket]       true switches on detailed SOCKET debugging [false].\n";
        text = text + "\n";
        return text;
    }
}

