/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.protocol.xmlrpc;

import org.jutils.log.LogChannel;
import org.jutils.text.StringHelper;
import org.jutils.time.StopWatch;
import org.xmlBlaster.authentication.plugins.I_SecurityQos;
import org.xmlBlaster.engine.qos.ConnectQosServer;
import org.xmlBlaster.engine.qos.ConnectReturnQosServer;
import org.xmlBlaster.engine.qos.DisconnectQosServer;
import org.xmlBlaster.protocol.I_Authenticate;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.XmlBlasterException;

public class AuthenticateImpl {
    private final String ME = "XmlRpc.AuthenticateImpl";
    private final Global glob;
    private LogChannel log;
    private final I_Authenticate authenticate;

    public AuthenticateImpl(Global glob, I_Authenticate authenticate) throws XmlBlasterException {
        this.glob = glob;
        this.log = glob.getLog("xmlrpc");
        if (this.log.CALL) {
            this.log.call("XmlRpc.AuthenticateImpl", "Entering constructor ...");
        }
        this.authenticate = authenticate;
    }

    public String login(String loginName, String passwd, String qos_literal, String sessionId) throws XmlBlasterException {
        ConnectQosServer connectQos;
        I_SecurityQos securityQos;
        if (this.log.CALL) {
            this.log.call("XmlRpc.AuthenticateImpl", "Entering login() ...");
        }
        if (this.log.DUMP) {
            this.log.dump("XmlRpc.AuthenticateImpl", qos_literal);
        }
        if (loginName == null || passwd == null || qos_literal == null) {
            this.log.error("XmlRpc.AuthenticateImplInvalidArguments", "login failed: please use no null arguments for login()");
            throw new XmlBlasterException("LoginFailed.InvalidArguments", "login failed: please use no null arguments for login()");
        }
        StopWatch stop = null;
        if (this.log.TIME) {
            stop = new StopWatch();
        }
        if ((securityQos = (connectQos = new ConnectQosServer(this.glob, qos_literal)).getSecurityQos()) == null) {
            connectQos.loadClientPlugin(null, null, loginName, passwd);
        } else {
            securityQos.setUserId(loginName);
            securityQos.setCredential(passwd);
            if (this.log.TRACE) {
                this.log.trace("XmlRpc.AuthenticateImpl", "login() method uses supplied loginName=" + loginName + " and password");
            }
        }
        ConnectReturnQosServer returnQos = this.authenticate.connect(connectQos);
        if (this.log.TIME) {
            this.log.time("XmlRpc.AuthenticateImpl", "Elapsed time in login()" + stop.nice());
        }
        return returnQos.getSecretSessionId();
    }

    public String logout(String sessionId) throws XmlBlasterException {
        if (this.log.CALL) {
            this.log.call("XmlRpc.AuthenticateImpl", "Entering logout(sessionId=" + sessionId + ")");
        }
        this.authenticate.disconnect(sessionId, new DisconnectQosServer(this.glob).toXml());
        return "<qos><state id='OK'/></qos>";
    }

    public String connect(String qos_literal) throws XmlBlasterException {
        String returnValue = null;
        String returnValueStripped = null;
        if (this.log.CALL) {
            this.log.call("XmlRpc.AuthenticateImpl", "Entering connect(qos=" + qos_literal + ")");
        }
        StopWatch stop = null;
        if (this.log.TIME) {
            stop = new StopWatch();
        }
        returnValue = this.authenticate.connect(qos_literal);
        returnValueStripped = StringHelper.replaceAll(returnValue, "<![CDATA[", "");
        if (!(returnValueStripped = StringHelper.replaceAll(returnValueStripped, "]]>", "")).equals(returnValue)) {
            this.log.trace("XmlRpc.AuthenticateImpl", "Stripped CDATA tags surrounding security credentials, XMLRPC does not like it (Helma does not escape ']]>'). This shouldn't be a problem as long as your credentials doesn't contain '<'");
        }
        if (this.log.TIME) {
            this.log.time("XmlRpc.AuthenticateImpl", "Elapsed time in connect()" + stop.nice());
        }
        return returnValueStripped;
    }

    public String disconnect(String sessionId, String qos_literal) throws XmlBlasterException {
        if (this.log.CALL) {
            this.log.call("XmlRpc.AuthenticateImpl", "Entering logout()");
        }
        this.authenticate.disconnect(sessionId, qos_literal);
        if (this.log.CALL) {
            this.log.call("XmlRpc.AuthenticateImpl", "Exiting logout()");
        }
        return "<qos><state id='OK'/></qos>";
    }

    public String ping(String qos) {
        return this.authenticate.ping(qos);
    }
}

