/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.protocol.xmlrpc;

import java.io.IOException;
import java.util.Vector;
import org.apache.xmlrpc.XmlRpcClient;
import org.apache.xmlrpc.XmlRpcException;
import org.jutils.log.LogChannel;
import org.xmlBlaster.client.protocol.xmlrpc.XmlRpcConnection;
import org.xmlBlaster.protocol.I_CallbackDriver;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.MsgUnitRaw;
import org.xmlBlaster.util.XmlBlasterException;
import org.xmlBlaster.util.def.ErrorCode;
import org.xmlBlaster.util.plugin.PluginInfo;
import org.xmlBlaster.util.qos.address.CallbackAddress;

public class CallbackXmlRpcDriver
implements I_CallbackDriver {
    private String ME = "CallbackXmlRpcDriver";
    private Global glob = null;
    private LogChannel log;
    private CallbackAddress callbackAddress = null;
    private XmlRpcClient xmlRpcClient = null;

    public String getName() {
        return this.ME;
    }

    public String getProtocolId() {
        return "XMLRPC";
    }

    public String getType() {
        return this.getProtocolId();
    }

    public String getVersion() {
        return "1.0";
    }

    public void init(Global glob, PluginInfo pluginInfo) {
    }

    public String getRawAddress() {
        return this.callbackAddress.getRawAddress();
    }

    public void init(Global glob, CallbackAddress callbackAddress) throws XmlBlasterException {
        this.glob = glob;
        this.log = glob.getLog("xmlrpc");
        this.callbackAddress = callbackAddress;
        try {
            this.xmlRpcClient = new XmlRpcClient(callbackAddress.getRawAddress());
            if (this.log.TRACE) {
                this.log.trace(this.ME, "Accessing client callback web server using given url=" + callbackAddress.getRawAddress());
            }
        }
        catch (IOException ex1) {
            throw new XmlBlasterException(glob, ErrorCode.COMMUNICATION_NOCONNECTION, this.ME, "init() failed", ex1);
        }
    }

    public final String[] sendUpdate(MsgUnitRaw[] msgArr) throws XmlBlasterException {
        if (msgArr == null || msgArr.length < 1) {
            throw new XmlBlasterException(this.glob, ErrorCode.INTERNAL_ILLEGALARGUMENT, this.ME, "Illegal update argument");
        }
        try {
            String[] retVal = new String[msgArr.length];
            int ii = 0;
            while (ii < msgArr.length) {
                Vector<Object> args = new Vector<Object>();
                MsgUnitRaw msgUnit = msgArr[ii];
                args.addElement(this.callbackAddress.getSecretSessionId());
                args.addElement(msgUnit.getKey());
                args.addElement(msgUnit.getContent());
                args.addElement(msgUnit.getQos());
                if (this.log.TRACE) {
                    this.log.trace(this.ME, "Send an update to the client ...");
                }
                retVal[ii] = (String)this.xmlRpcClient.execute("update", args);
                if (this.log.TRACE) {
                    this.log.trace(this.ME, "Successfully sent message update to '" + this.callbackAddress.getSecretSessionId() + "'");
                }
                ++ii;
            }
            return retVal;
        }
        catch (XmlRpcException ex) {
            XmlBlasterException e = XmlRpcConnection.extractXmlBlasterException(this.glob, ex);
            String str = "Sending message to " + (this.callbackAddress != null ? this.callbackAddress.getRawAddress() : "?") + " failed in client: " + ex.toString();
            if (this.log.TRACE) {
                this.log.trace(this.ME + ".sendUpdate", str);
            }
            throw new XmlBlasterException(this.glob, ErrorCode.USER_UPDATE_ERROR, this.ME, "CallbackFailed", e);
        }
        catch (Throwable e) {
            String str = "Sending message to " + (this.callbackAddress != null ? this.callbackAddress.getRawAddress() : "?") + " failed: " + e.toString();
            if (this.log.TRACE) {
                this.log.trace(this.ME + ".sendUpdate", str);
            }
            e.printStackTrace();
            throw new XmlBlasterException(this.glob, ErrorCode.COMMUNICATION_NOCONNECTION, this.ME, "CallbackFailed", e);
        }
    }

    public void sendUpdateOneway(MsgUnitRaw[] msgArr) throws XmlBlasterException {
        if (msgArr == null || msgArr.length < 1) {
            throw new XmlBlasterException(this.glob, ErrorCode.INTERNAL_ILLEGALARGUMENT, this.ME, "Illegal sendUpdateOneway() argument");
        }
        try {
            int ii = 0;
            while (ii < msgArr.length) {
                Vector<Object> args = new Vector<Object>();
                MsgUnitRaw msgUnit = msgArr[ii];
                args.addElement(this.callbackAddress.getSecretSessionId());
                args.addElement(msgUnit.getKey());
                args.addElement(msgUnit.getContent());
                args.addElement(msgUnit.getQos());
                if (this.log.TRACE) {
                    this.log.trace(this.ME, "Send an updateOneway to the client ...");
                }
                this.xmlRpcClient.execute("updateOneway", args);
                if (this.log.TRACE) {
                    this.log.trace(this.ME, "Successfully sent message update to '" + this.callbackAddress.getSecretSessionId() + "'");
                }
                ++ii;
            }
        }
        catch (XmlRpcException ex) {
            XmlBlasterException e = XmlRpcConnection.extractXmlBlasterException(this.glob, ex);
            String str = "Sending oneway message to " + this.callbackAddress.getRawAddress() + " failed in client: " + ex.toString();
            if (this.log.TRACE) {
                this.log.trace(this.ME + ".sendUpdateOneway", str);
            }
            throw new XmlBlasterException(this.glob, ErrorCode.USER_UPDATE_ERROR, this.ME, "CallbackFailed", e);
        }
        catch (Throwable e) {
            String str = "Sending oneway message to " + this.callbackAddress.getRawAddress() + " failed: " + e.toString();
            if (this.log.TRACE) {
                this.log.trace(this.ME + ".sendUpdateOneway", str);
            }
            throw new XmlBlasterException(this.glob, ErrorCode.COMMUNICATION_NOCONNECTION, this.ME, "CallbackFailed", e);
        }
    }

    public final String ping(String qos) throws XmlBlasterException {
        try {
            Vector<String> args = new Vector<String>();
            args.addElement("");
            return (String)this.xmlRpcClient.execute("ping", args);
        }
        catch (XmlRpcException ex) {
            XmlBlasterException e = XmlRpcConnection.extractXmlBlasterException(this.glob, ex);
            throw new XmlBlasterException(this.glob, ErrorCode.USER_UPDATE_ERROR, this.ME, "XmlRpc callback ping - got exception from client", e);
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw new XmlBlasterException(this.glob, ErrorCode.COMMUNICATION_NOCONNECTION, this.ME, "XmlRpc callback ping failed", e);
        }
    }

    public void shutdown() {
        this.callbackAddress = null;
        this.xmlRpcClient = null;
        if (this.log.TRACE) {
            this.log.trace(this.ME, "Shutdown implementation is missing");
        }
    }

    public boolean isAlive() {
        return true;
    }
}

