/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.protocol.xmlrpc;

import java.util.Vector;
import org.jutils.log.LogChannel;
import org.jutils.time.StopWatch;
import org.xmlBlaster.protocol.I_XmlBlaster;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.MsgUnitRaw;
import org.xmlBlaster.util.XmlBlasterException;
import org.xmlBlaster.util.protocol.ProtoConverter;

public class XmlBlasterImpl {
    private final String ME = "XmlRpc.XmlBlasterImpl";
    private LogChannel log;
    private I_XmlBlaster blasterNative;

    public XmlBlasterImpl(Global glob, I_XmlBlaster blasterNative) throws XmlBlasterException {
        this.log = glob.getLog("xmlrpc");
        if (this.log.CALL) {
            this.log.call("XmlRpc.XmlBlasterImpl", "Entering constructor ...");
        }
        this.blasterNative = blasterNative;
    }

    public String subscribe(String sessionId, String xmlKey_literal, String qos_literal) throws XmlBlasterException {
        if (this.log.CALL) {
            this.log.call("XmlRpc.XmlBlasterImpl", "Entering subscribe() xmlKey=\n" + xmlKey_literal + ") ...");
        }
        StopWatch stop = null;
        if (this.log.TIME) {
            stop = new StopWatch();
        }
        String oid = this.blasterNative.subscribe(sessionId, xmlKey_literal, qos_literal);
        if (this.log.TIME) {
            this.log.time("XmlRpc.XmlBlasterImpl", "Elapsed time in subscribe()" + stop.nice());
        }
        return oid;
    }

    public Vector unSubscribe(String sessionId, String xmlKey_literal, String qos_literal) throws XmlBlasterException {
        if (this.log.CALL) {
            this.log.call("XmlRpc.XmlBlasterImpl", "Entering unSubscribe() xmlKey=\n" + xmlKey_literal + ") ...");
        }
        StopWatch stop = null;
        if (this.log.TIME) {
            stop = new StopWatch();
        }
        String[] retArr = this.blasterNative.unSubscribe(sessionId, xmlKey_literal, qos_literal);
        if (this.log.TIME) {
            this.log.time("XmlRpc.XmlBlasterImpl", "Elapsed time in unSubscribe()" + stop.nice());
        }
        return ProtoConverter.stringArray2Vector(retArr);
    }

    public String publish(String sessionId, String xmlKey_literal, byte[] content, String publishQos_literal) throws XmlBlasterException {
        if (this.log.CALL) {
            this.log.call("XmlRpc.XmlBlasterImpl", "Entering publish() ...");
        }
        MsgUnitRaw msgUnit = new MsgUnitRaw(xmlKey_literal, content, publishQos_literal);
        return this.blasterNative.publish(sessionId, msgUnit);
    }

    public String publish(String sessionId, String xmlKey_literal, String content, String publishQos_literal) throws XmlBlasterException {
        if (this.log.CALL) {
            this.log.call("XmlRpc.XmlBlasterImpl", "Entering publish() ....");
        }
        MsgUnitRaw msgUnit = new MsgUnitRaw(xmlKey_literal, content.getBytes(), publishQos_literal);
        String retVal = this.blasterNative.publish(sessionId, msgUnit);
        return retVal;
    }

    public String publish(String sessionId, Vector msgUnitWrap) throws XmlBlasterException {
        if (this.log.CALL) {
            this.log.call("XmlRpc.XmlBlasterImpl", "Entering publish() ...");
        }
        MsgUnitRaw msgUnit = ProtoConverter.vector2MsgUnitRaw(msgUnitWrap);
        String retVal = this.blasterNative.publish(sessionId, msgUnit);
        return retVal;
    }

    public Vector publishArr(String sessionId, Vector msgUnitArrWrap) throws XmlBlasterException {
        int arrayLength;
        if (this.log.CALL) {
            this.log.call("XmlRpc.XmlBlasterImpl", "Entering publish() ...");
        }
        if ((arrayLength = msgUnitArrWrap.size()) < 1) {
            if (this.log.TRACE) {
                this.log.trace("XmlRpc.XmlBlasterImpl", "Entering xmlBlaster.publish(), nothing to do, zero msgUnits sent");
            }
            return new Vector();
        }
        try {
            MsgUnitRaw[] msgUnitArr = ProtoConverter.vector2MsgUnitRawArray(msgUnitArrWrap);
            String[] strArr = this.blasterNative.publishArr(sessionId, msgUnitArr);
            return ProtoConverter.stringArray2Vector(strArr);
        }
        catch (ClassCastException e) {
            this.log.error("XmlRpc.XmlBlasterImpl.publish", "not a valid MsgUnitRaw: " + e.toString());
            throw new XmlBlasterException("Not a valid Message Unit", "Class Cast Exception");
        }
    }

    public void publishOneway(String sessionId, Vector msgUnitArrWrap) {
        int arrayLength;
        if (this.log.CALL) {
            this.log.call("XmlRpc.XmlBlasterImpl", "Entering publishOneway() ...");
        }
        if ((arrayLength = msgUnitArrWrap.size()) < 1) {
            if (this.log.TRACE) {
                this.log.trace("XmlRpc.XmlBlasterImpl", "Entering xmlBlaster.publishOneway(), nothing to do, zero msgUnits sent");
            }
            return;
        }
        try {
            MsgUnitRaw[] msgUnitArr = ProtoConverter.vector2MsgUnitRawArray(msgUnitArrWrap);
            this.blasterNative.publishOneway(sessionId, msgUnitArr);
        }
        catch (Throwable e) {
            this.log.error("XmlRpc.XmlBlasterImpl", "Caught exception which can't be delivered to client because of 'oneway' mode: " + e.toString());
        }
    }

    public Vector erase(String sessionId, String xmlKey_literal, String qos_literal) throws XmlBlasterException {
        if (this.log.CALL) {
            this.log.call("XmlRpc.XmlBlasterImpl", "Entering erase() xmlKey=\n" + xmlKey_literal + ") ...");
        }
        String[] retArr = this.blasterNative.erase(sessionId, xmlKey_literal, qos_literal);
        return ProtoConverter.stringArray2Vector(retArr);
    }

    public Vector get(String sessionId, String xmlKey_literal, String qos_literal) throws XmlBlasterException {
        if (this.log.CALL) {
            this.log.call("XmlRpc.XmlBlasterImpl", "Entering get() xmlKey=\n" + xmlKey_literal + ") ...");
        }
        StopWatch stop = null;
        if (this.log.TIME) {
            stop = new StopWatch();
        }
        MsgUnitRaw[] msgUnitArr = this.blasterNative.get(sessionId, xmlKey_literal, qos_literal);
        Vector msgUnitArrWrap = ProtoConverter.messageUnitArray2Vector(msgUnitArr);
        if (this.log.TIME) {
            this.log.time("XmlRpc.XmlBlasterImpl", "Elapsed time in get()" + stop.nice());
        }
        return msgUnitArrWrap;
    }

    public String ping(String qos) {
        return this.blasterNative.ping(qos);
    }

    public String toXml(String extraOffset) throws XmlBlasterException {
        return this.blasterNative.toXml(extraOffset);
    }
}

