/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.protocol.xmlrpc;

import java.io.IOException;
import org.apache.xmlrpc.WebServer;
import org.apache.xmlrpc.XmlRpc;
import org.jutils.log.LogChannel;
import org.xmlBlaster.engine.Global;
import org.xmlBlaster.engine.qos.AddressServer;
import org.xmlBlaster.protocol.I_Authenticate;
import org.xmlBlaster.protocol.I_Driver;
import org.xmlBlaster.protocol.I_XmlBlaster;
import org.xmlBlaster.protocol.xmlrpc.AuthenticateImpl;
import org.xmlBlaster.protocol.xmlrpc.XmlBlasterImpl;
import org.xmlBlaster.protocol.xmlrpc.XmlRpcUrl;
import org.xmlBlaster.util.XmlBlasterException;
import org.xmlBlaster.util.def.ErrorCode;
import org.xmlBlaster.util.plugin.PluginInfo;

public class XmlRpcDriver
implements I_Driver {
    private String ME = "XmlRpcDriver";
    private org.xmlBlaster.util.Global glob;
    private LogChannel log;
    private I_Authenticate authenticate = null;
    private I_XmlBlaster xmlBlasterImpl = null;
    public static final int DEFAULT_HTTP_PORT = 8080;
    private WebServer webServer;
    private XmlRpcUrl xmlRpcUrl;

    public String getName() {
        return this.ME;
    }

    public String getProtocolId() {
        return "XMLRPC";
    }

    public String getType() {
        return this.getProtocolId();
    }

    public String getVersion() {
        return "1.0";
    }

    public void init(org.xmlBlaster.util.Global glob, PluginInfo pluginInfo) throws XmlBlasterException {
        Global engineGlob = (Global)glob.getObjectEntry("ServerNodeScope");
        if (engineGlob == null) {
            throw new XmlBlasterException(this.glob, ErrorCode.INTERNAL_UNKNOWN, this.ME + ".init", "could not retreive the ServerNodeScope. Am I really on the server side ?");
        }
        try {
            this.authenticate = engineGlob.getAuthenticate();
            if (this.authenticate == null) {
                throw new XmlBlasterException(this.glob, ErrorCode.INTERNAL_UNKNOWN, this.ME + ".init", "authenticate object is null");
            }
            I_XmlBlaster xmlBlasterImpl = this.authenticate.getXmlBlaster();
            if (xmlBlasterImpl == null) {
                throw new XmlBlasterException(this.glob, ErrorCode.INTERNAL_UNKNOWN, this.ME + ".init", "xmlBlasterImpl object is null");
            }
            this.init(glob, new AddressServer(glob, this.getType(), glob.getId()), this.authenticate, xmlBlasterImpl);
            this.activate();
        }
        catch (XmlBlasterException ex) {
            throw ex;
        }
        catch (Throwable ex) {
            throw new XmlBlasterException(this.glob, ErrorCode.INTERNAL_UNKNOWN, this.ME + ".init", "init. Could'nt initialize the driver.", ex);
        }
    }

    public String getRawAddress() {
        return this.xmlRpcUrl.getUrl();
    }

    private synchronized void init(org.xmlBlaster.util.Global glob, AddressServer addressServer, I_Authenticate authenticate, I_XmlBlaster xmlBlasterImpl) throws XmlBlasterException {
        this.glob = glob;
        this.ME = "XmlRpcDriver" + this.glob.getLogPrefixDashed();
        this.log = glob.getLog("xmlrpc");
        if (this.log.CALL) {
            this.log.call(this.ME, "Entering init()");
        }
        this.authenticate = authenticate;
        this.xmlBlasterImpl = xmlBlasterImpl;
        this.xmlRpcUrl = new XmlRpcUrl(glob, addressServer);
        if (this.xmlRpcUrl.getPort() < 1) {
            this.log.info(this.ME, "Option plugin/xmlrpc/port set to " + this.xmlRpcUrl.getPort() + ", xmlRpc server not started");
            return;
        }
        if (addressServer.getEnv("debug", false).getValue()) {
            XmlRpc.setDebug(true);
        }
    }

    public synchronized void activate() throws XmlBlasterException {
        if (this.log.CALL) {
            this.log.call(this.ME, "Entering activate");
        }
        try {
            this.webServer = new WebServer(this.xmlRpcUrl.getPort(), this.xmlRpcUrl.getInetAddress());
            this.webServer.addHandler("authenticate", new AuthenticateImpl(this.glob, this.authenticate));
            this.webServer.addHandler("xmlBlaster", new XmlBlasterImpl(this.glob, this.xmlBlasterImpl));
            this.log.info(this.ME, "Started successfully XMLRPC driver, access url=" + this.xmlRpcUrl.getUrl());
        }
        catch (IOException e) {
            this.log.error(this.ME, "Error creating webServer on '" + this.xmlRpcUrl.getUrl() + "': " + e.toString());
        }
    }

    public synchronized void deActivate() throws XmlBlasterException {
        if (this.log.CALL) {
            this.log.call(this.ME, "Entering deActivate");
        }
        if (this.webServer != null) {
            try {
                this.webServer.removeHandler("authenticate");
                this.webServer.removeHandler("xmlBlaster");
                this.webServer.shutdown();
            }
            catch (Throwable e) {
                this.log.warn(this.ME, "Problems during shutdown of xmlrpc web server: " + e.toString());
            }
            this.webServer = null;
            this.log.info(this.ME, "XMLRPC driver stopped, handler released.");
        } else {
            this.log.info(this.ME, "XMLRPC shutdown, nothing to do.");
        }
    }

    public void shutdown() throws XmlBlasterException {
        try {
            this.deActivate();
        }
        catch (XmlBlasterException e) {
            this.log.error(this.ME, e.toString());
        }
    }

    public String usage() {
        String text = "\n";
        text = text + "XmlRpcDriver options:\n";
        text = text + "   -plugin/xmlrpc/port\n";
        text = text + "                       The XMLRPC web server port [8080].\n";
        text = text + "   -plugin/xmlrpc/hostname\n";
        text = text + "                       Specify a hostname where the XMLRPC web server runs.\n";
        text = text + "                       Default is the localhost.\n";
        text = text + "   -plugin/xmlrpc/debug\n";
        text = text + "                       true switches on detailed XMLRPC debugging [false].\n";
        text = text + "\n";
        return text;
    }
}

