/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.protocol.xmlrpc;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.jutils.log.LogChannel;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.XmlBlasterException;
import org.xmlBlaster.util.def.ErrorCode;
import org.xmlBlaster.util.qos.address.AddressBase;

public class XmlRpcUrl {
    private String ME = "XmlRpcUrl";
    private Global glob;
    private LogChannel log;
    private String hostname;
    private InetAddress inetAddress;
    private int port = 8080;
    private boolean isLocal = false;

    public XmlRpcUrl(Global glob, String hostname, int port) throws XmlBlasterException {
        this.glob = glob;
        this.log = this.glob.getLog("xmlrpc");
        this.hostname = hostname;
        if (this.hostname == null || this.hostname.length() < 1) {
            this.hostname = glob.getLocalIP();
        }
        this.port = port;
        this.createInetAddress();
    }

    public XmlRpcUrl(Global glob, String url) throws XmlBlasterException {
        this.glob = glob;
        this.log = this.glob.getLog("xmlrpc");
        this.parse(url);
        this.createInetAddress();
    }

    public XmlRpcUrl(Global glob, AddressBase address) throws XmlBlasterException {
        this(glob, address, false, 8080);
    }

    public XmlRpcUrl(Global glob, AddressBase address, boolean isLocal, int defaultServerPort) throws XmlBlasterException {
        this.glob = glob;
        this.log = this.glob.getLog("xmlrpc");
        if (isLocal) {
            this.isLocal = true;
            this.port = address.getEnv("localPort", defaultServerPort).getValue();
            this.hostname = address.getEnv("localHostname", glob.getLocalIP()).getValue();
        } else {
            if (address.getRawAddress() != null && address.getRawAddress().length() > 2) {
                this.parse(address.getRawAddress());
                this.createInetAddress();
                return;
            }
            this.port = address.getEnv("port", defaultServerPort).getValue();
            this.hostname = address.getEnv("hostname", glob.getLocalIP()).getValue();
            address.setRawAddress(this.getUrl());
        }
        this.createInetAddress();
    }

    public String getHostname() {
        return this.hostname;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getUrl() {
        return "http://" + this.hostname + ":" + this.port + "/";
    }

    public String toString() {
        return this.getUrl();
    }

    private void parse(String url) throws XmlBlasterException {
        if (url == null) {
            throw new XmlBlasterException(this.glob, ErrorCode.RESOURCE_CONFIGURATION_ADDRESS, this.ME, "Your given XMLRPC url '" + url + "' is invalid");
        }
        String urlLowerCase = url.toLowerCase();
        if (urlLowerCase.startsWith("http://")) {
            url = url.substring("http://".length());
        } else if (urlLowerCase.startsWith("http:")) {
            url = url.substring("http:".length());
        }
        int pos = url.indexOf(":");
        String portStr = null;
        if (pos > -1) {
            this.hostname = url.substring(0, pos);
            portStr = url.substring(pos + 1);
            if (portStr != null && portStr.length() > 0) {
                pos = portStr.indexOf("/");
                if (pos > -1) {
                    portStr = portStr.substring(0, pos);
                }
                try {
                    this.port = new Integer(portStr);
                }
                catch (NumberFormatException e) {
                    throw new XmlBlasterException(this.glob, ErrorCode.RESOURCE_CONFIGURATION_ADDRESS, this.ME, "Your given XMLRPC url '" + url + "' port '" + portStr + "' is invalid");
                }
            }
        } else {
            this.hostname = url;
        }
        if (this.hostname == null || this.hostname.length() < 1) {
            this.hostname = this.glob.getLocalIP();
        }
    }

    public InetAddress getInetAddress() {
        return this.inetAddress;
    }

    private void createInetAddress() throws XmlBlasterException {
        try {
            this.inetAddress = InetAddress.getByName(this.hostname);
        }
        catch (UnknownHostException e) {
            Thread.currentThread();
            Thread.dumpStack();
            String txt = "The hostname [" + this.hostname + "] of url '" + this.getUrl() + "' is invalid, check your '-plugin/xmlrpc/" + (this.isLocal ? "localHostname" : "hostname") + " <ip>' setting: " + e.toString();
            this.log.warn(this.ME, txt);
            throw new XmlBlasterException(this.glob, ErrorCode.RESOURCE_CONFIGURATION_ADDRESS, this.ME, txt);
        }
    }

    public boolean equals(XmlRpcUrl other) {
        return this.port == other.getPort() && this.getInetAddress().equals(other.getInetAddress());
    }

    public static void main(String[] args) {
        try {
            if (args.length > 0) {
                XmlRpcUrl s = new XmlRpcUrl(Global.instance(), args[0]);
                System.out.println(args[0] + " -> " + s.getUrl() + " hostname=" + s.getHostname() + " port=" + s.getPort());
            }
        }
        catch (Throwable e) {
            System.out.println("ERROR: " + e.toString());
        }
    }
}

