/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.test.C;

import java.io.File;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.jutils.log.LogChannel;
import org.xmlBlaster.util.EmbeddedXmlBlaster;
import org.xmlBlaster.util.Execute;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.I_ExecuteListener;

public class TestC
extends TestCase
implements I_ExecuteListener {
    private static String ME = "TestC";
    private final Global glob;
    private final LogChannel log;
    private EmbeddedXmlBlaster serverThread;
    private int serverPort = 7615;
    private String pathToCBinary = null;
    String sep = File.separator;

    public TestC(String testName) {
        super(testName);
        this.glob = Global.instance();
        this.log = this.glob.getLog(null);
    }

    protected void setUp() {
        String xmlBlasterHome = this.getXmlBlasterHomePath();
        this.pathToCBinary = xmlBlasterHome + this.sep + "testsuite" + this.sep + "src" + this.sep + "c" + this.sep + "bin";
        File f = new File(this.pathToCBinary);
        this.log.trace(ME, "Looking under '" + f.toString() + "'");
        if (f.exists()) {
            this.log.info(ME, "Found C executables under '" + this.pathToCBinary + "'");
        }
        Assert.assertTrue("Path to C binaries not found, no testing of C client library is not possible", this.pathToCBinary != null);
    }

    private String getXmlBlasterHomePath() {
        String xmlBlasterHome = this.glob.getProperty().get("XMLBLASTER_HOME", "$HOME" + this.sep + "xmlBlaster");
        File f = new File(xmlBlasterHome);
        if (f.exists()) {
            return xmlBlasterHome;
        }
        xmlBlasterHome = "..";
        f = new File(xmlBlasterHome + "RELEASE_NOTES");
        if (f.exists()) {
            return xmlBlasterHome;
        }
        int i = 0;
        while (i < 10) {
            f = new File((xmlBlasterHome = xmlBlasterHome + this.sep + "..") + this.sep + "RELEASE_NOTES");
            if (f.exists()) {
                return xmlBlasterHome;
            }
            ++i;
        }
        return null;
    }

    protected void tearDown() {
    }

    public void test_C_MethodInvocations() {
        Runtime runtime = Runtime.getRuntime();
        String[] commandArr = new String[]{this.pathToCBinary + this.sep + "TestMethods"};
        String[] envArr = new String[]{""};
        this.log.info(ME, "######## Start test_C_MethodInvocations('" + commandArr[0] + "')");
        Execute e = new Execute(this.glob, commandArr, envArr);
        e.setExecuteListener(this);
        e.run();
        if (e.getExitValue() != 0) {
            Assert.fail("C client library test '" + commandArr[0] + "' + failed exit=" + e.getExitValue() + ": " + e.getStderr());
        }
        if (e.getErrorText() != null) {
            Assert.fail(e.getErrorText());
        }
        if (e.getStdout().indexOf("[TEST FAIL]") != -1) {
            Assert.fail("C client library test '" + commandArr[0] + "' + failed: " + e.getStdout());
        }
        if (e.getStderr().indexOf("[TEST FAIL]") != -1) {
            Assert.fail("C client library test '" + commandArr[0] + "' + failed: " + e.getStderr());
        }
        this.log.info(ME, "######## SUCCESS test_C_MethodInvocations('" + commandArr[0] + "') exit=" + e.getExitValue() + " : " + e.getStdout());
    }

    public void test_C_IllegalArguments() {
        Runtime runtime = Runtime.getRuntime();
        String[] commandArr = new String[]{this.pathToCBinary + this.sep + "TestError"};
        String[] envArr = new String[]{""};
        this.log.info(ME, "######## Start test_C_IllegalArguments('" + commandArr[0] + "')");
        Execute e = new Execute(this.glob, commandArr, envArr);
        e.setExecuteListener(this);
        e.run();
        if (e.getExitValue() != 0) {
            Assert.fail("C client library test '" + commandArr[0] + "' + failed exit=" + e.getExitValue() + ": " + e.getStderr());
        }
        if (e.getErrorText() != null) {
            Assert.fail(e.getErrorText());
        }
        if (e.getStdout().indexOf("[TEST FAIL]") != -1) {
            Assert.fail("C client library test '" + commandArr[0] + "' + failed: " + e.getStdout());
        }
        if (e.getStderr().indexOf("[TEST FAIL]") != -1) {
            Assert.fail("C client library test '" + commandArr[0] + "' + failed: " + e.getStderr());
        }
        this.log.info(ME, "######## SUCCESS test_C_IllegalArguments('" + commandArr[0] + "') exit=" + e.getExitValue() + " : " + e.getStdout());
    }

    public void test_C_Stress() {
        Runtime runtime = Runtime.getRuntime();
        String[] commandArr = new String[]{this.pathToCBinary + this.sep + "TestStress"};
        String[] envArr = new String[]{""};
        this.log.info(ME, "######## Start test_C_Stress('" + commandArr[0] + "')");
        Execute e = new Execute(this.glob, commandArr, envArr);
        e.setExecuteListener(this);
        e.run();
        if (e.getExitValue() != 0) {
            Assert.fail("C client library test '" + commandArr[0] + "' + failed exit=" + e.getExitValue() + ": " + e.getStderr());
        }
        if (e.getErrorText() != null) {
            Assert.fail(e.getErrorText());
        }
        if (e.getStdout().indexOf("[TEST FAIL]") != -1) {
            Assert.fail("C client library test '" + commandArr[0] + "' + failed: " + e.getStdout());
        }
        if (e.getStderr().indexOf("[TEST FAIL]") != -1) {
            Assert.fail("C client library test '" + commandArr[0] + "' + failed: " + e.getStderr());
        }
        this.log.info(ME, "######## SUCCESS test_C_Stress('" + commandArr[0] + "') exit=" + e.getExitValue() + " : " + e.getStdout());
    }

    public void test_C_Util() {
        Runtime runtime = Runtime.getRuntime();
        String[] commandArr = new String[]{this.pathToCBinary + this.sep + "TestUtil"};
        String[] envArr = new String[]{""};
        this.log.info(ME, "######## Start test_C_Util('" + commandArr[0] + "')");
        Execute e = new Execute(this.glob, commandArr, envArr);
        e.setExecuteListener(this);
        e.run();
        if (e.getExitValue() != 0) {
            Assert.fail("C client library test '" + commandArr[0] + "' + failed exit=" + e.getExitValue() + ": " + e.getStderr());
        }
        if (e.getErrorText() != null) {
            Assert.fail(e.getErrorText());
        }
        if (e.getStdout().indexOf("[TEST FAIL]") != -1) {
            Assert.fail("C client library test '" + commandArr[0] + "' + failed: " + e.getStdout());
        }
        if (e.getStderr().indexOf("[TEST FAIL]") != -1) {
            Assert.fail("C client library test '" + commandArr[0] + "' + failed: " + e.getStderr());
        }
        this.log.info(ME, "######## SUCCESS test_C_Util('" + commandArr[0] + "') exit=" + e.getExitValue() + " : " + e.getStdout());
    }

    public void test_C_Queue() {
        Runtime runtime = Runtime.getRuntime();
        String[] commandArr = new String[]{this.pathToCBinary + this.sep + "TestQueue"};
        String[] envArr = new String[]{""};
        this.log.info(ME, "######## Start test_C_Queue('" + commandArr[0] + "')");
        Execute e = new Execute(this.glob, commandArr, envArr);
        e.setExecuteListener(this);
        e.run();
        if (e.getExitValue() != 0) {
            Assert.fail("C client library test '" + commandArr[0] + "' + failed exit=" + e.getExitValue() + ": " + e.getStderr());
        }
        if (e.getErrorText() != null) {
            Assert.fail(e.getErrorText());
        }
        if (e.getStdout().indexOf("[TEST FAIL]") != -1) {
            Assert.fail("C client library test '" + commandArr[0] + "' + failed: " + e.getStdout());
        }
        if (e.getStderr().indexOf("[TEST FAIL]") != -1) {
            Assert.fail("C client library test '" + commandArr[0] + "' + failed: " + e.getStderr());
        }
        this.log.info(ME, "######## SUCCESS test_C_Queue('" + commandArr[0] + "') exit=" + e.getExitValue() + " : " + e.getStdout());
    }

    public void stdout(String data) {
        this.log.info(ME, "Native C output: " + data);
    }

    public void stderr(String data) {
        this.log.error(ME, "Native C output: " + data);
    }

    public static void main(String[] args) {
        Global glob = Global.instance();
        if (glob.init(args) != 0) {
            System.err.println("Init failed");
            System.exit(1);
        }
        TestC test = new TestC("TestC");
        test.setUp();
        test.test_C_Util();
        test.test_C_MethodInvocations();
        test.test_C_IllegalArguments();
        test.test_C_Queue();
        test.test_C_Stress();
        test.tearDown();
    }
}

